/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.buildinfo.service;

import com.atlassian.jira.cloud.jenkins.Messages;
import com.atlassian.jira.cloud.jenkins.buildinfo.client.model.BuildApiResponse;
import hudson.model.Run;
import java.util.Objects;

public class JiraBuildInfoResponse {
    private final Run build;
    private final Status status;
    private final String message;

    private JiraBuildInfoResponse(Run build, Status status, String message) {
        this.build = Objects.requireNonNull(build);
        this.status = Objects.requireNonNull(status);
        this.message = Objects.requireNonNull(message);
    }

    public Status getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public static JiraBuildInfoResponse successBuildAccepted(Run build, String jiraSite, BuildApiResponse response) {
        String message = Messages.JiraBuildInfoResponse_SUCCESS_BUILD_ACCEPTED(jiraSite, response.getAcceptedBuilds());
        return new JiraBuildInfoResponse(build, Status.SUCCESS_BUILD_ACCEPTED, message);
    }

    public static JiraBuildInfoResponse failureBuildRejected(Run build, String jiraSite, BuildApiResponse response) {
        String message = Messages.JiraBuildInfoResponse_FAILURE_BUILD_REJECTED(jiraSite, response.getRejectedBuilds());
        return new JiraBuildInfoResponse(build, Status.FAILURE_BUILD_REJECTED, message);
    }

    public static JiraBuildInfoResponse failureUnknownIssueKeys(Run build, String jiraSite, BuildApiResponse response) {
        String message = Messages.JiraBuildInfoResponse_FAILURE_UNKNOWN_ISSUE_KEYS(jiraSite, response.getUnknownIssueKeys());
        return new JiraBuildInfoResponse(build, Status.FAILURE_UNKNOWN_ISSUE_KEYS, message);
    }

    public static JiraBuildInfoResponse failureSiteConfigNotFound(Run build, String jiraSite) {
        String message = Messages.JiraBuildInfoResponse_FAILURE_SITE_CONFIG_NOT_FOUND(jiraSite);
        return new JiraBuildInfoResponse(build, Status.FAILURE_SITE_CONFIG_NOT_FOUND, message);
    }

    public static JiraBuildInfoResponse failureSecretNotFound(Run build, String jiraSite) {
        String message = Messages.JiraBuildInfoResponse_FAILURE_SECRET_NOT_FOUND(jiraSite);
        return new JiraBuildInfoResponse(build, Status.FAILURE_SECRET_NOT_FOUND, message);
    }

    public static JiraBuildInfoResponse failureScmRevisionNotFound(Run build) {
        String message = Messages.JiraBuildInfoResponse_FAILURE_SCM_REVISION_NOT_FOUND(build.getDisplayName());
        return new JiraBuildInfoResponse(build, Status.FAILURE_SCM_REVISION_NOT_FOUND, message);
    }

    public static JiraBuildInfoResponse failureSiteNotFound(Run build, String jiraSite) {
        String message = Messages.JiraBuildInfoResponse_FAILURE_SITE_NOT_FOUND(jiraSite);
        return new JiraBuildInfoResponse(build, Status.FAILURE_SITE_NOT_FOUND, message);
    }

    public static JiraBuildInfoResponse failureAccessToken(Run build, String jiraSite) {
        String message = Messages.JiraBuildInfoResponse_FAILURE_ACCESS_TOKEN(jiraSite);
        return new JiraBuildInfoResponse(build, Status.FAILURE_ACCESS_TOKEN, message);
    }

    public static JiraBuildInfoResponse failureBuildsApiResponse(Run build, String jiraSite) {
        String message = Messages.JiraBuildInfoResponse_FAILURE_BUILDS_API_RESPONSE(jiraSite);
        return new JiraBuildInfoResponse(build, Status.FAILURE_BUILDS_API_RESPONSE, message);
    }

    public static JiraBuildInfoResponse failureUnexpectedResponse(Run build, String jiraSite) {
        String message = Messages.JiraBuildInfoResponse_FAILURE_UNEXPECTED_RESPONSE();
        return new JiraBuildInfoResponse(build, Status.FAILURE_UNEXPECTED_RESPONSE, message);
    }

    public static JiraBuildInfoResponse skippedIssueKeysNotFound(Run build, String branchName) {
        String message = Messages.JiraBuildInfoResponse_SKIPPED_ISSUE_KEYS_NOT_FOUND(branchName);
        return new JiraBuildInfoResponse(build, Status.SKIPPED_ISSUE_KEYS_NOT_FOUND, message);
    }

    public static enum Status {
        SUCCESS_BUILD_ACCEPTED,
        FAILURE_BUILD_REJECTED,
        FAILURE_UNKNOWN_ISSUE_KEYS,
        FAILURE_SITE_CONFIG_NOT_FOUND,
        FAILURE_SECRET_NOT_FOUND,
        FAILURE_SCM_REVISION_NOT_FOUND,
        FAILURE_SITE_NOT_FOUND,
        FAILURE_ACCESS_TOKEN,
        FAILURE_BUILDS_API_RESPONSE,
        FAILURE_UNEXPECTED_RESPONSE,
        SKIPPED_ISSUE_KEYS_NOT_FOUND;

    }
}

