/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.buildinfo.pipeline;

import com.atlassian.jira.cloud.jenkins.Messages;
import com.atlassian.jira.cloud.jenkins.buildinfo.service.JiraBuildInfoRequest;
import com.atlassian.jira.cloud.jenkins.buildinfo.service.JiraBuildInfoResponse;
import com.atlassian.jira.cloud.jenkins.buildinfo.service.JiraBuildInfoSenderFactory;
import com.atlassian.jira.cloud.jenkins.config.JiraCloudPluginConfig;
import com.atlassian.jira.cloud.jenkins.config.JiraCloudSiteConfig;
import com.google.common.collect.ImmutableSet;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class JiraSendBuildInfoStep
extends Step
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String site;

    @DataBoundConstructor
    public JiraSendBuildInfoStep(String site) {
        this.site = site;
    }

    public String getSite() {
        return this.site;
    }

    @DataBoundSetter
    public void setSite(String site) {
        this.site = site;
    }

    public StepExecution start(StepContext stepContext) throws Exception {
        return new JiraSendBuildInfoStepExecution(stepContext, this);
    }

    public static class JiraSendBuildInfoStepExecution
    extends SynchronousNonBlockingStepExecution<JiraBuildInfoResponse> {
        private final JiraSendBuildInfoStep step;

        public JiraSendBuildInfoStepExecution(StepContext context, JiraSendBuildInfoStep step) {
            super(context);
            this.step = step;
        }

        protected JiraBuildInfoResponse run() throws Exception {
            TaskListener taskListener = (TaskListener)this.getContext().get(TaskListener.class);
            Run build = (Run)this.getContext().get(Run.class);
            JiraBuildInfoRequest request = new JiraBuildInfoRequest(this.step.getSite(), build);
            JiraBuildInfoResponse response = JiraBuildInfoSenderFactory.getInstance().getJiraBuildInfoSender().sendBuildInfo(request);
            this.logResult(taskListener, response);
            return response;
        }

        private void logResult(TaskListener taskListener, JiraBuildInfoResponse response) {
            taskListener.getLogger().println("jiraSendBuildInfo: " + (Object)((Object)response.getStatus()) + ": " + response.getMessage());
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        @Inject
        private transient JiraCloudPluginConfig globalConfig;

        public Set<Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class, Run.class);
        }

        public String getFunctionName() {
            return "jiraSendBuildInfo";
        }

        public String getDisplayName() {
            return Messages.JiraSendBuildInfoStep_DescriptorImpl_DisplayName();
        }

        public ListBoxModel doFillSiteItems() {
            ListBoxModel items = new ListBoxModel();
            List<JiraCloudSiteConfig> siteList = this.globalConfig.getSites();
            for (JiraCloudSiteConfig siteConfig : siteList) {
                items.add(siteConfig.getSite(), siteConfig.getSite());
            }
            return items;
        }
    }
}

