/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.buildinfo.client;

import com.atlassian.jira.cloud.jenkins.buildinfo.client.model.JiraBuildInfo;
import hudson.AbortException;
import java.time.Instant;
import java.util.Set;
import org.jenkinsci.plugins.workflow.support.steps.build.RunWrapper;

public final class BuildPayloadBuilder {
    private static final String STATUS_SUCCESSFUL = "successful";
    private static final String STATUS_FAILED = "failed";
    private static final String STATUS_UNKNOWN = "unknown";

    public static JiraBuildInfo getBuildInfo(RunWrapper buildWrapper, Set<String> issueKeys) {
        try {
            return JiraBuildInfo.builder().withPipelineId(buildWrapper.getFullProjectName()).withBuildNumber(buildWrapper.getNumber()).withDisplayName(buildWrapper.getDisplayName()).withUpdateSequenceNumber(Instant.now().getEpochSecond()).withLabel(buildWrapper.getDisplayName()).withUrl(buildWrapper.getAbsoluteUrl()).withState(BuildPayloadBuilder.getBuildStatus(buildWrapper.getCurrentResult())).withLastUpdated(Instant.now().toString()).withIssueKeys(issueKeys).build();
        }
        catch (AbortException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getBuildStatus(String result) {
        if ("SUCCESS".equalsIgnoreCase(result)) {
            return STATUS_SUCCESSFUL;
        }
        if ("FAILURE".equalsIgnoreCase(result)) {
            return STATUS_FAILED;
        }
        return STATUS_UNKNOWN;
    }
}

