/*
 * Decompiled with CFR 0.152.
 */
package com.arkea.satd.stoplightio.parsers;

import com.arkea.satd.stoplightio.model.Assertion;
import com.arkea.satd.stoplightio.model.Collection;
import com.arkea.satd.stoplightio.model.Scenario;
import com.arkea.satd.stoplightio.model.Step;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

public final class JsonResultParser {
    private JsonResultParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection parse(InputStream resultFile) throws UnsupportedEncodingException {
        Collection collection = new Collection();
        int totalTests = 0;
        int succeededTests = 0;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            isr = new InputStreamReader(resultFile, StandardCharsets.UTF_8);
            br = new BufferedReader(isr);
            JsonObject jsonObj = new JsonParser().parse((Reader)br).getAsJsonObject();
            for (String firstLevelKey : new String[]{"before", "scenarios", "after"}) {
                if (!jsonObj.has(firstLevelKey)) continue;
                JsonObject section = jsonObj.getAsJsonObject(firstLevelKey);
                for (String scenId : section.keySet()) {
                    JsonObject scen = section.getAsJsonObject(scenId);
                    JsonElement scenName = scen.get("name");
                    Scenario currentScenario = new Scenario();
                    currentScenario.setLabel(scenName.getAsString());
                    double time = scen.get("time").getAsDouble() / 1000.0;
                    currentScenario.setDuration(time + "s");
                    collection.getScenarios().add(currentScenario);
                    JsonArray steps = scen.getAsJsonArray("steps");
                    int stepsCount = steps.size();
                    for (int i = 0; i < stepsCount; ++i) {
                        JsonObject step = steps.get(i).getAsJsonObject();
                        JsonElement name = step.get("name");
                        Step currentStep = new Step();
                        currentStep.setLabel(name == null ? "" : name.getAsString());
                        double stepTime = step.get("time").getAsDouble() / 1000.0;
                        currentStep.setDuration(stepTime + "s");
                        if ("http".equals(step.get("type").getAsString())) {
                            JsonObject input = step.get("input").getAsJsonObject();
                            currentStep.setVerb(input.get("method").getAsString());
                            currentStep.setUrl(input.get("url").getAsString());
                        } else {
                            currentStep.setVerb("");
                            currentStep.setUrl("");
                        }
                        currentScenario.getSteps().add(currentStep);
                        JsonObject after = step.getAsJsonObject("after");
                        if (after == null) continue;
                        JsonArray assertions = after.getAsJsonArray("assertions");
                        int assertionsCount = assertions.size();
                        for (int j = 0; j < assertionsCount; ++j) {
                            JsonObject assertion = assertions.get(j).getAsJsonObject();
                            JsonElement target = assertion.get("target");
                            JsonElement pass = assertion.get("pass");
                            Assertion assrt = new Assertion();
                            assrt.setSuccess(pass != null ? pass.getAsBoolean() : false);
                            assrt.setMessage(target.getAsString() + " (" + assertion.get("op").getAsString() + ") " + (assertion.get("expected").isJsonObject() ? "against JSON Schema" : assertion.get("expected").getAsString()));
                            currentStep.getAssertions().add(assrt);
                            ++totalTests;
                            if (!assrt.isSuccess()) continue;
                            ++succeededTests;
                        }
                    }
                }
            }
        }
        finally {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException iOException) {}
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        collection.setTotalTests(totalTests);
        collection.setSucceededTests(succeededTests);
        collection.setTotalTests(totalTests);
        collection.setSucceededTests(succeededTests);
        return collection;
    }
}

