/*
 * Decompiled with CFR 0.152.
 */
package com.arkea.satd.stoplightio.parsers;

import com.arkea.satd.stoplightio.model.Assertion;
import com.arkea.satd.stoplightio.model.Collection;
import com.arkea.satd.stoplightio.model.Scenario;
import com.arkea.satd.stoplightio.model.Step;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ConsoleParser {
    private static final Pattern SCENARIO_LINE_PATTERN = Pattern.compile("^\\s{4}(\\S.*) \\((.*)\\)");
    private static final Pattern STEP_LINE_PATTERN = Pattern.compile("^\\s{6}(.*), (.*) (.*) \\((.*)\\)");
    private static final Pattern ASSERTION_LINE_PATTERN = Pattern.compile("^\\s{9}(\\S)  (.*)");
    private static final String SUCCESS_MARK = new String(new byte[]{-30, -100, -109}, Charset.forName("UTF-8"));

    private ConsoleParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection parse(InputStream consoleFile) {
        Collection collection = new Collection();
        int totalTests = 0;
        int succeededTests = 0;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            isr = new InputStreamReader(consoleFile, "UTF-8");
            br = new BufferedReader(isr);
            Scenario currentScenario = null;
            Step currentStep = null;
            String line = null;
            while ((line = br.readLine()) != null) {
                Matcher m = SCENARIO_LINE_PATTERN.matcher(line);
                if (m.matches()) {
                    currentScenario = new Scenario();
                    currentScenario.setLabel(m.group(1));
                    currentScenario.setDuration(m.group(2));
                    collection.getScenarios().add(currentScenario);
                }
                if ((m = STEP_LINE_PATTERN.matcher(line)).matches()) {
                    currentStep = new Step();
                    currentStep.setLabel(m.group(1));
                    currentStep.setVerb(m.group(2));
                    currentStep.setUrl(m.group(3));
                    currentStep.setDuration(m.group(4));
                    currentScenario.getSteps().add(currentStep);
                }
                if (!(m = ASSERTION_LINE_PATTERN.matcher(line)).matches()) continue;
                Assertion assertion = new Assertion();
                assertion.setSuccess(SUCCESS_MARK.equals(m.group(1)));
                assertion.setMessage(m.group(2));
                if (currentStep.getAssertions() == null) {
                    currentStep.setAssertions(new ArrayList<Assertion>());
                }
                currentStep.getAssertions().add(assertion);
                ++totalTests;
                if (!assertion.isSuccess()) continue;
                ++succeededTests;
            }
            br.close();
        }
        catch (IOException e) {
            Logger logger = LogManager.getLogManager().getLogger("hudson.WebAppMain");
            logger.log(Level.SEVERE, "Error while parsing the console default output", e);
        }
        finally {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException iOException) {}
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        collection.setTotalTests(totalTests);
        collection.setSucceededTests(succeededTests);
        return collection;
    }
}

