/*
 * Decompiled with CFR 0.152.
 */
package com.arkea.satd.stoplightio;

import com.arkea.satd.stoplightio.StoplightReportBuildAction;
import com.arkea.satd.stoplightio.model.Collection;
import com.arkea.satd.stoplightio.parsers.ConsoleParser;
import com.arkea.satd.stoplightio.parsers.JsonResultParser;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class StoplightReportPublisher
extends Recorder
implements SimpleBuildStep {
    private final String consoleOrFile;
    private final String resultFile;
    private static final String CONSOLE = "console";

    @DataBoundConstructor
    public StoplightReportPublisher(String consoleOrFile, String resultFile) {
        this.consoleOrFile = consoleOrFile;
        this.resultFile = resultFile;
    }

    public String getConsoleOrFile() {
        return this.consoleOrFile;
    }

    public static String getConsole() {
        return CONSOLE;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public String getResultFile() {
        return this.resultFile;
    }

    public String isTestType(String testTypeName) {
        if (this.consoleOrFile == null) {
            return CONSOLE.equals(testTypeName) ? "true" : "";
        }
        return this.consoleOrFile.equalsIgnoreCase(testTypeName) ? "true" : "";
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        return this.perform((Run<?, ?>)build, (TaskListener)listener, build.getWorkspace());
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener taskListener) {
        this.perform(run, taskListener, workspace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean perform(Run<?, ?> build, TaskListener taskListener, FilePath ws) {
        FilePath f;
        if (this.consoleOrFile == null || this.consoleOrFile.isEmpty() || CONSOLE.equals(this.consoleOrFile)) {
            f = new FilePath(build.getLogFile());
        } else {
            String wsBasePath = "";
            try {
                wsBasePath = (String)build.getEnvironment(taskListener).get((Object)"WORKSPACE");
            }
            catch (IOException | InterruptedException e) {
                taskListener.getLogger().println("The environment variable WORKSPACE doesn't exists");
                Logger log = LogManager.getLogManager().getLogger("hudson.WebAppMain");
                log.log(Level.SEVERE, "The environment variable WORKSPACE doesn't exists", e);
            }
            if (wsBasePath == null) {
                wsBasePath = "";
            }
            String prepareFileLocation = this.resultFile.replace("${WORKSPACE}", wsBasePath).replace("%WORKSPACE%", wsBasePath);
            f = new FilePath(ws, prepareFileLocation);
        }
        try {
            Collection coll;
            if (!f.exists()) {
                throw new FileNotFoundException();
            }
            if (taskListener != null) {
                taskListener.getLogger().println("Parsing " + f.toURI());
            }
            InputStream is = f.read();
            try {
                coll = JsonResultParser.parse(is);
            }
            catch (Exception e) {
                coll = ConsoleParser.parse(is);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
            StoplightReportBuildAction buildAction = new StoplightReportBuildAction(build, coll);
            build.addAction((Action)buildAction);
            return true;
        }
        catch (IOException | InterruptedException e) {
            if (taskListener != null) {
                taskListener.getLogger().println("The file " + f.getName() + " doesn't exists");
            }
            return false;
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckResultFile(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a path");
            }
            if (value.length() < 4) {
                return FormValidation.warning((String)"Isn't the path too short?");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Publish Stoplight Report";
        }
    }
}

