/*
 * Decompiled with CFR 0.152.
 */
package com.arkea.satd.stoplightio;

import com.arkea.satd.stoplightio.StoplightReportProjectAction;
import com.arkea.satd.stoplightio.model.Collection;
import com.arkea.satd.stoplightio.model.Scenario;
import com.arkea.satd.stoplightio.model.Step;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jenkins.tasks.SimpleBuildStep;

public class StoplightReportBuildAction
implements Action,
SimpleBuildStep.LastBuildAction {
    private Run<?, ?> build;
    private Collection collection;

    public StoplightReportBuildAction(Run<?, ?> build, Collection collection) {
        this.build = build;
        this.collection = collection;
    }

    public String getDisplayName() {
        return "Scenario Execution Report";
    }

    public String getIconFileName() {
        return "/plugin/stoplightio-report/img/scenarios.png";
    }

    public String getUrlName() {
        return "stoplightBuildReport";
    }

    public int getBuildNumber() {
        return this.build.number;
    }

    public Date getBuildDate() {
        return this.build.getTime();
    }

    public Run<?, ?> getBuild() {
        return this.build;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public String getResult() {
        Result r = this.build.getResult();
        if (r != null) {
            return r.toString();
        }
        return "";
    }

    public boolean isSuccess() {
        Result r = this.build.getResult();
        if (r != null) {
            return r == Result.SUCCESS;
        }
        return false;
    }

    public boolean getIsSuccess() {
        return this.isSuccess();
    }

    public int getAssertionsCount() {
        return this.collection.getTotalTests();
    }

    public int getSucceededAssertionsCount() {
        return this.collection.getSucceededTests();
    }

    public int getFailedAssertionsCount() {
        return this.collection.getTotalTests() - this.collection.getSucceededTests();
    }

    public int getScenariosCount() {
        return this.collection.getScenarios().size();
    }

    public int getStepsCount() {
        int count = 0;
        List<Scenario> scenList = this.collection.getScenarios();
        for (Scenario s : scenList) {
            count += s.getSteps().size();
        }
        return count;
    }

    public int getNoAssertionCount() {
        int count = 0;
        List<Scenario> scenList = this.collection.getScenarios();
        for (Scenario scen : scenList) {
            for (Step st : scen.getSteps()) {
                if (!st.getAssertions().isEmpty()) continue;
                ++count;
            }
        }
        return count;
    }

    public java.util.Collection<? extends Action> getProjectActions() {
        ArrayList<StoplightReportProjectAction> projectActions = new ArrayList<StoplightReportProjectAction>();
        projectActions.add(new StoplightReportProjectAction(this.build.getParent()));
        return projectActions;
    }
}

