/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codebuild.jenkinsplugin;

import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.codebuild.model.InvalidInputException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class Validation {
    public static final String invalidDefaultCredentialsError = "AWS credentials couldn't be loaded from the default provider chain";
    public static final String invalidCredTypeError = "Invalid credentialsType option; must be 'jenkins' or 'keys'";
    public static final String invalidSecretKeyError = "awsSecretKey cannot be null";
    public static final String stepCredentials = "Using credentials provided by the Jenkins step context for authorization";

    public static String sanitize(String s) {
        if (s == null) {
            return "";
        }
        return StringEscapeUtils.escapeSql((String)StringEscapeUtils.escapeHtml((String)s.trim()));
    }

    public static Integer parseInt(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        return Integer.parseInt(s);
    }

    public static String sanitizeYAML(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("\t", " ");
    }

    public static AWSCredentialsProvider getBasicCredentialsOrDefaultChain(String accessKey, String secretKey) {
        return Validation.getBasicCredentialsOrDefaultChain(accessKey, secretKey, "");
    }

    public static AWSCredentialsProvider getBasicCredentialsOrDefaultChain(String accessKey, String secretKey, String awsSessionToken) {
        DefaultAWSCredentialsProviderChain result;
        if (StringUtils.isNotEmpty((String)accessKey) && StringUtils.isNotEmpty((String)secretKey) && StringUtils.isNotEmpty((String)awsSessionToken)) {
            result = new AWSStaticCredentialsProvider((AWSCredentials)new BasicSessionCredentials(accessKey, secretKey, awsSessionToken));
        } else if (StringUtils.isNotEmpty((String)accessKey) && StringUtils.isNotEmpty((String)secretKey)) {
            result = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey));
        } else {
            result = DefaultAWSCredentialsProviderChain.getInstance();
            try {
                result.getCredentials();
            }
            catch (SdkClientException e) {
                throw new InvalidInputException(invalidDefaultCredentialsError);
            }
        }
        return result;
    }
}

