/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codebuild.jenkinsplugin;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.codebuild.jenkinsplugin.Validation;
import com.amazonaws.services.codebuild.AWSCodeBuildClient;
import com.amazonaws.services.codebuild.model.ListProjectsRequest;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.amazonaws.services.securitytoken.model.Credentials;
import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import hudson.Extension;
import hudson.util.FormValidation;
import java.util.Date;
import java.util.UUID;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class CodeBuildBaseCredentials
extends BaseStandardCredentials
implements AWSCredentialsProvider {
    public static final String DEFAULT_CHAIN_CREDS = "Using credentials provided by the DefaultAWSCredentialsProviderChain for authorization";
    public static final String BASIC_AWS_CREDS = "Using given AWS access and secret key for authorization";
    public static final String IAM_ROLE_CREDS = "Authorizing with the IAM role defined in credentials ";
    public static final String ROLE_SESSION_NAME = "CodeBuild-Jenkins-Plugin";
    public static final long serialVersionUID = 555L;
    private static final int MIN_VALIDITY_ALLOWED = 180000;
    private final String accessKey;
    private final String secretKey;
    private final String proxyHost;
    private final String proxyPort;
    private final String iamRoleArn;
    private final String externalId;
    private transient Credentials roleCredentials = null;

    @DataBoundConstructor
    public CodeBuildBaseCredentials(CredentialsScope scope, String id, String description, String accessKey, String secretKey, String proxyHost, String proxyPort, String iamRoleArn, String externalId) {
        super(scope, id, description);
        this.accessKey = Validation.sanitize(accessKey);
        this.secretKey = Validation.sanitize(secretKey);
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.iamRoleArn = Validation.sanitize(iamRoleArn);
        this.externalId = externalId;
    }

    public String getCredentialsDescriptor() {
        if (this.accessKey.isEmpty() || this.secretKey.isEmpty()) {
            return DEFAULT_CHAIN_CREDS;
        }
        if (this.iamRoleArn.isEmpty()) {
            return BASIC_AWS_CREDS;
        }
        return IAM_ROLE_CREDS + this.iamRoleArn;
    }

    public AWSCredentials getCredentials() {
        AWSCredentialsProvider credentialsProvider = Validation.getBasicCredentialsOrDefaultChain(this.accessKey, this.secretKey);
        AWSCredentials credentials = credentialsProvider.getCredentials();
        if (!this.iamRoleArn.isEmpty()) {
            if (this.haveCredentialsExpired()) {
                this.refresh();
            }
            credentials = new BasicSessionCredentials(this.roleCredentials.getAccessKeyId(), this.roleCredentials.getSecretAccessKey(), this.roleCredentials.getSessionToken());
        }
        return credentials;
    }

    public void refresh() {
        if (!this.iamRoleArn.isEmpty()) {
            if (!this.haveCredentialsExpired()) {
                return;
            }
            AWSCredentialsProvider credentialsProvider = Validation.getBasicCredentialsOrDefaultChain(this.accessKey, this.secretKey);
            AWSCredentials credentials = credentialsProvider.getCredentials();
            AssumeRoleRequest assumeRequest = new AssumeRoleRequest().withRoleArn(this.iamRoleArn).withExternalId(this.externalId).withDurationSeconds(Integer.valueOf(3600)).withRoleSessionName(ROLE_SESSION_NAME);
            AssumeRoleResult assumeResult = new AWSSecurityTokenServiceClient(credentials).assumeRole(assumeRequest);
            this.roleCredentials = assumeResult.getCredentials();
        }
    }

    private boolean haveCredentialsExpired() {
        return this.roleCredentials == null || this.roleCredentials.getExpiration().getTime() < new Date().getTime() + 180000L;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public String getIamRoleArn() {
        return this.iamRoleArn;
    }

    public String getExternalId() {
        return this.externalId;
    }

    @Extension
    public static class DescriptorImpl
    extends CredentialsDescriptor {
        private static final int ERROR_MESSAGE_MAX_LENGTH = 178;

        public String getDisplayName() {
            return "CodeBuild Credentials (Groovy-compatible)";
        }

        public FormValidation doCheckSecretKey(@QueryParameter(value="proxyHost") String proxyHost, @QueryParameter(value="proxyPort") String proxyPort, @QueryParameter(value="accessKey") String accessKey, @QueryParameter(value="secretKey") String secretKey) {
            try {
                AWSCredentials initialCredentials = Validation.getBasicCredentialsOrDefaultChain(accessKey, secretKey).getCredentials();
                new AWSCodeBuildClient(initialCredentials, this.getClientConfiguration(proxyHost, proxyPort)).listProjects(new ListProjectsRequest());
            }
            catch (Exception e) {
                String errorMessage = e.getMessage();
                if (errorMessage.length() >= 178) {
                    errorMessage = errorMessage.substring(178);
                }
                return FormValidation.error((String)("Authorization failed: " + errorMessage));
            }
            return FormValidation.ok((String)"AWS access and secret key authorization successful.");
        }

        public FormValidation doCheckIamRoleArn(@QueryParameter(value="proxyHost") String proxyHost, @QueryParameter(value="proxyPort") String proxyPort, @QueryParameter(value="accessKey") String accessKey, @QueryParameter(value="secretKey") String secretKey, @QueryParameter(value="iamRoleArn") String iamRoleArn, @QueryParameter(value="externalId") String externalId) {
            if (accessKey.isEmpty() || secretKey.isEmpty()) {
                return FormValidation.error((String)"AWS access and secret keys are required to use an IAM role for authorization");
            }
            if (iamRoleArn.isEmpty()) {
                return FormValidation.ok();
            }
            try {
                BasicAWSCredentials initialCredentials = new BasicAWSCredentials(accessKey, secretKey);
                AssumeRoleRequest assumeRequest = new AssumeRoleRequest().withRoleArn(iamRoleArn).withExternalId(externalId).withDurationSeconds(Integer.valueOf(3600)).withRoleSessionName(CodeBuildBaseCredentials.ROLE_SESSION_NAME);
                new AWSSecurityTokenServiceClient((AWSCredentials)initialCredentials, this.getClientConfiguration(proxyHost, proxyPort)).assumeRole(assumeRequest);
            }
            catch (Exception e) {
                String errorMessage = e.getMessage();
                if (errorMessage.length() >= 178) {
                    errorMessage = errorMessage.substring(178);
                }
                return FormValidation.error((String)("Authorization failed: " + errorMessage));
            }
            return FormValidation.ok((String)"IAM role authorization successful.");
        }

        public String getNewUUID() {
            return UUID.randomUUID().toString();
        }

        private ClientConfiguration getClientConfiguration(String proxyHost, String proxyPort) {
            ClientConfiguration clientConfig = new ClientConfiguration();
            if (!proxyHost.isEmpty()) {
                clientConfig.withProxyHost(proxyHost);
            }
            if (!proxyPort.isEmpty()) {
                clientConfig.setProxyPort(Validation.parseInt(proxyPort).intValue());
            }
            return clientConfig;
        }
    }
}

