/*
 * Decompiled with CFR 0.152.
 */
import com.amazonaws.services.codebuild.model.InvalidInputException;
import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.io.FileUtils;

public class ZipSourceCallable
extends MasterToSlaveFileCallable<String> {
    final FilePath workspace;
    public static final String zipSourceError = "zipSource usage: prefixToTrim must be contained in the given directory.";

    public ZipSourceCallable(FilePath workspace) {
        this.workspace = workspace;
    }

    public String invoke(File f, VirtualChannel channel) throws IOException {
        String sourceFilePath = this.workspace.getRemote();
        File tempFile = File.createTempFile(f.getName(), null, null);
        try (FileOutputStream zipFileOutputStream = new FileOutputStream(tempFile);
             ZipOutputStream out = new ZipOutputStream(zipFileOutputStream);){
            ZipSourceCallable.zipSource(this.workspace, sourceFilePath, out, sourceFilePath);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        FileUtils.copyFile((File)tempFile, (File)f);
        try {
            tempFile.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return S3DataManager.getZipMD5(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipSource(FilePath workspace, String directory, ZipOutputStream out, String prefixToTrim) throws InvalidInputException, IOException, InterruptedException {
        if (!Paths.get(directory, new String[0]).startsWith(Paths.get(prefixToTrim, new String[0]))) {
            throw new InvalidInputException("zipSource usage: prefixToTrim must be contained in the given directory.prefixToTrim: " + prefixToTrim + ", directory: " + directory);
        }
        FilePath dir = new FilePath(workspace, directory);
        List dirFiles = dir.list();
        if (dirFiles == null) {
            throw new InvalidInputException("Empty or invalid source directory: " + directory);
        }
        byte[] buffer = new byte[1024];
        if (dirFiles.isEmpty()) {
            String path = ZipSourceCallable.trimPrefix(dir.getRemote(), prefixToTrim);
            if (!path.isEmpty()) {
                out.putNextEntry(new ZipEntry(path + "/"));
            }
        } else {
            for (int i = 0; i < dirFiles.size(); ++i) {
                FilePath f = new FilePath(workspace, ((FilePath)dirFiles.get(i)).getRemote());
                if (f.isDirectory()) {
                    ZipSourceCallable.zipSource(workspace, f.getRemote() + File.separator, out, prefixToTrim);
                    continue;
                }
                try (InputStream inputStream = f.read();){
                    int bytesRead;
                    String path = ZipSourceCallable.trimPrefix(f.getRemote(), prefixToTrim);
                    if (path.startsWith(File.separator)) {
                        path = path.substring(1, path.length());
                    }
                    path = path.replace(File.separator, "/");
                    ZipEntry entry = new ZipEntry(path);
                    out.putNextEntry(entry);
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        out.write(buffer, 0, bytesRead);
                    }
                    continue;
                }
            }
        }
    }

    public static String trimPrefix(String path, String prefixToTrim) {
        return Paths.get(prefixToTrim, new String[0]).relativize(Paths.get(path, new String[0])).toString();
    }
}

