/*
 * Decompiled with CFR 0.152.
 */
import com.amazonaws.services.codebuild.model.InvalidInputException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    public static String getS3BucketFromObjectArn(String s3ObjectString) {
        Matcher stringRegex = Pattern.compile("(arn:(aws|aws-cn):s3:::)?([^/]+)(/.*)*").matcher(s3ObjectString);
        stringRegex.find();
        return stringRegex.group(3);
    }

    public static String getS3KeyFromObjectArn(String s3ObjectArn) {
        int index = s3ObjectArn.indexOf(47);
        if (index < 0) {
            return "";
        }
        return s3ObjectArn.substring(index + 1);
    }

    public static String formatStringWithEllipsis(String s, int length) {
        return s.substring(0, length) + "...";
    }

    public static List parseDataList(String json, Class dataType) {
        List data;
        if (json == null || json.isEmpty()) {
            return Collections.emptyList();
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            data = (List)mapper.readValue(json, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, dataType));
        }
        catch (IOException e) {
            throw new InvalidInputException(e.getMessage());
        }
        return data;
    }

    public static void ensureFileExists(File file) throws IOException {
        File dir = file.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Failed to create directory " + dir.getAbsolutePath());
        }
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("Failed to create file " + file.getAbsolutePath());
        }
    }
}

