/*
 * Decompiled with CFR 0.152.
 */
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.codebuild.model.Build;
import com.amazonaws.services.codebuild.model.BuildArtifacts;
import com.amazonaws.services.codebuild.model.InvalidInputException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.transfer.MultipleFileDownload;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.google.common.annotations.VisibleForTesting;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;

public class S3Downloader {
    private final AmazonS3Client s3Client;
    private TransferManager transferManager;

    public S3Downloader(AmazonS3Client s3Client) {
        this.s3Client = s3Client;
        this.transferManager = TransferManagerBuilder.standard().withS3Client((AmazonS3)s3Client).build();
    }

    @VisibleForTesting
    public S3Downloader(AmazonS3Client s3Client, TransferManager transferManager) {
        this.s3Client = s3Client;
        this.transferManager = transferManager;
    }

    public void downloadBuildArtifacts(TaskListener listener, Build build, String artifactRoot) {
        if (build == null) {
            throw new InvalidInputException("Build instance is required");
        }
        this.download(listener, build.getArtifacts(), artifactRoot);
        if (build.getSecondaryArtifacts() != null) {
            for (BuildArtifacts buildArtifact : build.getSecondaryArtifacts()) {
                this.download(listener, buildArtifact, artifactRoot);
            }
        }
    }

    private void download(TaskListener listener, BuildArtifacts buildArtifact, String artifactRoot) {
        if (buildArtifact == null || buildArtifact.getLocation() == null || buildArtifact.getLocation().isEmpty() || artifactRoot == null) {
            return;
        }
        String s3Bucket = Utils.getS3BucketFromObjectArn(buildArtifact.getLocation());
        String keyPrefix = Utils.getS3KeyFromObjectArn(buildArtifact.getLocation());
        try {
            MultipleFileDownload transfer;
            if (buildArtifact.getSha256sum() != null && !buildArtifact.getSha256sum().isEmpty()) {
                File file = new File(artifactRoot + File.separatorChar + keyPrefix);
                LoggingHelper.log(listener, "Downloading artifact from location '" + buildArtifact.getLocation() + "' to path:" + file.getAbsolutePath());
                Utils.ensureFileExists(file);
                transfer = this.transferManager.download(s3Bucket, keyPrefix, file);
            } else {
                File file = new File(artifactRoot);
                LoggingHelper.log(listener, "Downloading artifact from location '" + buildArtifact.getLocation() + "' to path:" + file.getAbsolutePath());
                transfer = this.transferManager.downloadDirectory(s3Bucket, keyPrefix, file);
            }
            transfer.waitForCompletion();
        }
        catch (AmazonServiceException e) {
            LoggingHelper.log(listener, "Download failed:" + e.getMessage());
        }
        catch (InterruptedException e) {
            LoggingHelper.log(listener, "Download failed:" + e.getMessage());
        }
        catch (IOException e) {
            LoggingHelper.log(listener, e.getMessage());
        }
    }
}

