/*
 * Decompiled with CFR 0.152.
 */
import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;

public class S3DataManager {
    private final AmazonS3Client s3Client;
    private final String s3InputBucket;
    private final String s3InputKey;
    private final String sseAlgorithm;
    private final String localSourcePath;
    private final String workspaceSubdir;

    public UploadToS3Output uploadSourceToS3(TaskListener listener, FilePath workspace) throws Exception {
        String zipFileMD5;
        FilePath localFile;
        String sourcePath;
        CodeBuilderValidation.checkS3SourceUploaderConfig(workspace, this.s3Client, this.localSourcePath, this.workspaceSubdir);
        ObjectMetadata objectMetadata = new ObjectMetadata();
        if (this.localSourcePath != null && !this.localSourcePath.isEmpty()) {
            sourcePath = workspace.child(this.localSourcePath).getRemote();
            LoggingHelper.log(listener, "Local file to be uploaded to S3: " + sourcePath);
            localFile = new FilePath(workspace, this.getTempFilePath(sourcePath));
            zipFileMD5 = (String)localFile.act((FilePath.FileCallable)new LocalSourceCallable(workspace, this.localSourcePath));
        } else {
            if (this.workspaceSubdir != null && !this.workspaceSubdir.isEmpty()) {
                workspace = workspace.child(this.workspaceSubdir);
            }
            sourcePath = workspace.getRemote();
            LoggingHelper.log(listener, "Zipping directory to upload to S3: " + sourcePath);
            localFile = new FilePath(workspace, this.getTempFilePath(sourcePath));
            zipFileMD5 = (String)localFile.act((FilePath.FileCallable)new ZipSourceCallable(workspace));
        }
        objectMetadata.setContentMD5(zipFileMD5);
        objectMetadata.setContentLength(localFile.length());
        if (this.sseAlgorithm != null && !this.sseAlgorithm.isEmpty()) {
            objectMetadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
        }
        PutObjectResult putObjectResult = new PutObjectResult();
        try (InputStream zipFileInputStream = localFile.read();){
            PutObjectRequest putObjectRequest = new PutObjectRequest(this.s3InputBucket, this.s3InputKey, zipFileInputStream, objectMetadata);
            LoggingHelper.log(listener, "Uploading to S3 at location " + putObjectRequest.getBucketName() + "/" + putObjectRequest.getKey() + ". MD5 checksum is " + zipFileMD5);
            putObjectResult = this.s3Client.putObject(putObjectRequest);
        }
        catch (SdkClientException e) {
            LoggingHelper.log(listener, "Unexpected exception upon uploading source zip to S3: " + e.getMessage());
        }
        try {
            localFile.delete();
        }
        catch (IOException e) {
            LoggingHelper.log(listener, "Unexpected exception upon deleting source file: " + e.getMessage());
        }
        return new UploadToS3Output(this.s3InputBucket + "/" + this.s3InputKey, putObjectResult.getVersionId());
    }

    private String getTempFilePath(String filePath) {
        return filePath.substring(0, filePath.lastIndexOf(File.separator) + 1) + UUID.randomUUID().toString() + "-" + this.s3InputKey;
    }

    public static String getZipMD5(File zipFile) throws IOException {
        return new String(Base64.encodeBase64((byte[])DigestUtils.md5((InputStream)new FileInputStream(zipFile))), Charsets.UTF_8);
    }

    public S3DataManager(AmazonS3Client s3Client, String s3InputBucket, String s3InputKey, String sseAlgorithm, String localSourcePath, String workspaceSubdir) {
        this.s3Client = s3Client;
        this.s3InputBucket = s3InputBucket;
        this.s3InputKey = s3InputKey;
        this.sseAlgorithm = sseAlgorithm;
        this.localSourcePath = localSourcePath;
        this.workspaceSubdir = workspaceSubdir;
    }
}

