/*
 * Decompiled with CFR 0.152.
 */
import com.amazonaws.services.codebuild.model.ArtifactNamespace;
import com.amazonaws.services.codebuild.model.ArtifactPackaging;
import com.amazonaws.services.codebuild.model.ArtifactsType;
import com.amazonaws.services.codebuild.model.CacheMode;
import com.amazonaws.services.codebuild.model.CacheType;
import com.amazonaws.services.codebuild.model.ComputeType;
import com.amazonaws.services.codebuild.model.EnvironmentType;
import com.amazonaws.services.codebuild.model.EnvironmentVariable;
import com.amazonaws.services.codebuild.model.InvalidInputException;
import com.amazonaws.services.codebuild.model.LogsConfigStatusType;
import com.amazonaws.services.codebuild.model.SourceType;
import com.amazonaws.services.logs.AWSLogsClient;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import enums.SourceControlType;
import hudson.FilePath;
import java.util.Collection;

public class CodeBuilderValidation {
    public static final String invalidArtifactTypeError = "Artifact type override must be one of 'NO_ARTIFACTS', 'S3', ''";
    public static final String invalidArtifactsPackagingError = "Artifact packaging override must be one of 'NONE', 'ZIP', ''";
    public static final String invalidArtifactNamespaceTypeError = "Artifact namespace override must be one of 'NONE', 'BUILD_ID', ''";
    public static final String invalidTimeoutOverrideError = "Build timeout override must be a number between 5 and 480 (minutes)";
    public static final String invalidRegionError = "Enter a valid AWS region";
    public static final String invalidProxyError = "Enter a valid proxy host and port (greater than zero)";
    public static final String invalidCredentialsIdError = "Invalid credentials ID. Verify that the credentials are of type CodeBuildCredentials and are accessible in this project.";
    public static final String invalidSourceTypeError = "Source type override must be one of 'CODECOMMIT', 'S3', 'GITHUB', 'GITHUB_ENTERPRISE', 'BITBUCKET'";
    public static final String invalidComputeTypeError = "Compute type override must be one of 'BUILD_GENERAL1_SMALL', 'BUILD_GENERAL1_MEDIUM', 'BUILD_GENERAL1_LARGE'";
    public static final String invalidEnvironmentTypeError = "Environment type override must be one of 'LINUX_CONTAINER', 'WINDOWS_CONTAINER'";
    public static final String invalidCacheTypeError = "Cache type override must be one of 'S3', 'NO_CACHE', 'LOCAL'";
    public static final String invalidCacheModesError = "Cache modes override must be one or more of 'LOCAL_SOURCE_CACHE', 'LOCAL_DOCKER_LAYER_CACHE', 'LOCAL_CUSTOM_CACHE' and enclosed in brackets";
    public static final String invalidCloudWatchLogsStatusError = "CloudWatch Logs status override must be one of 'ENABLED', 'DISABLED'";
    public static final String invalidS3LogsStatusError = "S3 logs status override must be one of 'ENABLED', 'DISABLED'";
    public static final String invalidSourceUploaderNullWorkspaceError = "Project workspace is null";
    public static final String invalidSourceUploaderNullS3ClientError = "S3 client cannot be null";
    public static final String invalidSourceUploaderConfigError = "Cannot specify both localSourcePath and workspaceSubdir";
    public static final String projectRequiredError = "CodeBuild project name is required";
    public static final String sourceControlTypeRequiredError = "Source control type is required and must be 'jenkins' or 'project'";
    public static final String buildInstanceRequiredError = "Build instance is required";

    public static String checkEssentialConfig(CodeBuilder cb) {
        String projectName = cb.getParameterized(cb.getProjectName());
        if (projectName == null || projectName.isEmpty()) {
            return projectRequiredError;
        }
        String sourceControlType = cb.getParameterized(cb.getSourceControlType());
        if (!sourceControlType.equals(SourceControlType.JenkinsSource.toString()) && !sourceControlType.equals(SourceControlType.ProjectSource.toString())) {
            return sourceControlTypeRequiredError;
        }
        return "";
    }

    public static String checkStartBuildOverridesConfig(CodeBuilder cb) {
        String timeout;
        String s3LogsStatusOverride;
        String cloudWatchLogsStatusOverride;
        String cacheModesOverride;
        String cacheTypeOverride;
        String environmentTypeOverride;
        String computeTypeOverride;
        String sourceTypeOverride;
        String artifactNamespaceOverride;
        String artifactPackagingOverride;
        String artifactTypeOverride = cb.getParameterized(cb.getArtifactTypeOverride());
        if (!artifactTypeOverride.isEmpty()) {
            try {
                ArtifactsType.fromValue((String)artifactTypeOverride);
            }
            catch (IllegalArgumentException e) {
                return invalidArtifactTypeError;
            }
        }
        if (!(artifactPackagingOverride = cb.getParameterized(cb.getArtifactPackagingOverride())).isEmpty()) {
            try {
                ArtifactPackaging.fromValue((String)artifactPackagingOverride);
            }
            catch (IllegalArgumentException e) {
                return invalidArtifactsPackagingError;
            }
        }
        if (!(artifactNamespaceOverride = cb.getParameterized(cb.getArtifactNamespaceOverride())).isEmpty()) {
            try {
                ArtifactNamespace.fromValue((String)artifactNamespaceOverride);
            }
            catch (IllegalArgumentException e) {
                return invalidArtifactNamespaceTypeError;
            }
        }
        if (!(sourceTypeOverride = cb.getParameterized(cb.getSourceTypeOverride())).isEmpty()) {
            try {
                SourceType.fromValue((String)sourceTypeOverride);
            }
            catch (IllegalArgumentException e) {
                return invalidSourceTypeError;
            }
        }
        if (!(computeTypeOverride = cb.getParameterized(cb.getComputeTypeOverride())).isEmpty()) {
            try {
                ComputeType.fromValue((String)computeTypeOverride);
            }
            catch (IllegalArgumentException e) {
                return invalidComputeTypeError;
            }
        }
        if (!(environmentTypeOverride = cb.getParameterized(cb.getEnvironmentTypeOverride())).isEmpty()) {
            try {
                EnvironmentType.fromValue((String)environmentTypeOverride);
            }
            catch (IllegalArgumentException e) {
                return invalidEnvironmentTypeError;
            }
        }
        if (!(cacheTypeOverride = cb.getParameterized(cb.getCacheTypeOverride())).isEmpty()) {
            try {
                CacheType.fromValue((String)cacheTypeOverride);
            }
            catch (IllegalArgumentException e) {
                return invalidCacheTypeError;
            }
        }
        if (!(cacheModesOverride = cb.getParameterized(cb.getCacheModesOverride())).isEmpty()) {
            try {
                for (String mode : CodeBuilder.listCacheModes(cacheModesOverride)) {
                    CacheMode.fromValue((String)mode);
                }
            }
            catch (IllegalArgumentException e) {
                return invalidCacheModesError;
            }
        }
        if (!(cloudWatchLogsStatusOverride = cb.getParameterized(cb.getCloudWatchLogsStatusOverride())).isEmpty()) {
            try {
                LogsConfigStatusType.fromValue((String)cloudWatchLogsStatusOverride);
            }
            catch (IllegalArgumentException e) {
                return invalidCloudWatchLogsStatusError;
            }
        }
        if (!(s3LogsStatusOverride = cb.getParameterized(cb.getS3LogsStatusOverride())).isEmpty()) {
            try {
                LogsConfigStatusType.fromValue((String)s3LogsStatusOverride);
            }
            catch (IllegalArgumentException e) {
                return invalidS3LogsStatusError;
            }
        }
        if ((timeout = cb.getParameterized(cb.getBuildTimeoutOverride())) != null && !timeout.isEmpty()) {
            Integer t;
            try {
                t = Integer.parseInt(timeout);
            }
            catch (NumberFormatException e) {
                return invalidTimeoutOverrideError;
            }
            if (t < 5 || t > 480) {
                return invalidTimeoutOverrideError;
            }
        }
        return "";
    }

    public static boolean envVariablesHaveRestrictedPrefix(Collection<EnvironmentVariable> envVariables) {
        for (EnvironmentVariable e : envVariables) {
            if (!e.getName().startsWith("CODEBUILD_")) continue;
            return true;
        }
        return false;
    }

    public static boolean checkCloudWatchMonitorConfig(AWSLogsClient client) {
        return client != null;
    }

    public static void checkS3SourceUploaderConfig(FilePath workspace, AmazonS3Client s3Client, String localSourcePath, String workspaceSubdir) throws InvalidInputException {
        if (workspace == null) {
            throw new InvalidInputException(invalidSourceUploaderNullWorkspaceError);
        }
        if (s3Client == null) {
            throw new InvalidInputException(invalidSourceUploaderNullS3ClientError);
        }
        if (localSourcePath != null && !localSourcePath.isEmpty() && workspaceSubdir != null && !workspaceSubdir.isEmpty()) {
            throw new InvalidInputException(invalidSourceUploaderConfigError);
        }
    }

    public static boolean checkSourceTypeS3(String sourceType) {
        return sourceType != null && sourceType.equals("S3");
    }

    public static boolean checkJenkinsSourceOverrides(String sourceTypeOverride, String sourceLocationOverride) {
        if (sourceTypeOverride.isEmpty() != sourceLocationOverride.isEmpty()) {
            return false;
        }
        return sourceTypeOverride.equals("S3");
    }

    public static boolean checkBucketIsVersioned(String bucketName, AWSClientFactory awsClientFactory) {
        BucketVersioningConfiguration bucketVersioningConfig = awsClientFactory.getS3Client().getBucketVersioningConfiguration(bucketName);
        return bucketVersioningConfig.getStatus().equals("Enabled");
    }

    public static void checkAWSClientFactoryJenkinsCredentialsConfig(String credentialsId) throws InvalidInputException {
        if (credentialsId == null || credentialsId.isEmpty()) {
            throw new InvalidInputException(invalidCredentialsIdError);
        }
    }

    public static void checkAWSClientFactoryRegionConfig(String region) throws InvalidInputException {
        if (region.isEmpty()) {
            throw new InvalidInputException(invalidRegionError);
        }
    }
}

