/*
 * Decompiled with CFR 0.152.
 */
import com.amazonaws.codebuild.jenkinsplugin.CodeBuildBaseCredentials;
import com.amazonaws.codebuild.jenkinsplugin.Validation;
import com.amazonaws.services.codebuild.AWSCodeBuildClient;
import com.amazonaws.services.codebuild.model.ArtifactNamespace;
import com.amazonaws.services.codebuild.model.ArtifactPackaging;
import com.amazonaws.services.codebuild.model.ArtifactsType;
import com.amazonaws.services.codebuild.model.BatchGetBuildsRequest;
import com.amazonaws.services.codebuild.model.BatchGetProjectsRequest;
import com.amazonaws.services.codebuild.model.BatchGetProjectsResult;
import com.amazonaws.services.codebuild.model.Build;
import com.amazonaws.services.codebuild.model.BuildPhase;
import com.amazonaws.services.codebuild.model.BuildPhaseType;
import com.amazonaws.services.codebuild.model.CacheType;
import com.amazonaws.services.codebuild.model.CloudWatchLogsConfig;
import com.amazonaws.services.codebuild.model.ComputeType;
import com.amazonaws.services.codebuild.model.EnvironmentType;
import com.amazonaws.services.codebuild.model.EnvironmentVariable;
import com.amazonaws.services.codebuild.model.EnvironmentVariableType;
import com.amazonaws.services.codebuild.model.InvalidInputException;
import com.amazonaws.services.codebuild.model.LogsConfig;
import com.amazonaws.services.codebuild.model.LogsConfigStatusType;
import com.amazonaws.services.codebuild.model.LogsLocation;
import com.amazonaws.services.codebuild.model.PhaseContext;
import com.amazonaws.services.codebuild.model.Project;
import com.amazonaws.services.codebuild.model.ProjectArtifacts;
import com.amazonaws.services.codebuild.model.ProjectCache;
import com.amazonaws.services.codebuild.model.ProjectSource;
import com.amazonaws.services.codebuild.model.ProjectSourceVersion;
import com.amazonaws.services.codebuild.model.S3LogsConfig;
import com.amazonaws.services.codebuild.model.SourceAuth;
import com.amazonaws.services.codebuild.model.SourceAuthType;
import com.amazonaws.services.codebuild.model.SourceType;
import com.amazonaws.services.codebuild.model.StartBuildRequest;
import com.amazonaws.services.codebuild.model.StartBuildResult;
import com.amazonaws.services.codebuild.model.StatusType;
import com.amazonaws.services.codebuild.model.StopBuildRequest;
import com.amazonaws.services.s3.AmazonS3Client;
import com.cloudbees.hudson.plugins.folder.Folder;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import enums.BooleanValue;
import enums.EncryptionAlgorithm;
import enums.GitCloneDepth;
import enums.SourceControlType;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class CodeBuilder
extends Builder
implements SimpleBuildStep {
    private String credentialsType;
    private String credentialsId;
    private String proxyHost;
    private String proxyPort;
    private String awsAccessKey;
    private Secret awsSecretKey;
    private String awsSessionToken;
    private String region;
    private String projectName;
    private String sourceControlType;
    private String localSourcePath;
    private String workspaceSubdir;
    private String sourceVersion;
    private String sseAlgorithm;
    private String gitCloneDepthOverride;
    private String reportBuildStatusOverride;
    private String secondarySourcesOverride;
    private String secondarySourcesVersionOverride;
    private String artifactTypeOverride;
    private String artifactLocationOverride;
    private String artifactNameOverride;
    private String artifactNamespaceOverride;
    private String artifactPackagingOverride;
    private String artifactPathOverride;
    private String artifactEncryptionDisabledOverride;
    private String overrideArtifactName;
    private String secondaryArtifactsOverride;
    private String environmentTypeOverride;
    private String imageOverride;
    private String computeTypeOverride;
    private String certificateOverride;
    private String cacheTypeOverride;
    private String cacheLocationOverride;
    private String cacheModesOverride;
    private String cloudWatchLogsStatusOverride;
    private String cloudWatchLogsGroupNameOverride;
    private String cloudWatchLogsStreamNameOverride;
    private String s3LogsStatusOverride;
    private String s3LogsEncryptionDisabledOverride;
    private String s3LogsLocationOverride;
    private String serviceRoleOverride;
    private String privilegedModeOverride;
    private String sourceTypeOverride;
    private String sourceLocationOverride;
    private String insecureSslOverride;
    private String envVariables;
    private String envParameters;
    private String buildSpecFile;
    private String buildTimeoutOverride;
    private String cwlStreamingDisabled;
    private final CodeBuildResult codeBuildResult;
    private String exceptionFailureMode;
    private String downloadArtifacts;
    private String downloadArtifactsRelativePath;
    private EnvVars envVars;
    private StepContext stepContext;
    public static final String authorizationError = "Authorization error";
    public static final String configuredImproperlyError = "CodeBuild configured improperly in project settings";
    public static final String s3BucketBaseURL = "https://s3.console.aws.amazon.com/s3/buckets/";
    public static final String s3ARNPrefix = "arn:aws:s3:::";
    public static final String jenkinsSourceOverrideError = "When using Jenkins source, sourceTypeOverride must be S3 and you must specify both sourceTypeOverride and sourceLocationOverride";
    public static final String jenkinsSourceProjectSourceTypeError = "Please select a project with S3 source type";
    public static final String envVariableSyntaxError = "CodeBuild environment variable keys and values cannot be empty and the string must be of the form [{key, value}, {key2, value2}]";
    public static final String envVariableNameSpaceError = "CodeBuild environment variable keys cannot start with CODEBUILD_";
    public static final String notVersionsedS3BucketError = "A versioned S3 bucket is required.\n";
    public static final String invalidSecondarySourceArtifacts = "Invalid secondary source/artifacts";
    public static final String httpTimeoutMessage = "Unable to execute HTTP request";
    private int batchGetBuildsCalls;
    private DescriptorImpl descriptor;

    @DataBoundConstructor
    public CodeBuilder(String credentialsType, String credentialsId, String proxyHost, String proxyPort, String awsAccessKey, Secret awsSecretKey, String awsSessionToken, String region, String projectName, String sourceVersion, String sseAlgorithm, String sourceControlType, String localSourcePath, String workspaceSubdir, String gitCloneDepthOverride, String reportBuildStatusOverride, String secondarySourcesOverride, String secondarySourcesVersionOverride, String artifactTypeOverride, String artifactLocationOverride, String artifactNameOverride, String artifactNamespaceOverride, String artifactPackagingOverride, String artifactPathOverride, String artifactEncryptionDisabledOverride, String overrideArtifactName, String secondaryArtifactsOverride, String envVariables, String envParameters, String buildSpecFile, String buildTimeoutOverride, String sourceTypeOverride, String sourceLocationOverride, String environmentTypeOverride, String imageOverride, String computeTypeOverride, String cacheTypeOverride, String cacheLocationOverride, String cacheModesOverride, String cloudWatchLogsStatusOverride, String cloudWatchLogsGroupNameOverride, String cloudWatchLogsStreamNameOverride, String s3LogsStatusOverride, String s3LogsEncryptionDisabledOverride, String s3LogsLocationOverride, String certificateOverride, String serviceRoleOverride, String insecureSslOverride, String privilegedModeOverride, String cwlStreamingDisabled, String exceptionFailureMode, String downloadArtifacts, String downloadArtifactsRelativePath) {
        this.credentialsType = Validation.sanitize(credentialsType);
        this.credentialsId = Validation.sanitize(credentialsId);
        this.proxyHost = Validation.sanitize(proxyHost);
        this.proxyPort = Validation.sanitize(proxyPort);
        this.awsAccessKey = Validation.sanitize(awsAccessKey);
        this.awsSecretKey = awsSecretKey;
        this.awsSessionToken = Validation.sanitize(awsSessionToken);
        this.region = Validation.sanitize(region);
        this.projectName = Validation.sanitize(projectName);
        this.sourceControlType = Validation.sanitize(sourceControlType);
        this.localSourcePath = Validation.sanitize(localSourcePath);
        this.workspaceSubdir = Validation.sanitize(workspaceSubdir);
        this.sourceVersion = Validation.sanitize(sourceVersion);
        this.sseAlgorithm = Validation.sanitize(sseAlgorithm);
        this.gitCloneDepthOverride = Validation.sanitize(gitCloneDepthOverride);
        this.reportBuildStatusOverride = Validation.sanitize(reportBuildStatusOverride);
        this.secondarySourcesOverride = CodeBuilder.decodeJSON(Validation.sanitize(secondarySourcesOverride));
        this.secondarySourcesVersionOverride = CodeBuilder.decodeJSON(Validation.sanitize(secondarySourcesVersionOverride));
        this.artifactTypeOverride = Validation.sanitize(artifactTypeOverride);
        this.artifactLocationOverride = Validation.sanitize(artifactLocationOverride);
        this.artifactNameOverride = Validation.sanitize(artifactNameOverride);
        this.artifactNamespaceOverride = Validation.sanitize(artifactNamespaceOverride);
        this.artifactPackagingOverride = Validation.sanitize(artifactPackagingOverride);
        this.artifactPathOverride = Validation.sanitize(artifactPathOverride);
        this.artifactEncryptionDisabledOverride = Validation.sanitize(artifactEncryptionDisabledOverride);
        this.overrideArtifactName = Validation.sanitize(overrideArtifactName);
        this.secondaryArtifactsOverride = CodeBuilder.decodeJSON(Validation.sanitize(secondaryArtifactsOverride));
        this.sourceTypeOverride = Validation.sanitize(sourceTypeOverride);
        this.sourceLocationOverride = Validation.sanitize(sourceLocationOverride);
        this.environmentTypeOverride = Validation.sanitize(environmentTypeOverride);
        this.imageOverride = Validation.sanitize(imageOverride);
        this.computeTypeOverride = Validation.sanitize(computeTypeOverride);
        this.cacheTypeOverride = Validation.sanitize(cacheTypeOverride);
        this.cacheLocationOverride = Validation.sanitize(cacheLocationOverride);
        this.cacheModesOverride = Validation.sanitize(cacheModesOverride);
        this.cloudWatchLogsStatusOverride = Validation.sanitize(cloudWatchLogsStatusOverride);
        this.cloudWatchLogsGroupNameOverride = Validation.sanitize(cloudWatchLogsGroupNameOverride);
        this.cloudWatchLogsStreamNameOverride = Validation.sanitize(cloudWatchLogsStreamNameOverride);
        this.s3LogsStatusOverride = Validation.sanitize(s3LogsStatusOverride);
        this.s3LogsEncryptionDisabledOverride = Validation.sanitize(s3LogsEncryptionDisabledOverride);
        this.s3LogsLocationOverride = Validation.sanitize(s3LogsLocationOverride);
        this.certificateOverride = Validation.sanitize(certificateOverride);
        this.serviceRoleOverride = Validation.sanitize(serviceRoleOverride);
        this.envVariables = Validation.sanitize(envVariables);
        this.envParameters = Validation.sanitize(envParameters);
        this.buildSpecFile = Validation.sanitizeYAML(buildSpecFile);
        this.buildTimeoutOverride = Validation.sanitize(buildTimeoutOverride);
        this.insecureSslOverride = Validation.sanitize(insecureSslOverride);
        this.privilegedModeOverride = Validation.sanitize(privilegedModeOverride);
        this.cwlStreamingDisabled = Validation.sanitize(cwlStreamingDisabled);
        this.exceptionFailureMode = Validation.sanitize(exceptionFailureMode);
        this.downloadArtifacts = Validation.sanitize(downloadArtifacts);
        this.downloadArtifactsRelativePath = Validation.sanitize(downloadArtifactsRelativePath);
        this.codeBuildResult = new CodeBuildResult();
        this.batchGetBuildsCalls = 0;
    }

    protected Object readResolve() {
        this.credentialsType = Validation.sanitize(this.credentialsType);
        this.credentialsId = Validation.sanitize(this.credentialsId);
        this.proxyHost = Validation.sanitize(this.proxyHost);
        this.proxyPort = Validation.sanitize(this.proxyPort);
        this.awsAccessKey = Validation.sanitize(this.awsAccessKey);
        this.awsSessionToken = Validation.sanitize(this.awsSessionToken);
        this.region = Validation.sanitize(this.region);
        this.projectName = Validation.sanitize(this.projectName);
        this.sourceControlType = Validation.sanitize(this.sourceControlType);
        this.localSourcePath = Validation.sanitize(this.localSourcePath);
        this.workspaceSubdir = Validation.sanitize(this.workspaceSubdir);
        this.sourceVersion = Validation.sanitize(this.sourceVersion);
        this.sseAlgorithm = Validation.sanitize(this.sseAlgorithm);
        this.gitCloneDepthOverride = Validation.sanitize(this.gitCloneDepthOverride);
        this.reportBuildStatusOverride = Validation.sanitize(this.reportBuildStatusOverride);
        this.secondarySourcesOverride = CodeBuilder.decodeJSON(Validation.sanitize(this.secondarySourcesOverride));
        this.secondarySourcesVersionOverride = CodeBuilder.decodeJSON(Validation.sanitize(this.secondarySourcesVersionOverride));
        this.artifactTypeOverride = Validation.sanitize(this.artifactTypeOverride);
        this.artifactLocationOverride = Validation.sanitize(this.artifactLocationOverride);
        this.artifactNameOverride = Validation.sanitize(this.artifactNameOverride);
        this.artifactNamespaceOverride = Validation.sanitize(this.artifactNamespaceOverride);
        this.artifactPackagingOverride = Validation.sanitize(this.artifactPackagingOverride);
        this.artifactPathOverride = Validation.sanitize(this.artifactPathOverride);
        this.artifactEncryptionDisabledOverride = Validation.sanitize(this.artifactEncryptionDisabledOverride);
        this.overrideArtifactName = Validation.sanitize(this.overrideArtifactName);
        this.secondaryArtifactsOverride = CodeBuilder.decodeJSON(Validation.sanitize(this.secondaryArtifactsOverride));
        this.sourceTypeOverride = Validation.sanitize(this.sourceTypeOverride);
        this.sourceLocationOverride = Validation.sanitize(this.sourceLocationOverride);
        this.environmentTypeOverride = Validation.sanitize(this.environmentTypeOverride);
        this.imageOverride = Validation.sanitize(this.imageOverride);
        this.computeTypeOverride = Validation.sanitize(this.computeTypeOverride);
        this.cacheTypeOverride = Validation.sanitize(this.cacheTypeOverride);
        this.cacheLocationOverride = Validation.sanitize(this.cacheLocationOverride);
        this.cacheModesOverride = Validation.sanitize(this.cacheModesOverride);
        this.cloudWatchLogsStatusOverride = Validation.sanitize(this.cloudWatchLogsStatusOverride);
        this.cloudWatchLogsGroupNameOverride = Validation.sanitize(this.cloudWatchLogsGroupNameOverride);
        this.cloudWatchLogsStreamNameOverride = Validation.sanitize(this.cloudWatchLogsStreamNameOverride);
        this.s3LogsStatusOverride = Validation.sanitize(this.s3LogsStatusOverride);
        this.s3LogsEncryptionDisabledOverride = Validation.sanitize(this.s3LogsEncryptionDisabledOverride);
        this.s3LogsLocationOverride = Validation.sanitize(this.s3LogsLocationOverride);
        this.certificateOverride = Validation.sanitize(this.certificateOverride);
        this.serviceRoleOverride = Validation.sanitize(this.serviceRoleOverride);
        this.envVariables = Validation.sanitize(this.envVariables);
        this.envParameters = Validation.sanitize(this.envParameters);
        this.buildSpecFile = Validation.sanitizeYAML(this.buildSpecFile);
        this.buildTimeoutOverride = Validation.sanitize(this.buildTimeoutOverride);
        this.insecureSslOverride = Validation.sanitize(this.insecureSslOverride);
        this.privilegedModeOverride = Validation.sanitize(this.privilegedModeOverride);
        this.cwlStreamingDisabled = Validation.sanitize(this.cwlStreamingDisabled);
        this.exceptionFailureMode = Validation.sanitize(this.exceptionFailureMode);
        this.downloadArtifacts = Validation.sanitize(this.downloadArtifacts);
        this.downloadArtifactsRelativePath = Validation.sanitize(this.downloadArtifactsRelativePath);
        return this;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath ws, @Nonnull Launcher launcher, @Nonnull TaskListener listener, StepContext stepContext) throws InterruptedException, IOException {
        this.stepContext = stepContext;
        this.perform(build, ws, launcher, listener);
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath ws, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        StartBuildResult sbResult;
        List secondaryArtifacts;
        List secondarySourceVersions;
        List secondarySources;
        LogsConfig logsConfigOverride;
        ProjectCache cacheOverride;
        AWSCodeBuildClient cbClient;
        AWSClientFactory awsClientFactory;
        this.descriptor = this.getDescriptor();
        this.envVars = build.getEnvironment(listener);
        try {
            awsClientFactory = new AWSClientFactory(this.getParameterized(this.credentialsType), this.getParameterized(this.credentialsId), this.getParameterized(this.proxyHost), this.getParameterized(this.proxyPort), this.getParameterized(this.awsAccessKey), this.awsSecretKey, this.getParameterized(this.awsSessionToken), this.getParameterized(this.region), build, this.stepContext);
        }
        catch (Exception e) {
            this.failBuild(build, listener, authorizationError, e.getMessage());
            return;
        }
        String projectConfigError = CodeBuilderValidation.checkEssentialConfig(this);
        if (!projectConfigError.isEmpty()) {
            this.failBuild(build, listener, configuredImproperlyError, projectConfigError);
            return;
        }
        String overridesErrorMessage = CodeBuilderValidation.checkStartBuildOverridesConfig(this);
        if (!overridesErrorMessage.isEmpty()) {
            this.failBuild(build, listener, configuredImproperlyError, overridesErrorMessage);
            return;
        }
        Collection<EnvironmentVariable> codeBuildEnvVars = null;
        try {
            codeBuildEnvVars = CodeBuilder.mapEnvVariables(this.getParameterized(this.envVariables), EnvironmentVariableType.PLAINTEXT);
            codeBuildEnvVars.addAll(CodeBuilder.mapEnvVariables(this.getParameterized(this.envParameters), EnvironmentVariableType.PARAMETER_STORE));
        }
        catch (InvalidInputException e) {
            this.failBuild(build, listener, configuredImproperlyError, e.getMessage());
            return;
        }
        if (CodeBuilderValidation.envVariablesHaveRestrictedPrefix(codeBuildEnvVars)) {
            this.failBuild(build, listener, configuredImproperlyError, envVariableNameSpaceError);
            return;
        }
        LoggingHelper.log(listener, awsClientFactory.getCredentialsDescriptor());
        try {
            cbClient = awsClientFactory.getCodeBuildClient();
        }
        catch (Exception e) {
            this.failBuild(build, listener, e.getMessage(), "");
            return;
        }
        StartBuildRequest startBuildRequest = new StartBuildRequest().withProjectName(this.getParameterized(this.projectName)).withEnvironmentVariablesOverride(codeBuildEnvVars).withBuildspecOverride(this.getParameterized(this.buildSpecFile)).withTimeoutInMinutesOverride(Validation.parseInt(this.getParameterized(this.buildTimeoutOverride)));
        ProjectArtifacts artifactsOverride = this.generateStartBuildArtifactOverride();
        if (artifactsOverride != null) {
            startBuildRequest.setArtifactsOverride(artifactsOverride);
        }
        if ((cacheOverride = this.generateStartBuildCacheOverride()) != null) {
            startBuildRequest.setCacheOverride(cacheOverride);
        }
        if ((logsConfigOverride = this.generateStartBuildLogsConfigOverride()) != null) {
            startBuildRequest.setLogsConfigOverride(logsConfigOverride);
        }
        if (!this.getParameterized(this.environmentTypeOverride).isEmpty()) {
            startBuildRequest.setEnvironmentTypeOverride(this.getParameterized(this.environmentTypeOverride));
        }
        if (!this.getParameterized(this.imageOverride).isEmpty()) {
            startBuildRequest.setImageOverride(this.getParameterized(this.imageOverride));
        }
        if (!this.getParameterized(this.computeTypeOverride).isEmpty()) {
            startBuildRequest.setComputeTypeOverride(this.getParameterized(this.computeTypeOverride));
        }
        if (!this.getParameterized(this.certificateOverride).isEmpty()) {
            startBuildRequest.setCertificateOverride(this.getParameterized(this.certificateOverride));
        }
        if (!this.getParameterized(this.serviceRoleOverride).isEmpty()) {
            startBuildRequest.setServiceRoleOverride(this.getParameterized(this.serviceRoleOverride));
        }
        if (!this.getParameterized(this.insecureSslOverride).isEmpty()) {
            startBuildRequest.setInsecureSslOverride(Boolean.valueOf(Boolean.parseBoolean(this.getParameterized(this.insecureSslOverride))));
        }
        if (!this.getParameterized(this.privilegedModeOverride).isEmpty()) {
            startBuildRequest.setPrivilegedModeOverride(Boolean.valueOf(Boolean.parseBoolean(this.getParameterized(this.privilegedModeOverride))));
        }
        try {
            secondarySources = Utils.parseDataList(this.getParameterized(this.secondarySourcesOverride), ProjectSource.class);
            secondarySourceVersions = Utils.parseDataList(this.getParameterized(this.secondarySourcesVersionOverride), ProjectSourceVersion.class);
            secondaryArtifacts = Utils.parseDataList(this.getParameterized(this.secondaryArtifactsOverride), ProjectArtifacts.class);
        }
        catch (InvalidInputException e) {
            this.failBuild(build, listener, invalidSecondarySourceArtifacts, e.getMessage());
            return;
        }
        if (secondarySources != null && !secondarySources.isEmpty()) {
            startBuildRequest.setSecondarySourcesOverride((Collection)secondarySources);
        }
        if (secondarySourceVersions != null && !secondarySourceVersions.isEmpty()) {
            startBuildRequest.setSecondarySourcesVersionOverride((Collection)secondarySourceVersions);
        }
        if (secondaryArtifacts != null && !secondaryArtifacts.isEmpty()) {
            startBuildRequest.setSecondaryArtifactsOverride((Collection)secondaryArtifacts);
        }
        if (SourceControlType.JenkinsSource.toString().equals(this.getParameterized(this.sourceControlType))) {
            String buildSourceLocation = "";
            if (!this.getParameterized(this.sourceTypeOverride).isEmpty() || !this.getParameterized(this.sourceLocationOverride).isEmpty()) {
                if (!CodeBuilderValidation.checkJenkinsSourceOverrides(this.getParameterized(this.sourceTypeOverride), this.getParameterized(this.sourceLocationOverride))) {
                    this.failBuild(build, listener, configuredImproperlyError, jenkinsSourceOverrideError);
                    return;
                }
                buildSourceLocation = this.getParameterized(this.sourceLocationOverride);
            } else {
                try {
                    buildSourceLocation = this.retrieveProjectSourceInfo(cbClient);
                }
                catch (Exception e) {
                    this.failBuild(build, listener, configuredImproperlyError, e.getMessage());
                    return;
                }
            }
            String sourceS3Bucket = Utils.getS3BucketFromObjectArn(buildSourceLocation);
            String sourceS3Key = Utils.getS3KeyFromObjectArn(buildSourceLocation);
            if (!CodeBuilderValidation.checkBucketIsVersioned(sourceS3Bucket, awsClientFactory)) {
                this.failBuild(build, listener, notVersionsedS3BucketError, "");
                return;
            }
            S3DataManager s3DataManager = new S3DataManager(awsClientFactory.getS3Client(), sourceS3Bucket, sourceS3Key, this.getParameterized(this.sseAlgorithm), this.getParameterized(this.localSourcePath), this.getParameterized(this.workspaceSubdir));
            String uploadedSourceVersion = "";
            try {
                UploadToS3Output uploadToS3Output = s3DataManager.uploadSourceToS3(listener, ws);
                if (uploadToS3Output.getObjectVersionId() == null) {
                    this.failBuild(build, listener, notVersionsedS3BucketError, "");
                    return;
                }
                uploadedSourceVersion = uploadToS3Output.getObjectVersionId();
                LoggingHelper.log(listener, "S3 object version id for uploaded source is " + uploadedSourceVersion);
            }
            catch (Exception e) {
                this.failBuild(build, listener, e.getMessage(), "");
                return;
            }
            startBuildRequest.setSourceVersion(uploadedSourceVersion);
            this.logStartBuildMessage(listener, uploadedSourceVersion);
        } else {
            startBuildRequest.setSourceVersion(this.getParameterized(this.sourceVersion));
            startBuildRequest.setGitCloneDepthOverride(this.generateStartBuildGitCloneDepthOverride());
            if (!this.getParameterized(this.reportBuildStatusOverride).isEmpty()) {
                startBuildRequest.setReportBuildStatusOverride(Boolean.valueOf(Boolean.parseBoolean(this.getParameterized(this.reportBuildStatusOverride))));
            }
            this.logStartBuildMessage(listener, this.getParameterized(this.sourceVersion));
        }
        if (!this.getParameterized(this.sourceTypeOverride).isEmpty()) {
            startBuildRequest.setSourceTypeOverride(this.getParameterized(this.sourceTypeOverride));
            SourceAuth auth = this.generateStartBuildSourceAuthOverride(this.getParameterized(this.sourceTypeOverride));
            if (auth != null) {
                startBuildRequest.setSourceAuthOverride(auth);
            }
        }
        if (!this.getParameterized(this.sourceLocationOverride).isEmpty()) {
            startBuildRequest.setSourceLocationOverride(this.getParameterized(this.sourceLocationOverride));
        }
        try {
            sbResult = cbClient.startBuild(startBuildRequest);
        }
        catch (Exception e) {
            this.failBuild(build, listener, e.getMessage(), "");
            return;
        }
        Build currentBuild = new Build().withBuildStatus(StatusType.IN_PROGRESS);
        String buildId = sbResult.getBuild().getId();
        LoggingHelper.log(listener, "Build id: " + buildId);
        LoggingHelper.log(listener, "CodeBuild dashboard: " + this.generateDashboardURL(buildId));
        boolean haveInitializedAction = false;
        CodeBuildAction action = null;
        CloudWatchMonitor logMonitor = null;
        do {
            try {
                List buildsForId = cbClient.batchGetBuilds(new BatchGetBuildsRequest().withIds(new String[]{buildId})).getBuilds();
                if (buildsForId.size() != 1) {
                    throw new Exception("Multiple builds mapped to this build id.");
                }
                currentBuild = (Build)buildsForId.get(0);
                if (!haveInitializedAction) {
                    logMonitor = new CloudWatchMonitor(awsClientFactory.getCloudWatchLogsClient(), Boolean.parseBoolean(this.getParameterized(this.cwlStreamingDisabled)));
                    action = new CodeBuildAction(build);
                    String buildARN = currentBuild.getArn();
                    this.codeBuildResult.setBuildInformation(currentBuild.getId(), buildARN);
                    action.setBuildId(buildId);
                    action.setBuildARN(buildARN);
                    action.setStartTime(currentBuild.getStartTime().toString());
                    ProjectSource source = currentBuild.getSource();
                    if (source != null) {
                        action.setSourceType(source.getType());
                        action.setSourceLocation(source.getLocation());
                        if (currentBuild.getSourceVersion() == null) {
                            action.setSourceVersion("");
                        } else {
                            action.setSourceVersion(currentBuild.getSourceVersion());
                        }
                        Integer depth = source.getGitCloneDepth();
                        if (depth == null || depth == 0) {
                            action.setGitCloneDepth("Full");
                        } else {
                            action.setGitCloneDepth(String.valueOf(depth));
                        }
                        Boolean status = source.getReportBuildStatus();
                        if (status != null) {
                            action.setReportBuildStatus(String.valueOf(status));
                        }
                    }
                    action.setArtifactTypeOverride(this.getParameterized(this.artifactTypeOverride));
                    action.setCodeBuildDashboardURL(this.generateDashboardURL(buildId));
                    action.setLogs(new ArrayList<String>());
                    action.setCloudWatchLogsURL("");
                    action.setS3LogsURL("");
                    build.addAction((Action)action);
                    haveInitializedAction = true;
                }
                this.updateDashboard(currentBuild, action, logMonitor, listener);
                Thread.sleep(this.getSleepTime(this.descriptor));
            }
            catch (Exception e) {
                if (e.getClass().equals(InterruptedException.class)) {
                    List buildsForId = cbClient.batchGetBuilds(new BatchGetBuildsRequest().withIds(new String[]{buildId})).getBuilds();
                    currentBuild = (Build)buildsForId.get(0);
                    if (!currentBuild.getCurrentPhase().equals(BuildPhaseType.COMPLETED.toString())) {
                        cbClient.stopBuild(new StopBuildRequest().withId(buildId));
                        do {
                            buildsForId = cbClient.batchGetBuilds(new BatchGetBuildsRequest().withIds(new String[]{buildId})).getBuilds();
                            currentBuild = (Build)buildsForId.get(0);
                            Thread.sleep(5000L);
                            logMonitor.pollForLogs(listener);
                            this.updateDashboard(currentBuild, action, logMonitor, listener);
                        } while (!currentBuild.getCurrentPhase().equals(BuildPhaseType.COMPLETED.toString()));
                    }
                    if (action != null) {
                        action.setJenkinsBuildSucceeds(false);
                    }
                    this.codeBuildResult.setStopped();
                    build.setResult(Result.ABORTED);
                    return;
                }
                if (e.getMessage().contains(httpTimeoutMessage)) {
                    Thread.sleep(this.getSleepTime(this.descriptor));
                    continue;
                }
                if (action != null) {
                    action.setJenkinsBuildSucceeds(false);
                }
                this.failBuild(build, listener, e.getMessage(), "");
                return;
            }
        } while (currentBuild.getBuildStatus().equals(StatusType.IN_PROGRESS.toString()));
        this.codeBuildResult.setArtifactsLocation(currentBuild.getArtifacts() != null ? currentBuild.getArtifacts().getLocation() : null);
        if (this.downloadArtifacts.equalsIgnoreCase(Boolean.TRUE.toString())) {
            this.downloadArtifactsFromS3(listener, awsClientFactory.getS3Client(), currentBuild, this.getArtifactRoot(ws));
        }
        if (currentBuild.getBuildStatus().equals(StatusType.SUCCEEDED.toString().toUpperCase(Locale.ENGLISH))) {
            action.setJenkinsBuildSucceeds(true);
            this.codeBuildResult.setSuccess();
            build.setResult(Result.SUCCESS);
        } else {
            action.setJenkinsBuildSucceeds(false);
            this.failBuild(build, listener, "Build " + currentBuild.getId() + " failed", action.getPhaseErrorMessage());
        }
    }

    private void downloadArtifactsFromS3(@Nonnull TaskListener listener, AmazonS3Client s3Client, Build build, String artifactRoot) {
        try {
            S3Downloader s3Downloader = new S3Downloader(s3Client);
            s3Downloader.downloadBuildArtifacts(listener, build, artifactRoot);
        }
        catch (Exception e) {
            LoggingHelper.log(listener, e.getMessage());
        }
    }

    public String getArtifactRoot(FilePath ws) {
        StringBuilder destinationPath = new StringBuilder(ws.getRemote());
        return destinationPath.append(File.separatorChar).append(this.downloadArtifactsRelativePath).toString();
    }

    private int getSleepTime(DescriptorImpl desc) {
        int secondToMs = (int)TimeUnit.SECONDS.toMillis(1L);
        int sleepTimeInMs = secondToMs * desc.getMinSleepTime() + secondToMs * this.batchGetBuildsCalls++;
        return Math.min(sleepTimeInMs, secondToMs * desc.getMaxSleepTime()) + ThreadLocalRandom.current().nextInt(secondToMs * desc.getSleepJitter());
    }

    private String retrieveProjectSourceInfo(AWSCodeBuildClient cbClient) throws RuntimeException, InvalidInputException {
        BatchGetProjectsResult bgpResult = cbClient.batchGetProjects(new BatchGetProjectsRequest().withNames(new String[]{this.getParameterized(this.projectName)}));
        if (bgpResult.getProjects().isEmpty()) {
            throw new RuntimeException("Project " + this.getParameterized(this.projectName) + " does not exist.");
        }
        String projectSourceLocation = ((Project)bgpResult.getProjects().get(0)).getSource().getLocation();
        String projectSourceType = ((Project)bgpResult.getProjects().get(0)).getSource().getType();
        if (!CodeBuilderValidation.checkSourceTypeS3(projectSourceType)) {
            throw new InvalidInputException(jenkinsSourceProjectSourceTypeError);
        }
        return projectSourceLocation;
    }

    private void updateDashboard(Build b, CodeBuildAction action, CloudWatchMonitor logMonitor, TaskListener listener) {
        if (action != null) {
            action.setCurrentStatus(b.getBuildStatus());
            logMonitor.setLogsLocation(b.getLogs());
            logMonitor.pollForLogs(listener);
            action.updateLogs(logMonitor.getLatestLogs());
            action.setPhases(b.getPhases());
            action.setS3ArtifactURL(this.generateS3ArtifactURL(this.artifactTypeOverride, b.getArtifacts().getLocation()));
            action.setS3BucketName(b.getArtifacts().getLocation());
            if (logMonitor.getLogsLocation() != null) {
                LogsLocation logsLocation = logMonitor.getLogsLocation();
                if (logsLocation.getGroupName() != null && logsLocation.getStreamName() != null && logsLocation.getDeepLink() != null && action.getCloudWatchLogsURL().equals("")) {
                    String cloudWatchLogsURL = logsLocation.getDeepLink();
                    action.setCloudWatchLogsURL(cloudWatchLogsURL);
                    LoggingHelper.log(listener, "CloudWatch dashboard: " + cloudWatchLogsURL);
                }
                if (logsLocation.getS3DeepLink() != null && b.getPhases() != null && action.getS3LogsURL().equals("")) {
                    List phases = b.getPhases();
                    for (BuildPhase phase : phases) {
                        if (phase.getPhaseType() == null || !phase.getPhaseType().equals(BuildPhaseType.UPLOAD_ARTIFACTS.toString()) || phase.getContexts() == null || phase.getContexts().get(0) == null || ((PhaseContext)phase.getContexts().get(0)).getMessage() == null || ((PhaseContext)phase.getContexts().get(0)).getMessage().contains("Error uploading logs:")) continue;
                        String s3LogsURL = logsLocation.getS3DeepLink();
                        action.setS3LogsURL(s3LogsURL);
                        LoggingHelper.log(listener, "S3 logs location: " + s3LogsURL);
                    }
                }
            }
        }
    }

    public String generateS3ArtifactURL(String artifactsTypeOverride, String artifactLocation) {
        if (artifactsTypeOverride != null && artifactsTypeOverride.equals(ArtifactsType.NO_ARTIFACTS.toString()) || artifactLocation == null || artifactLocation.isEmpty()) {
            return "";
        }
        return s3BucketBaseURL + artifactLocation.replace(s3ARNPrefix, "");
    }

    private String generateDashboardURL(String buildId) {
        return "https://" + this.getParameterized(this.region) + ".console.aws.amazon.com/codesuite/codebuild/projects/" + this.getParameterized(this.projectName) + "/build/" + this.getParameterized(buildId) + "/log?region=" + this.region;
    }

    private void logStartBuildMessage(TaskListener listener, String sourceVersion) {
        StringBuilder message = new StringBuilder().append("Starting build with \n\t> project name: " + this.getParameterized(this.projectName));
        if (!SourceControlType.JenkinsSource.toString().equals(this.getParameterized(this.sourceControlType))) {
            if (!this.gitCloneDepthOverride.isEmpty()) {
                message.append("\n\t> git clone depth: " + this.getParameterized(this.gitCloneDepthOverride) + " (git clone depth is omitted when source provider is Amazon S3)");
            }
            if (!this.reportBuildStatusOverride.isEmpty()) {
                message.append("\n\t> report build status: " + this.getParameterized(this.reportBuildStatusOverride) + " (report build status is valid when source provider is GitHub)");
            }
        }
        if (!this.sourceTypeOverride.isEmpty()) {
            message.append("\n\t> source type: " + this.getParameterized(this.sourceTypeOverride));
        }
        if (!this.sourceLocationOverride.isEmpty()) {
            message.append("\n\t> source location: " + this.getParameterized(this.sourceLocationOverride));
        }
        if (!sourceVersion.isEmpty()) {
            message.append("\n\t> source version: " + sourceVersion);
        }
        if (!this.secondarySourcesOverride.isEmpty()) {
            message.append("\n\t> secondary source overrides: " + this.getParameterized(this.secondarySourcesOverride));
        }
        if (!this.secondarySourcesVersionOverride.isEmpty()) {
            message.append("\n\t> secondary source version overrides: " + this.getParameterized(this.secondarySourcesVersionOverride));
        }
        if (!this.artifactTypeOverride.isEmpty()) {
            message.append("\n\t> artifact type: " + this.getParameterized(this.artifactTypeOverride));
        }
        if (!this.artifactLocationOverride.isEmpty()) {
            message.append("\n\t> artifact location: " + this.getParameterized(this.artifactLocationOverride));
        }
        if (!this.artifactNameOverride.isEmpty()) {
            message.append("\n\t> artifact name: " + this.getParameterized(this.artifactNameOverride));
        }
        if (!this.overrideArtifactName.isEmpty()) {
            message.append("\n\t> overrideArtifactName: " + this.getParameterized(this.overrideArtifactName));
        }
        if (!this.artifactNamespaceOverride.isEmpty()) {
            message.append("\n\t> artifact namespace: " + this.getParameterized(this.artifactNamespaceOverride));
        }
        if (!this.artifactPackagingOverride.isEmpty()) {
            message.append("\n\t> artifact packaging: " + this.getParameterized(this.artifactPackagingOverride));
        }
        if (!this.artifactPathOverride.isEmpty()) {
            message.append("\n\t> artifact path: " + this.getParameterized(this.artifactPathOverride));
        }
        if (!this.artifactEncryptionDisabledOverride.isEmpty()) {
            message.append("\n\t> artifact encryption disabled: " + this.getParameterized(this.artifactEncryptionDisabledOverride));
        }
        if (!this.secondaryArtifactsOverride.isEmpty()) {
            message.append("\n\t> secondary artifact overrides: " + this.getParameterized(this.secondaryArtifactsOverride));
        }
        if (!this.envVariables.isEmpty()) {
            message.append("\n\t> environment variables: " + this.getParameterized(this.envVariables));
        }
        if (!this.buildTimeoutOverride.isEmpty()) {
            message.append("\n\t> build timeout: " + this.getParameterized(this.buildTimeoutOverride));
        }
        if (!this.cacheTypeOverride.isEmpty()) {
            message.append("\n\t> cache type: " + this.getParameterized(this.cacheTypeOverride));
        }
        if (!this.cacheLocationOverride.isEmpty()) {
            message.append("\n\t> cache location: " + this.getParameterized(this.cacheLocationOverride));
        }
        if (!this.cacheModesOverride.isEmpty()) {
            message.append("\n\t> cache modes: " + this.getParameterized(this.cacheModesOverride));
        }
        if (!this.cloudWatchLogsStatusOverride.isEmpty()) {
            message.append("\n\t> cloudwatch logs status: " + this.getParameterized(this.cloudWatchLogsStatusOverride));
        }
        if (!this.cloudWatchLogsGroupNameOverride.isEmpty()) {
            message.append("\n\t> cloudwatch logs group name: " + this.getParameterized(this.cloudWatchLogsGroupNameOverride));
        }
        if (!this.cloudWatchLogsStreamNameOverride.isEmpty()) {
            message.append("\n\t> cloudwatch logs stream name: " + this.getParameterized(this.cloudWatchLogsStreamNameOverride));
        }
        if (!this.s3LogsStatusOverride.isEmpty()) {
            message.append("\n\t> s3 logs status: " + this.getParameterized(this.s3LogsStatusOverride));
        }
        if (!this.s3LogsEncryptionDisabledOverride.isEmpty()) {
            message.append("\n\t> s3 logs encryption disabled: " + this.getParameterized(this.s3LogsEncryptionDisabledOverride));
        }
        if (!this.s3LogsLocationOverride.isEmpty()) {
            message.append("\n\t> s3 logs location: " + this.getParameterized(this.s3LogsLocationOverride));
        }
        if (!this.environmentTypeOverride.isEmpty()) {
            message.append("\n\t> environment type: " + this.getParameterized(this.environmentTypeOverride));
        }
        if (!this.imageOverride.isEmpty()) {
            message.append("\n\t> image: " + this.getParameterized(this.imageOverride));
        }
        if (!this.privilegedModeOverride.isEmpty()) {
            message.append("\n\t> privileged mode override: " + this.getParameterized(this.privilegedModeOverride));
        }
        if (!this.computeTypeOverride.isEmpty()) {
            message.append("\n\t> compute type: " + this.getParameterized(this.computeTypeOverride));
        }
        if (!this.insecureSslOverride.isEmpty()) {
            message.append("\n\t> insecure ssl override: " + this.getParameterized(this.insecureSslOverride));
        }
        if (!this.certificateOverride.isEmpty()) {
            message.append("\n\t> certificate: " + this.getParameterized(this.certificateOverride));
        }
        if (!this.serviceRoleOverride.isEmpty()) {
            message.append("\n\t> service role: " + this.getParameterized(this.serviceRoleOverride));
        }
        if (!this.cwlStreamingDisabled.isEmpty()) {
            message.append("\n\t> CloudWatch logs streaming disabled: " + this.getParameterized(this.cwlStreamingDisabled));
        }
        if (!this.exceptionFailureMode.isEmpty()) {
            message.append("\n\t> exception failure mode status: " + this.getParameterized(this.exceptionFailureMode));
        }
        if (!this.downloadArtifacts.isEmpty()) {
            message.append("\n\t> Download build artifacts: " + this.getParameterized(this.downloadArtifacts));
        }
        if (!this.downloadArtifactsRelativePath.isEmpty()) {
            message.append("\n\t> Download build artifacts relative path: " + this.getParameterized(this.downloadArtifactsRelativePath));
        }
        if (!this.buildSpecFile.isEmpty()) {
            message.append("\n\t> build spec: \n" + this.getParameterized(this.buildSpecFile));
        }
        LoggingHelper.log(listener, message.toString());
    }

    private Integer generateStartBuildGitCloneDepthOverride() {
        String depth = this.getParameterized(this.gitCloneDepthOverride);
        if (depth.isEmpty() || depth.equals("Full")) {
            return 0;
        }
        return Integer.parseInt(depth);
    }

    private ProjectArtifacts generateStartBuildArtifactOverride() {
        ProjectArtifacts artifacts = new ProjectArtifacts();
        boolean overridesSpecified = false;
        if (!this.getParameterized(this.artifactTypeOverride).isEmpty()) {
            artifacts.setType(this.getParameterized(this.artifactTypeOverride));
            overridesSpecified = true;
        }
        if (!this.getParameterized(this.artifactLocationOverride).isEmpty()) {
            artifacts.setLocation(this.getParameterized(this.artifactLocationOverride));
            overridesSpecified = true;
        }
        if (!this.getParameterized(this.artifactNameOverride).isEmpty()) {
            artifacts.setName(this.getParameterized(this.artifactNameOverride));
            overridesSpecified = true;
        }
        if (!this.getParameterized(this.artifactNamespaceOverride).isEmpty()) {
            artifacts.setNamespaceType(this.getParameterized(this.artifactNamespaceOverride));
            overridesSpecified = true;
        }
        if (!this.getParameterized(this.artifactPackagingOverride).isEmpty()) {
            artifacts.setPackaging(this.getParameterized(this.artifactPackagingOverride));
            overridesSpecified = true;
        }
        if (!this.getParameterized(this.artifactPathOverride).isEmpty()) {
            artifacts.setPath(this.getParameterized(this.artifactPathOverride));
            overridesSpecified = true;
        }
        if (!this.getParameterized(this.artifactEncryptionDisabledOverride).isEmpty()) {
            artifacts.setEncryptionDisabled(Boolean.valueOf(Boolean.parseBoolean(this.artifactEncryptionDisabledOverride)));
            overridesSpecified = true;
        }
        if (!this.getParameterized(this.overrideArtifactName).isEmpty()) {
            artifacts.setOverrideArtifactName(Boolean.valueOf(Boolean.parseBoolean(this.overrideArtifactName)));
            overridesSpecified = true;
        }
        return overridesSpecified ? artifacts : null;
    }

    private ProjectCache generateStartBuildCacheOverride() {
        List<String> cacheModes;
        ProjectCache cache = new ProjectCache();
        boolean overridesSpecified = false;
        if (!this.getParameterized(this.cacheTypeOverride).isEmpty()) {
            cache.setType(this.getParameterized(this.cacheTypeOverride));
            overridesSpecified = true;
        }
        if (!(cacheModes = CodeBuilder.listCacheModes(this.getParameterized(this.cacheModesOverride))).isEmpty() && cache.getType().equals("LOCAL")) {
            cache.setModes(cacheModes);
            overridesSpecified = true;
        }
        if (!this.getParameterized(this.cacheLocationOverride).isEmpty()) {
            cache.setLocation(this.getParameterized(this.cacheLocationOverride));
            overridesSpecified = true;
        }
        return overridesSpecified ? cache : null;
    }

    public static List<String> listCacheModes(String cacheModes) {
        if (cacheModes == null || cacheModes.isEmpty()) {
            return Collections.emptyList();
        }
        cacheModes = cacheModes.replaceAll("^.|.$", "");
        return Arrays.asList(cacheModes.split("\\s*,\\s*"));
    }

    private LogsConfig generateStartBuildLogsConfigOverride() {
        LogsConfig logsConfig = new LogsConfig();
        CloudWatchLogsConfig cloudWatchLogsConfig = new CloudWatchLogsConfig();
        S3LogsConfig s3LogsConfig = new S3LogsConfig();
        boolean overridesCloudWatchLogsSpecified = false;
        boolean overridesS3LogsSpecified = false;
        if (!this.getParameterized(this.cloudWatchLogsStatusOverride).isEmpty()) {
            cloudWatchLogsConfig.setStatus(this.getParameterized(this.cloudWatchLogsStatusOverride));
            overridesCloudWatchLogsSpecified = true;
        }
        if (!this.getParameterized(this.cloudWatchLogsGroupNameOverride).isEmpty()) {
            cloudWatchLogsConfig.setGroupName(this.getParameterized(this.cloudWatchLogsGroupNameOverride));
            overridesCloudWatchLogsSpecified = true;
        }
        if (!this.getParameterized(this.cloudWatchLogsStreamNameOverride).isEmpty()) {
            cloudWatchLogsConfig.setStreamName(this.getParameterized(this.cloudWatchLogsStreamNameOverride));
            overridesCloudWatchLogsSpecified = true;
        }
        if (!this.getParameterized(this.s3LogsStatusOverride).isEmpty()) {
            s3LogsConfig.setStatus(this.getParameterized(this.s3LogsStatusOverride));
            overridesS3LogsSpecified = true;
        }
        if (!this.getParameterized(this.s3LogsEncryptionDisabledOverride).isEmpty()) {
            s3LogsConfig.setEncryptionDisabled(Boolean.valueOf(Boolean.parseBoolean(this.getParameterized(this.s3LogsEncryptionDisabledOverride))));
            overridesS3LogsSpecified = true;
        }
        if (!this.getParameterized(this.s3LogsLocationOverride).isEmpty()) {
            s3LogsConfig.setLocation(this.getParameterized(this.s3LogsLocationOverride));
            overridesS3LogsSpecified = true;
        }
        if (overridesCloudWatchLogsSpecified) {
            logsConfig.setCloudWatchLogs(cloudWatchLogsConfig);
        }
        if (overridesS3LogsSpecified) {
            logsConfig.setS3Logs(s3LogsConfig);
        }
        return overridesCloudWatchLogsSpecified || overridesS3LogsSpecified ? logsConfig : null;
    }

    private SourceAuth generateStartBuildSourceAuthOverride(String sourceType) {
        SourceAuth auth = null;
        if (sourceType.equals(SourceType.GITHUB.toString()) || sourceType.equals(SourceType.BITBUCKET.toString())) {
            auth = new SourceAuth().withType(SourceAuthType.OAUTH.toString());
        }
        return auth;
    }

    public static Collection<EnvironmentVariable> mapEnvVariables(String envVars, EnvironmentVariableType envVarType) throws InvalidInputException {
        HashSet<EnvironmentVariable> result = new HashSet<EnvironmentVariable>();
        if (envVars == null || envVars.isEmpty()) {
            return result;
        }
        envVars = envVars.replaceAll("\\}\\s*,\\s*\\{", "},{");
        envVars = envVars.replaceAll("\\[\\s*\\{", "[{");
        envVars = envVars.replaceAll("\\}\\s*\\]", "}]");
        if ((envVars = envVars.replaceAll("[\\n|\\t]", "").trim()).length() < 4 || envVars.charAt(0) != '[' || envVars.charAt(envVars.length() - 1) != ']' || envVars.charAt(1) != '{' || envVars.charAt(envVars.length() - 2) != '}') {
            throw new InvalidInputException(envVariableSyntaxError);
        }
        int numCommas = (envVars = envVars.substring(2, envVars.length() - 2)).replaceAll("[^,]", "").length();
        if (numCommas == 0) {
            throw new InvalidInputException(envVariableSyntaxError);
        }
        if (numCommas == 1) {
            result.add(CodeBuilder.deserializeCodeBuildEnvVar(envVars, envVarType));
        } else {
            String[] evs = envVars.split("\\},\\{");
            for (int i = 0; i < evs.length; ++i) {
                result.add(CodeBuilder.deserializeCodeBuildEnvVar(evs[i], envVarType));
            }
        }
        return result;
    }

    private static EnvironmentVariable deserializeCodeBuildEnvVar(String ev, EnvironmentVariableType envVarType) throws InvalidInputException {
        if (ev.replaceAll("\\\\,", "").replaceAll("[^,]", "").length() != 1) {
            throw new InvalidInputException(envVariableSyntaxError);
        }
        String[] keyAndValue = ev.split("(?<!\\\\),");
        if (keyAndValue.length != 2 || keyAndValue[0].isEmpty() || keyAndValue[1].isEmpty()) {
            throw new InvalidInputException(envVariableSyntaxError);
        }
        return new EnvironmentVariable().withName(keyAndValue[0].trim().replaceAll("\\\\,", ",")).withValue(keyAndValue[1].trim().replaceAll("\\\\,", ",")).withType(envVarType);
    }

    private void failBuild(Run<?, ?> build, TaskListener listener, String errorMessage, String secondaryError) throws AbortException {
        this.codeBuildResult.setFailure(errorMessage, secondaryError);
        LoggingHelper.log(listener, errorMessage, secondaryError);
        if (!this.exceptionFailureMode.isEmpty() && this.getParameterized(this.exceptionFailureMode).equalsIgnoreCase(LogsConfigStatusType.ENABLED.toString())) {
            throw new AbortException(errorMessage + "\n\t> " + secondaryError);
        }
        build.setResult(Result.FAILURE);
    }

    public String getParameterized(String codeBuildParam) {
        String result = this.envVars.expand(codeBuildParam);
        if (result == null) {
            return "";
        }
        return result;
    }

    public String sourceControlTypeEquals(String given) {
        return String.valueOf(this.sourceControlType != null && this.sourceControlType.equals(given));
    }

    public String credentialsTypeEquals(String given) {
        return String.valueOf(this.credentialsType != null && this.credentialsType.equals(given));
    }

    public String downloadArtifactsEquals(String given) {
        return String.valueOf(this.downloadArtifacts != null && this.downloadArtifacts.equalsIgnoreCase(given));
    }

    public static String decodeJSON(String json) {
        return json.replaceAll("&amp;quot;", "\"").replaceAll("&quot;", "\"").replaceAll("&amp;", "&").replaceAll("&gt;", ">").replaceAll("&lt;", "<").replaceAll("''", "'");
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getCredentialsType() {
        return this.credentialsType;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    public Secret getAwsSecretKey() {
        return this.awsSecretKey;
    }

    public String getAwsSessionToken() {
        return this.awsSessionToken;
    }

    public String getRegion() {
        return this.region;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getSourceControlType() {
        return this.sourceControlType;
    }

    public String getLocalSourcePath() {
        return this.localSourcePath;
    }

    public String getWorkspaceSubdir() {
        return this.workspaceSubdir;
    }

    public String getSourceVersion() {
        return this.sourceVersion;
    }

    public String getSseAlgorithm() {
        return this.sseAlgorithm;
    }

    public String getGitCloneDepthOverride() {
        return this.gitCloneDepthOverride;
    }

    public String getReportBuildStatusOverride() {
        return this.reportBuildStatusOverride;
    }

    public String getSecondarySourcesOverride() {
        return this.secondarySourcesOverride;
    }

    public String getSecondarySourcesVersionOverride() {
        return this.secondarySourcesVersionOverride;
    }

    public String getArtifactTypeOverride() {
        return this.artifactTypeOverride;
    }

    public String getArtifactLocationOverride() {
        return this.artifactLocationOverride;
    }

    public String getArtifactNameOverride() {
        return this.artifactNameOverride;
    }

    public String getArtifactNamespaceOverride() {
        return this.artifactNamespaceOverride;
    }

    public String getArtifactPackagingOverride() {
        return this.artifactPackagingOverride;
    }

    public String getArtifactPathOverride() {
        return this.artifactPathOverride;
    }

    public String getArtifactEncryptionDisabledOverride() {
        return this.artifactEncryptionDisabledOverride;
    }

    public String getOverrideArtifactName() {
        return this.overrideArtifactName;
    }

    public String getSecondaryArtifactsOverride() {
        return this.secondaryArtifactsOverride;
    }

    public String getEnvironmentTypeOverride() {
        return this.environmentTypeOverride;
    }

    public String getImageOverride() {
        return this.imageOverride;
    }

    public String getComputeTypeOverride() {
        return this.computeTypeOverride;
    }

    public String getCertificateOverride() {
        return this.certificateOverride;
    }

    public String getCacheTypeOverride() {
        return this.cacheTypeOverride;
    }

    public String getCacheLocationOverride() {
        return this.cacheLocationOverride;
    }

    public String getCacheModesOverride() {
        return this.cacheModesOverride;
    }

    public String getCloudWatchLogsStatusOverride() {
        return this.cloudWatchLogsStatusOverride;
    }

    public String getCloudWatchLogsGroupNameOverride() {
        return this.cloudWatchLogsGroupNameOverride;
    }

    public String getCloudWatchLogsStreamNameOverride() {
        return this.cloudWatchLogsStreamNameOverride;
    }

    public String getS3LogsStatusOverride() {
        return this.s3LogsStatusOverride;
    }

    public String getS3LogsEncryptionDisabledOverride() {
        return this.s3LogsEncryptionDisabledOverride;
    }

    public String getS3LogsLocationOverride() {
        return this.s3LogsLocationOverride;
    }

    public String getServiceRoleOverride() {
        return this.serviceRoleOverride;
    }

    public String getPrivilegedModeOverride() {
        return this.privilegedModeOverride;
    }

    public String getSourceTypeOverride() {
        return this.sourceTypeOverride;
    }

    public String getSourceLocationOverride() {
        return this.sourceLocationOverride;
    }

    public String getInsecureSslOverride() {
        return this.insecureSslOverride;
    }

    public String getEnvVariables() {
        return this.envVariables;
    }

    public String getEnvParameters() {
        return this.envParameters;
    }

    public String getBuildSpecFile() {
        return this.buildSpecFile;
    }

    public String getBuildTimeoutOverride() {
        return this.buildTimeoutOverride;
    }

    public String getCwlStreamingDisabled() {
        return this.cwlStreamingDisabled;
    }

    public CodeBuildResult getCodeBuildResult() {
        return this.codeBuildResult;
    }

    public String getExceptionFailureMode() {
        return this.exceptionFailureMode;
    }

    public String getDownloadArtifacts() {
        return this.downloadArtifacts;
    }

    public String getDownloadArtifactsRelativePath() {
        return this.downloadArtifactsRelativePath;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private static final int DEFAULT_MIN_SLEEP_TIME = 3;
        private static final int DEFAULT_MAX_SLEEP_TIME = 60;
        private static final int DEFAULT_SLEEP_JITTER = 5;
        private static final int MAX_BUILD_DURATION = (int)TimeUnit.HOURS.toSeconds(8L);
        private int minSleepTime;
        private int maxSleepTime;
        private int sleepJitter;

        public DescriptorImpl() {
            this.load();
        }

        public int getMinSleepTime() {
            if (this.minSleepTime <= 0) {
                return 3;
            }
            return this.minSleepTime;
        }

        public int getMaxSleepTime() {
            if (this.minSleepTime <= 0 || this.maxSleepTime <= 0 || this.minSleepTime > this.maxSleepTime) {
                return 60;
            }
            return this.maxSleepTime;
        }

        public int getSleepJitter() {
            if (this.sleepJitter <= 0) {
                return 5;
            }
            return this.sleepJitter;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindJSON((Object)this, formData);
            this.minSleepTime = formData.optInt("minSleepTime", 0);
            this.maxSleepTime = formData.optInt("maxSleepTime", 0);
            this.sleepJitter = formData.optInt("sleepJitter", 0);
            this.save();
            return super.configure(req, formData);
        }

        public ListBoxModel doFillGitCloneDepthOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            for (GitCloneDepth t : GitCloneDepth.values()) {
                selections.add(t.toString());
            }
            return selections;
        }

        public ListBoxModel doFillReportBuildStatusOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            for (BooleanValue t : BooleanValue.values()) {
                selections.add(t.toString());
            }
            return selections;
        }

        public ListBoxModel doFillPrivilegedModeOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            for (BooleanValue t : BooleanValue.values()) {
                selections.add(t.toString());
            }
            return selections;
        }

        public ListBoxModel doFillInsecureSslOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            for (BooleanValue t : BooleanValue.values()) {
                selections.add(t.toString());
            }
            return selections;
        }

        public ListBoxModel doFillArtifactTypeOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            for (ArtifactsType t : ArtifactsType.values()) {
                selections.add(t.toString());
            }
            selections.add("");
            return selections;
        }

        public ListBoxModel doFillArtifactNamespaceOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            for (ArtifactNamespace t : ArtifactNamespace.values()) {
                selections.add(t.toString());
            }
            selections.add("");
            return selections;
        }

        public ListBoxModel doFillArtifactPackagingOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            for (ArtifactPackaging t : ArtifactPackaging.values()) {
                selections.add(t.toString());
            }
            selections.add("");
            return selections;
        }

        public ListBoxModel doFillArtifactEncryptionDisabledOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            for (BooleanValue t : BooleanValue.values()) {
                selections.add(t.toString());
            }
            return selections;
        }

        public ListBoxModel doFillOverrideArtifactNameItems() {
            ListBoxModel selections = new ListBoxModel();
            for (BooleanValue t : BooleanValue.values()) {
                selections.add(t.toString());
            }
            return selections;
        }

        public ListBoxModel doFillSourceTypeOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            for (SourceType t : SourceType.values()) {
                if (t.equals((Object)SourceType.CODEPIPELINE)) continue;
                selections.add(t.toString());
            }
            selections.add("");
            return selections;
        }

        public ListBoxModel doFillComputeTypeOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            for (ComputeType t : ComputeType.values()) {
                selections.add(t.toString());
            }
            selections.add("");
            return selections;
        }

        public ListBoxModel doFillCacheTypeOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            for (CacheType t : CacheType.values()) {
                selections.add(t.toString());
            }
            selections.add("");
            return selections;
        }

        public ListBoxModel doFillCloudWatchLogsStatusOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            for (LogsConfigStatusType t : LogsConfigStatusType.values()) {
                selections.add(t.toString());
            }
            selections.add("");
            return selections;
        }

        public ListBoxModel doFillS3LogsStatusOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            for (LogsConfigStatusType t : LogsConfigStatusType.values()) {
                selections.add(t.toString());
            }
            selections.add("");
            return selections;
        }

        public ListBoxModel doFillS3LogsEncryptionDisabledOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            for (BooleanValue t : BooleanValue.values()) {
                selections.add(t.toString());
            }
            return selections;
        }

        public ListBoxModel doFillEnvironmentTypeOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            for (EnvironmentType t : EnvironmentType.values()) {
                selections.add(t.toString());
            }
            selections.add("");
            return selections;
        }

        public ListBoxModel doFillCredentialsIdItems() {
            ListBoxModel selections = new ListBoxModel();
            SystemCredentialsProvider s = SystemCredentialsProvider.getInstance();
            HashSet<String> displayCredentials = new HashSet<String>();
            for (Credentials c : s.getCredentials()) {
                if (!(c instanceof CodeBuildBaseCredentials)) continue;
                displayCredentials.add(((CodeBuildBaseCredentials)c).getId());
            }
            Jenkins instance = Jenkins.getInstance();
            if (instance != null) {
                List folders = instance.getAllItems(Folder.class);
                for (Folder folder : folders) {
                    List creds = CredentialsProvider.lookupCredentials(Credentials.class, (Item)folder);
                    for (Credentials cred : creds) {
                        if (!(cred instanceof CodeBuildBaseCredentials)) continue;
                        displayCredentials.add(((CodeBuildBaseCredentials)cred).getId());
                    }
                }
            }
            for (String credString : displayCredentials) {
                selections.add(credString);
            }
            return selections;
        }

        public ListBoxModel doFillSseAlgorithmItems() {
            ListBoxModel selections = new ListBoxModel();
            for (EncryptionAlgorithm e : EncryptionAlgorithm.values()) {
                selections.add(e.toString());
            }
            return selections;
        }

        public ListBoxModel doFillCwlStreamingDisabledItems() {
            ListBoxModel selections = new ListBoxModel();
            for (BooleanValue t : BooleanValue.values()) {
                selections.add(t.toString());
            }
            return selections;
        }

        public ListBoxModel doFillExceptionFailureModeItems() {
            ListBoxModel selections = new ListBoxModel();
            for (LogsConfigStatusType t : LogsConfigStatusType.values()) {
                selections.add(t.toString());
            }
            selections.add("");
            return selections;
        }

        public FormValidation doCheckMaxSleepTime(@QueryParameter String minSleepTime, @QueryParameter String maxSleepTime, @QueryParameter String sleepJitter) {
            Integer min = 0;
            try {
                min = Validation.parseInt(minSleepTime);
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Not a positive integer");
            }
            if (min == null || min <= 0) {
                return FormValidation.error((String)"Not a positive integer");
            }
            if (min > MAX_BUILD_DURATION) {
                return FormValidation.error((String)"Cannot be greater than 28800 (eight hours)");
            }
            Integer max = 0;
            try {
                max = Validation.parseInt(maxSleepTime);
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Not a positive integer");
            }
            if (max == null || max <= 0) {
                return FormValidation.error((String)"Not a positive integer");
            }
            if (max > MAX_BUILD_DURATION) {
                return FormValidation.error((String)"Cannot be greater than 28800 (eight hours)");
            }
            if (min > max) {
                return FormValidation.error((String)"Must be greater than minimum interval");
            }
            Integer jitter = 0;
            try {
                jitter = Validation.parseInt(sleepJitter);
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Not a positive integer");
            }
            if (jitter == null || jitter <= 0) {
                return FormValidation.error((String)"Not a positive integer");
            }
            if (max > MAX_BUILD_DURATION) {
                return FormValidation.error((String)"Cannot be greater than 28800 (eight hours)");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckS3LogsEncryptionDisabledOverride(@QueryParameter String s3LogsEncryptionDisabledOverride, @QueryParameter String s3LogsStatusOverride) {
            if ((s3LogsStatusOverride == null || s3LogsStatusOverride.isEmpty()) && s3LogsEncryptionDisabledOverride != null && !s3LogsEncryptionDisabledOverride.isEmpty()) {
                return FormValidation.error((String)"'S3 Logs Status Override' value must be provided");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckS3LogsLocationOverride(@QueryParameter String s3LogsLocationOverride, @QueryParameter String s3LogsStatusOverride) {
            if (!LogsConfigStatusType.ENABLED.toString().equals(s3LogsStatusOverride)) {
                if (s3LogsLocationOverride != null && !s3LogsLocationOverride.isEmpty()) {
                    return FormValidation.error((String)"'S3 Logs Location Override' must be null if 'S3 Logs Status Override' is 'DISABLED' or empty");
                }
            } else if (s3LogsLocationOverride == null || s3LogsLocationOverride.isEmpty()) {
                return FormValidation.error((String)"'S3 Logs Location Override' must be provided if 'S3 Logs Status Override' is 'ENABLED'");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "AWS CodeBuild";
        }
    }
}

