/*
 * Decompiled with CFR 0.152.
 */
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.codebuild.jenkinsplugin.CodeBuildBaseCredentials;
import com.amazonaws.codebuild.jenkinsplugin.Validation;
import com.amazonaws.regions.Regions;
import com.amazonaws.retry.PredefinedBackoffStrategies;
import com.amazonaws.retry.RetryPolicy;
import com.amazonaws.services.codebuild.AWSCodeBuildClient;
import com.amazonaws.services.codebuild.model.InvalidInputException;
import com.amazonaws.services.logs.AWSLogsClient;
import com.amazonaws.services.s3.AmazonS3Client;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import enums.CredentialsType;
import hudson.EnvVars;
import hudson.model.Item;
import hudson.model.Run;
import hudson.util.Secret;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class AWSClientFactory {
    private final String proxyHost;
    private final Integer proxyPort;
    private final String awsAccessKey;
    private final Secret awsSecretKey;
    private final String awsSessionToken;
    private final String region;
    private String credentialsDescriptor;
    private AWSCredentialsProvider awsCredentialsProvider;
    private final Properties properties;
    private static final String POM_PROPERTIES = "/META-INF/maven/com.amazonaws/aws-codebuild/pom.properties";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AWSClientFactory(String credentialsType, String credentialsId, String proxyHost, String proxyPort, String awsAccessKey, Secret awsSecretKey, String awsSessionToken, String region, Run<?, ?> build, StepContext stepContext) {
        this.awsAccessKey = Validation.sanitize(awsAccessKey);
        this.awsSecretKey = awsSecretKey;
        this.awsSessionToken = Validation.sanitize(awsSessionToken);
        this.region = Validation.sanitize(region);
        this.properties = new Properties();
        CodeBuilderValidation.checkAWSClientFactoryRegionConfig(this.region);
        this.credentialsDescriptor = "";
        if (credentialsType.equals(CredentialsType.Jenkins.toString())) {
            Jenkins instance;
            credentialsId = Validation.sanitize(credentialsId);
            CodeBuilderValidation.checkAWSClientFactoryJenkinsCredentialsConfig(credentialsId);
            CodeBuildBaseCredentials codeBuildCredentials = (CodeBuildBaseCredentials)CredentialsMatchers.firstOrNull((Iterable)SystemCredentialsProvider.getInstance().getCredentials(), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialsId)}));
            if (codeBuildCredentials == null && (instance = Jenkins.getInstance()) != null) {
                Item folder = instance.getItemByFullName(build.getParent().getParent().getFullName());
                codeBuildCredentials = (CodeBuildBaseCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(Credentials.class, (Item)folder), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialsId)}));
            }
            if (codeBuildCredentials == null) throw new InvalidInputException("Invalid credentials ID. Verify that the credentials are of type CodeBuildCredentials and are accessible in this project.");
            this.awsCredentialsProvider = codeBuildCredentials;
            this.proxyHost = codeBuildCredentials.getProxyHost();
            this.proxyPort = Validation.parseInt(codeBuildCredentials.getProxyPort());
            this.credentialsDescriptor = codeBuildCredentials.getCredentialsDescriptor() + " (provided from Jenkins credentials " + credentialsId + ")";
            return;
        }
        if (!credentialsType.equals(CredentialsType.Keys.toString())) throw new InvalidInputException("Invalid credentialsType option; must be 'jenkins' or 'keys'");
        if (this.awsSecretKey == null) {
            throw new InvalidInputException("awsSecretKey cannot be null");
        }
        if (stepContext != null && awsAccessKey.isEmpty() && awsSecretKey.getPlainText().isEmpty()) {
            try {
                EnvVars stepEnvVars = (EnvVars)stepContext.get(EnvVars.class);
                this.awsCredentialsProvider = this.getStepCreds(stepEnvVars);
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        }
        if (this.awsCredentialsProvider == null) {
            this.awsCredentialsProvider = Validation.getBasicCredentialsOrDefaultChain(Validation.sanitize(awsAccessKey), awsSecretKey.getPlainText(), Validation.sanitize(awsSessionToken));
        }
        this.proxyHost = Validation.sanitize(proxyHost);
        this.proxyPort = Validation.parseInt(proxyPort);
    }

    public AWSCodeBuildClient getCodeBuildClient() throws InvalidInputException, IllegalArgumentException {
        AWSCodeBuildClient client = new AWSCodeBuildClient(this.awsCredentialsProvider, this.getClientConfiguration());
        client.setEndpoint("https://codebuild." + this.region + this.getAwsClientSuffix(this.region));
        return client;
    }

    public AmazonS3Client getS3Client() throws InvalidInputException {
        AmazonS3Client client = new AmazonS3Client(this.awsCredentialsProvider, this.getClientConfiguration());
        client.setEndpoint("https://s3." + this.region + this.getAwsClientSuffix(this.region));
        return client;
    }

    public AWSLogsClient getCloudWatchLogsClient() throws InvalidInputException {
        AWSLogsClient client = new AWSLogsClient(this.awsCredentialsProvider, this.getClientConfiguration());
        client.setEndpoint("https://logs." + this.region + this.getAwsClientSuffix(this.region));
        return client;
    }

    private AWSCredentialsProvider getStepCreds(EnvVars stepEnvVars) {
        String stepAccessKey = (String)stepEnvVars.get((Object)"aws_access_key_id");
        String stepSecretKey = (String)stepEnvVars.get((Object)"aws_secret_access_key");
        String stepSessionToken = (String)stepEnvVars.get((Object)"aws_session_token");
        if (stepAccessKey != null && !stepAccessKey.isEmpty() && stepSecretKey != null && !stepSecretKey.isEmpty()) {
            this.credentialsDescriptor = "Using credentials provided by the Jenkins step context for authorization";
            if (stepSessionToken != null && !stepSessionToken.isEmpty()) {
                return new AWSStaticCredentialsProvider((AWSCredentials)new BasicSessionCredentials(stepAccessKey, stepSecretKey, stepSessionToken));
            }
            return new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(stepAccessKey, stepSecretKey));
        }
        return null;
    }

    private ClientConfiguration getClientConfiguration() {
        String projectVersion = "";
        try (InputStream stream2 = this.getClass().getResourceAsStream(POM_PROPERTIES);){
            this.properties.load(stream2);
            projectVersion = "/" + this.properties.getProperty("version");
        }
        catch (IOException stream2) {
            // empty catch block
        }
        ClientConfiguration clientConfig = new ClientConfiguration().withUserAgentPrefix("CodeBuild-Jenkins-Plugin" + projectVersion).withProxyHost(this.proxyHost).withRetryPolicy(new RetryPolicy((RetryPolicy.RetryCondition)new CodeBuildClientRetryCondition(), (RetryPolicy.BackoffStrategy)new PredefinedBackoffStrategies.ExponentialBackoffStrategy(10000, 30000), 10, true));
        if (this.proxyPort != null) {
            clientConfig.setProxyPort(this.proxyPort.intValue());
        }
        return clientConfig;
    }

    public String getCredentialsDescriptor() {
        if (this.credentialsDescriptor.isEmpty()) {
            if (this.awsAccessKey.isEmpty()) {
                return "Using credentials provided by the DefaultAWSCredentialsProviderChain for authorization";
            }
            return "Using given AWS access and secret key for authorization";
        }
        return this.credentialsDescriptor;
    }

    private String getAwsClientSuffix(String region) {
        if (region.equals(Regions.CN_NORTH_1.getName().toString()) || region.equals(Regions.CN_NORTHWEST_1.getName().toString())) {
            return ".amazonaws.com.cn";
        }
        return ".amazonaws.com";
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    public Secret getAwsSecretKey() {
        return this.awsSecretKey;
    }

    public String getAwsSessionToken() {
        return this.awsSessionToken;
    }

    public String getRegion() {
        return this.region;
    }
}

