/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jenkins.ec2fleet;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class EC2FleetLabelParameters {
    private final Map<String, String> parameters;

    public EC2FleetLabelParameters(String label) {
        this.parameters = EC2FleetLabelParameters.parse(label);
    }

    public String get(String name) {
        return this.parameters.get(name.toLowerCase());
    }

    public String getOrDefault(String name, String defaultValue) {
        String value = this.get(name);
        return value == null ? defaultValue : value;
    }

    public int getIntOrDefault(String name, int defaultValue) {
        String value = this.get(name);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    private static Map<String, String> parse(String label) {
        String[] parameters;
        HashMap<String, String> p = new HashMap<String, String>();
        if (label == null) {
            return p;
        }
        for (String parameter : parameters = label.substring(label.indexOf(95) + 1).split(",")) {
            String[] keyValue = parameter.split("=");
            if (keyValue.length != 2) continue;
            p.put(keyValue[0].toLowerCase(), keyValue[1]);
        }
        return p;
    }
}

