/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jenkins.ec2fleet.fleet;

import com.amazon.jenkins.ec2fleet.FleetStateStats;
import com.amazon.jenkins.ec2fleet.Registry;
import com.amazon.jenkins.ec2fleet.fleet.EC2Fleet;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import org.springframework.util.ObjectUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.ActiveInstance;
import software.amazon.awssdk.services.ec2.model.BatchState;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsResponse;
import software.amazon.awssdk.services.ec2.model.FleetType;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.ModifySpotFleetRequestRequest;
import software.amazon.awssdk.services.ec2.model.SpotFleetLaunchSpecification;
import software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfig;
import software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfigData;

@ThreadSafe
public class EC2SpotFleet
implements EC2Fleet {
    @Override
    public void describe(String awsCredentialsId, String regionName, String endpoint, ListBoxModel model, String selectedId, boolean showAll) {
        Ec2Client client = Registry.getEc2Api().connect(awsCredentialsId, regionName, endpoint);
        for (DescribeSpotFleetRequestsResponse result : client.describeSpotFleetRequestsPaginator((DescribeSpotFleetRequestsRequest)DescribeSpotFleetRequestsRequest.builder().build())) {
            for (SpotFleetRequestConfig config : result.spotFleetRequestConfigs()) {
                String curFleetId = config.spotFleetRequestId();
                boolean selected = ObjectUtils.nullSafeEquals((Object)selectedId, (Object)curFleetId);
                if (!selected && !showAll && !EC2SpotFleet.isActiveAndMaintain(config)) continue;
                String displayStr = "EC2 Spot Fleet - " + curFleetId + " (" + String.valueOf(config.spotFleetRequestState()) + ") (" + String.valueOf(config.spotFleetRequestConfig().type()) + ")";
                model.add((Object)new ListBoxModel.Option(displayStr, curFleetId, selected));
            }
        }
    }

    private static boolean isActiveAndMaintain(SpotFleetRequestConfig config) {
        return FleetType.MAINTAIN.toString().equals(String.valueOf(config.spotFleetRequestConfig().type())) && EC2SpotFleet.isActive(config);
    }

    private static boolean isActive(SpotFleetRequestConfig config) {
        return BatchState.ACTIVE.toString().equals(String.valueOf(config.spotFleetRequestState())) || BatchState.MODIFYING.toString().equals(String.valueOf(config.spotFleetRequestState())) || BatchState.SUBMITTED.toString().equals(String.valueOf(config.spotFleetRequestState()));
    }

    private static boolean isModifying(SpotFleetRequestConfig config) {
        return BatchState.SUBMITTED.toString().equals(String.valueOf(config.spotFleetRequestState())) || BatchState.MODIFYING.toString().equals(String.valueOf(config.spotFleetRequestState()));
    }

    @Override
    public void modify(String awsCredentialsId, String regionName, String endpoint, String id, int targetCapacity, int min, int max) {
        ModifySpotFleetRequestRequest request = (ModifySpotFleetRequestRequest)ModifySpotFleetRequestRequest.builder().spotFleetRequestId(id).targetCapacity(Integer.valueOf(targetCapacity)).excessCapacityTerminationPolicy("NoTermination").build();
        Ec2Client ec2 = Registry.getEc2Api().connect(awsCredentialsId, regionName, endpoint);
        ec2.modifySpotFleetRequest(request);
    }

    @Override
    public FleetStateStats getState(String awsCredentialsId, String regionName, String endpoint, String id) {
        DescribeSpotFleetInstancesRequest request;
        DescribeSpotFleetInstancesResponse res;
        Ec2Client ec2 = Registry.getEc2Api().connect(awsCredentialsId, regionName, endpoint);
        String token = null;
        HashSet<String> instances = new HashSet<String>();
        do {
            request = (DescribeSpotFleetInstancesRequest)DescribeSpotFleetInstancesRequest.builder().spotFleetRequestId(id).nextToken(token).build();
            res = ec2.describeSpotFleetInstances(request);
            for (ActiveInstance instance : res.activeInstances()) {
                instances.add(instance.instanceId());
            }
        } while ((token = res.nextToken()) != null);
        request = (DescribeSpotFleetRequestsRequest)DescribeSpotFleetRequestsRequest.builder().spotFleetRequestIds(Collections.singleton(id)).build();
        DescribeSpotFleetRequestsResponse fleet = ec2.describeSpotFleetRequests((DescribeSpotFleetRequestsRequest)request);
        if (fleet.spotFleetRequestConfigs().isEmpty()) {
            throw new IllegalStateException("Fleet " + id + " can't be described");
        }
        SpotFleetRequestConfig fleetConfig = (SpotFleetRequestConfig)fleet.spotFleetRequestConfigs().get(0);
        SpotFleetRequestConfigData fleetRequestConfig = fleetConfig.spotFleetRequestConfig();
        HashMap<String, Double> instanceTypeWeights = new HashMap<String, Double>();
        for (SpotFleetLaunchSpecification launchSpecification : fleetRequestConfig.launchSpecifications()) {
            InstanceType instanceType = launchSpecification.instanceType();
            if (instanceType == null) continue;
            String instanceTypeName = instanceType.toString();
            Double instanceWeight = launchSpecification.weightedCapacity();
            Double existingWeight = (Double)instanceTypeWeights.get(instanceTypeName);
            if (instanceWeight == null || existingWeight != null && existingWeight > instanceWeight) continue;
            instanceTypeWeights.put(instanceTypeName, instanceWeight);
        }
        return new FleetStateStats(id, fleetRequestConfig.targetCapacity(), new FleetStateStats.State(EC2SpotFleet.isActive(fleetConfig), EC2SpotFleet.isModifying(fleetConfig), String.valueOf(fleetConfig.spotFleetRequestState())), instances, instanceTypeWeights);
    }

    @Override
    public Map<String, FleetStateStats> getStateBatch(String awsCredentialsId, String regionName, String endpoint, Collection<String> ids) {
        Ec2Client ec2 = Registry.getEc2Api().connect(awsCredentialsId, regionName, endpoint);
        ArrayList<State> states = new ArrayList<State>();
        for (String id : ids) {
            State s = new State();
            s.id = id;
            states.add(s);
        }
        for (State state : states) {
            DescribeSpotFleetInstancesResponse res;
            Object token = null;
            state.instances = new HashSet<String>();
            do {
                DescribeSpotFleetInstancesRequest request = (DescribeSpotFleetInstancesRequest)DescribeSpotFleetInstancesRequest.builder().spotFleetRequestId(state.id).nextToken(token).build();
                res = ec2.describeSpotFleetInstances(request);
                for (ActiveInstance instance : res.activeInstances()) {
                    state.instances.add(instance.instanceId());
                }
            } while ((token = res.nextToken()) != null);
        }
        DescribeSpotFleetRequestsRequest request = (DescribeSpotFleetRequestsRequest)DescribeSpotFleetRequestsRequest.builder().spotFleetRequestIds(ids).build();
        DescribeSpotFleetRequestsResponse fleet = ec2.describeSpotFleetRequests(request);
        for (SpotFleetRequestConfig c : fleet.spotFleetRequestConfigs()) {
            for (State state : states) {
                if (!state.id.equals(c.spotFleetRequestId())) continue;
                state.config = c;
            }
        }
        HashMap<String, FleetStateStats> r = new HashMap<String, FleetStateStats>();
        for (State state : states) {
            r.put(state.id, new FleetStateStats(state.id, state.config.spotFleetRequestConfig().targetCapacity(), new FleetStateStats.State(EC2SpotFleet.isActive(state.config), EC2SpotFleet.isModifying(state.config), String.valueOf(state.config.spotFleetRequestState())), state.instances, Collections.emptyMap()));
        }
        return r;
    }

    @Override
    public Boolean isAutoScalingGroup() {
        return false;
    }

    private static class State {
        String id;
        Set<String> instances;
        SpotFleetRequestConfig config;

        private State() {
        }
    }
}

