/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jenkins.ec2fleet;

import com.amazon.jenkins.ec2fleet.AbstractEC2FleetCloud;
import com.amazon.jenkins.ec2fleet.EC2AgentTerminationReason;
import com.amazon.jenkins.ec2fleet.EC2FleetNode;
import hudson.model.Slave;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.HttpResponse;

@ThreadSafe
public class EC2FleetNodeComputer
extends SlaveComputer {
    private static final Logger LOGGER = Logger.getLogger(EC2FleetNodeComputer.class.getName());
    private boolean isMarkedForDeletion = false;

    public EC2FleetNodeComputer(EC2FleetNode agent) {
        super((Slave)agent);
    }

    public boolean isMarkedForDeletion() {
        return this.isMarkedForDeletion;
    }

    public EC2FleetNode getNode() {
        return (EC2FleetNode)super.getNode();
    }

    @CheckForNull
    public String getInstanceId() {
        EC2FleetNode node = this.getNode();
        return node == null ? null : node.getInstanceId();
    }

    public AbstractEC2FleetCloud getCloud() {
        EC2FleetNode node = this.getNode();
        return node == null ? null : node.getCloud();
    }

    @Nonnull
    public String getDisplayName() {
        EC2FleetNode node = this.getNode();
        if (node != null) {
            int usesRemaining = node.getUsesRemaining();
            if (usesRemaining >= 0) {
                return String.format("%s Builds left: %d ", node.getDisplayName(), usesRemaining);
            }
            return node.getDisplayName();
        }
        return "unknown fleet " + this.getName();
    }

    public HttpResponse doDoDelete() throws IOException {
        this.checkPermission(DELETE);
        EC2FleetNode node = this.getNode();
        if (node != null) {
            String instanceId = node.getInstanceId();
            AbstractEC2FleetCloud cloud = node.getCloud();
            if (cloud != null && StringUtils.isNotBlank((String)instanceId)) {
                cloud.scheduleToTerminate(instanceId, false, EC2AgentTerminationReason.AGENT_DELETED);
                this.isMarkedForDeletion = true;
            }
        }
        return super.doDoDelete();
    }
}

