/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jenkins.ec2fleet.fleet;

import com.amazon.jenkins.ec2fleet.FleetStateStats;
import com.amazon.jenkins.ec2fleet.Registry;
import com.amazon.jenkins.ec2fleet.fleet.EC2Fleet;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.util.ObjectUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.ActiveInstance;
import software.amazon.awssdk.services.ec2.model.BatchState;
import software.amazon.awssdk.services.ec2.model.DescribeFleetInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFleetInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFleetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFleetsResponse;
import software.amazon.awssdk.services.ec2.model.FleetData;
import software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateConfig;
import software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateOverrides;
import software.amazon.awssdk.services.ec2.model.FleetType;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.ModifyFleetRequest;
import software.amazon.awssdk.services.ec2.model.TargetCapacitySpecificationRequest;

public class EC2EC2Fleet
implements EC2Fleet {
    @Override
    public void describe(String awsCredentialsId, String regionName, String endpoint, ListBoxModel model, String selectedId, boolean showAll) {
        Ec2Client client = Registry.getEc2Api().connect(awsCredentialsId, regionName, endpoint);
        for (DescribeFleetsResponse page : client.describeFleetsPaginator((DescribeFleetsRequest)DescribeFleetsRequest.builder().build())) {
            for (FleetData fleetData : page.fleets()) {
                String curFleetId = fleetData.fleetId();
                boolean selected = ObjectUtils.nullSafeEquals((Object)selectedId, (Object)curFleetId);
                if (!selected && !showAll && !EC2EC2Fleet.isActiveAndMaintain(fleetData)) continue;
                String displayStr = "EC2 Fleet - " + curFleetId + " (" + String.valueOf(fleetData.fleetState()) + ") (" + String.valueOf(fleetData.type()) + ")";
                model.add((Object)new ListBoxModel.Option(displayStr, curFleetId, selected));
            }
        }
    }

    private static boolean isActiveAndMaintain(FleetData fleetData) {
        return FleetType.MAINTAIN.toString().equals(String.valueOf(fleetData.type())) && EC2EC2Fleet.isActive(fleetData);
    }

    private static boolean isActive(FleetData fleetData) {
        return BatchState.ACTIVE.toString().equals(String.valueOf(fleetData.fleetState())) || BatchState.MODIFYING.toString().equals(String.valueOf(fleetData.fleetState())) || BatchState.SUBMITTED.toString().equals(String.valueOf(fleetData.fleetState()));
    }

    private static boolean isModifying(FleetData fleetData) {
        return BatchState.SUBMITTED.toString().equals(String.valueOf(fleetData.fleetState())) || BatchState.MODIFYING.toString().equals(String.valueOf(fleetData.fleetState()));
    }

    @Override
    public void modify(String awsCredentialsId, String regionName, String endpoint, String id, int targetCapacity, int min, int max) {
        ModifyFleetRequest request = (ModifyFleetRequest)ModifyFleetRequest.builder().fleetId(id).targetCapacitySpecification((TargetCapacitySpecificationRequest)TargetCapacitySpecificationRequest.builder().totalTargetCapacity(Integer.valueOf(targetCapacity)).build()).excessCapacityTerminationPolicy("no-termination").build();
        Ec2Client ec2 = Registry.getEc2Api().connect(awsCredentialsId, regionName, endpoint);
        ec2.modifyFleet(request);
    }

    @Override
    public FleetStateStats getState(String awsCredentialsId, String regionName, String endpoint, String id) {
        DescribeFleetsRequest request;
        Ec2Client ec2 = Registry.getEc2Api().connect(awsCredentialsId, regionName, endpoint);
        DescribeFleetsResponse result = ec2.describeFleets(request = (DescribeFleetsRequest)DescribeFleetsRequest.builder().fleetIds(Collections.singleton(id)).build());
        if (result.fleets().isEmpty()) {
            throw new IllegalStateException("Fleet " + id + " doesn't exist");
        }
        FleetData fleetData = (FleetData)result.fleets().get(0);
        List templateConfigs = fleetData.launchTemplateConfigs();
        HashMap<String, Double> instanceTypeWeights = new HashMap<String, Double>();
        for (FleetLaunchTemplateConfig templateConfig : templateConfigs) {
            for (FleetLaunchTemplateOverrides launchOverrides : templateConfig.overrides()) {
                InstanceType instanceType = launchOverrides.instanceType();
                if (instanceType == null) continue;
                String instanceTypeName = instanceType.toString();
                Double instanceWeight = launchOverrides.weightedCapacity();
                Double existingWeight = (Double)instanceTypeWeights.get(instanceTypeName);
                if (instanceWeight == null || existingWeight != null && existingWeight >= instanceWeight) continue;
                instanceTypeWeights.put(instanceTypeName, instanceWeight);
            }
        }
        return new FleetStateStats(id, fleetData.targetCapacitySpecification().totalTargetCapacity(), new FleetStateStats.State(EC2EC2Fleet.isActive(fleetData), EC2EC2Fleet.isModifying(fleetData), String.valueOf(fleetData.fleetState())), this.getActiveFleetInstances(ec2, id), instanceTypeWeights);
    }

    private Set<String> getActiveFleetInstances(Ec2Client ec2, String fleetId) {
        DescribeFleetInstancesResponse result;
        String token = null;
        HashSet<String> instances = new HashSet<String>();
        do {
            DescribeFleetInstancesRequest request = (DescribeFleetInstancesRequest)DescribeFleetInstancesRequest.builder().fleetId(fleetId).nextToken(token).build();
            result = ec2.describeFleetInstances(request);
            for (ActiveInstance instance : result.activeInstances()) {
                instances.add(instance.instanceId());
            }
        } while ((token = result.nextToken()) != null);
        return instances;
    }

    @Override
    public Map<String, FleetStateStats> getStateBatch(String awsCredentialsId, String regionName, String endpoint, Collection<String> ids) {
        Ec2Client ec2 = Registry.getEc2Api().connect(awsCredentialsId, regionName, endpoint);
        ArrayList<State> states = new ArrayList<State>();
        for (String id : ids) {
            State s = new State();
            s.id = id;
            states.add(s);
        }
        for (State state : states) {
            state.instances = this.getActiveFleetInstances(ec2, state.id);
        }
        DescribeFleetsRequest request = (DescribeFleetsRequest)DescribeFleetsRequest.builder().fleetIds(ids).build();
        DescribeFleetsResponse result = ec2.describeFleets(request);
        for (FleetData fleetData : result.fleets()) {
            for (State state : states) {
                if (!state.id.equals(fleetData.fleetId())) continue;
                state.fleetData = fleetData;
            }
        }
        HashMap<String, FleetStateStats> r = new HashMap<String, FleetStateStats>();
        for (State state : states) {
            if (state.fleetData == null) continue;
            r.put(state.id, new FleetStateStats(state.id, state.fleetData.targetCapacitySpecification().totalTargetCapacity(), new FleetStateStats.State(EC2EC2Fleet.isActive(state.fleetData), EC2EC2Fleet.isModifying(state.fleetData), String.valueOf(state.fleetData.fleetState())), state.instances, Collections.emptyMap()));
        }
        return r;
    }

    @Override
    public Boolean isAutoScalingGroup() {
        return false;
    }

    private static class State {
        String id;
        Set<String> instances;
        FleetData fleetData;

        private State() {
        }
    }
}

