/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jenkins.ec2fleet.aws;

import com.amazon.jenkins.ec2fleet.aws.AWSUtils;
import com.cloudbees.jenkins.plugins.awscredentials.AWSCredentialsHelper;
import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import hudson.model.ItemGroup;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.Ec2ClientBuilder;
import software.amazon.awssdk.services.ec2.model.CreateTagsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.ec2.model.Ec2Exception;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.InstanceStateName;
import software.amazon.awssdk.services.ec2.model.Reservation;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TerminateInstancesRequest;

public class EC2Api {
    private static final Logger LOGGER = Logger.getLogger(EC2Api.class.getName());
    private static final Set<String> TERMINATED_STATES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(InstanceStateName.TERMINATED.toString(), InstanceStateName.STOPPED.toString(), InstanceStateName.STOPPING.toString(), InstanceStateName.SHUTTING_DOWN.toString())));
    private static final int BATCH_SIZE = 900;
    private static final String NOT_FOUND_ERROR_CODE = "InvalidInstanceID.NotFound";
    private static final Pattern INSTANCE_ID_PATTERN = Pattern.compile("(i-[0-9a-zA-Z]+)");

    private static List<String> parseInstanceIdsFromNotFoundException(String errorMessage) {
        Matcher fullMessageMatcher = INSTANCE_ID_PATTERN.matcher(errorMessage);
        ArrayList<String> instanceIds = new ArrayList<String>();
        while (fullMessageMatcher.find()) {
            instanceIds.add(fullMessageMatcher.group(1));
        }
        return instanceIds;
    }

    public Map<String, Instance> describeInstances(Ec2Client ec2, Set<String> instanceIds) {
        return this.describeInstances(ec2, instanceIds, 900);
    }

    public Map<String, Instance> describeInstances(Ec2Client ec2, Set<String> instanceIds, int batchSize) {
        HashMap<String, Instance> described = new HashMap<String, Instance>();
        if (instanceIds.isEmpty()) {
            return described;
        }
        ArrayList<String> instanceIdsList = new ArrayList<String>(instanceIds);
        ArrayList batches = new ArrayList();
        for (int i = 0; i < instanceIdsList.size(); i += batchSize) {
            batches.add(instanceIdsList.subList(i, Math.min(i + batchSize, instanceIdsList.size())));
        }
        for (List list : batches) {
            EC2Api.describeInstancesBatch(ec2, described, list);
        }
        return described;
    }

    private static void describeInstancesBatch(Ec2Client ec2, Map<String, Instance> described, List<String> batch) {
        ArrayList<String> copy = new ArrayList<String>(batch);
        Collections.sort(copy);
        while (!copy.isEmpty()) {
            try {
                DescribeInstancesResponse result;
                DescribeInstancesRequest request = (DescribeInstancesRequest)DescribeInstancesRequest.builder().instanceIds(copy).build();
                do {
                    result = ec2.describeInstances(request);
                    request = (DescribeInstancesRequest)request.toBuilder().nextToken(result.nextToken()).build();
                    for (Reservation r : result.reservations()) {
                        for (Instance instance : r.instances()) {
                            if (TERMINATED_STATES.contains(instance.state().name().toString())) continue;
                            described.put(instance.instanceId(), instance);
                        }
                    }
                } while (result.nextToken() != null);
                copy.clear();
            }
            catch (Ec2Exception exception) {
                if (exception.awsErrorDetails().errorCode().equals(NOT_FOUND_ERROR_CODE)) {
                    List<String> notFoundInstanceIds = EC2Api.parseInstanceIdsFromNotFoundException(exception.getMessage());
                    if (notFoundInstanceIds.isEmpty()) {
                        throw exception;
                    }
                    copy.removeAll(notFoundInstanceIds);
                    continue;
                }
                throw exception;
            }
        }
    }

    public void terminateInstances(Ec2Client ec2, Collection<String> instanceIds) {
        ArrayList<String> temp = new ArrayList<String>(instanceIds);
        while (!temp.isEmpty()) {
            try {
                TerminateInstancesRequest request = (TerminateInstancesRequest)TerminateInstancesRequest.builder().instanceIds(temp).build();
                ec2.terminateInstances(request);
                temp.clear();
            }
            catch (Ec2Exception exception) {
                if (exception.awsErrorDetails().errorCode().equals(NOT_FOUND_ERROR_CODE)) {
                    List<String> notFoundInstanceIds = EC2Api.parseInstanceIdsFromNotFoundException(exception.getMessage());
                    if (notFoundInstanceIds.isEmpty()) {
                        throw exception;
                    }
                    temp.removeAll(notFoundInstanceIds);
                    continue;
                }
                LOGGER.warning(String.format("Failed terminating EC2 instanceId(s): %s with following exception: %s", StringUtils.join(instanceIds, (String)","), exception.getMessage()));
                throw exception;
            }
        }
    }

    public void tagInstances(Ec2Client ec2, Set<String> instanceIds, String key, String value) {
        if (instanceIds.isEmpty()) {
            return;
        }
        CreateTagsRequest request = (CreateTagsRequest)CreateTagsRequest.builder().resources(instanceIds).tags(Collections.singletonList((Tag)Tag.builder().key(key).value(value == null ? "" : value).build())).build();
        ec2.createTags(request);
    }

    public Ec2Client connect(String awsCredentialsId, String regionName, String endpoint) {
        ClientOverrideConfiguration clientConfiguration = AWSUtils.getClientConfiguration();
        AmazonWebServicesCredentials credentials = AWSCredentialsHelper.getCredentials((String)awsCredentialsId, (ItemGroup)Jenkins.get());
        Ec2ClientBuilder clientBuilder = credentials != null ? (Ec2ClientBuilder)((Ec2ClientBuilder)Ec2Client.builder().credentialsProvider(AWSUtils.toSdkV2CredentialsProvider(credentials))).overrideConfiguration(clientConfiguration) : (Ec2ClientBuilder)Ec2Client.builder().overrideConfiguration(clientConfiguration);
        String effectiveEndpoint = this.getEndpoint(regionName, endpoint);
        if (effectiveEndpoint != null) {
            clientBuilder.endpointOverride(URI.create(effectiveEndpoint));
        }
        clientBuilder.httpClient((SdkHttpClient)AWSUtils.getApacheHttpClient(endpoint));
        return (Ec2Client)clientBuilder.build();
    }

    @Nullable
    public String getEndpoint(@Nullable String regionName, @Nullable String endpoint) {
        if (StringUtils.isNotEmpty((String)endpoint)) {
            return endpoint;
        }
        if (StringUtils.isNotEmpty((String)regionName)) {
            String domain = regionName.startsWith("cn-") ? "amazonaws.com.cn" : "amazonaws.com";
            return "https://ec2." + regionName + "." + domain;
        }
        return null;
    }
}

