/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jenkins.ec2fleet.aws;

import com.amazon.jenkins.ec2fleet.EC2FleetLabelParameters;
import com.amazon.jenkins.ec2fleet.aws.AWSUtils;
import com.cloudbees.jenkins.plugins.awscredentials.AWSCredentialsHelper;
import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import hudson.model.ItemGroup;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.CloudFormationClientBuilder;
import software.amazon.awssdk.services.cloudformation.model.Capability;
import software.amazon.awssdk.services.cloudformation.model.CreateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse;
import software.amazon.awssdk.services.cloudformation.model.Output;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.Stack;
import software.amazon.awssdk.services.cloudformation.model.StackStatus;
import software.amazon.awssdk.services.cloudformation.model.Tag;

public class CloudFormationApi {
    public CloudFormationClient connect(String awsCredentialsId, String regionName, String endpoint) {
        ClientOverrideConfiguration clientConfiguration = AWSUtils.getClientConfiguration();
        AmazonWebServicesCredentials credentials = AWSCredentialsHelper.getCredentials((String)awsCredentialsId, (ItemGroup)Jenkins.get());
        CloudFormationClientBuilder clientBuilder = credentials != null ? (CloudFormationClientBuilder)((CloudFormationClientBuilder)CloudFormationClient.builder().credentialsProvider(AWSUtils.toSdkV2CredentialsProvider(credentials))).overrideConfiguration(clientConfiguration) : (CloudFormationClientBuilder)CloudFormationClient.builder().overrideConfiguration(clientConfiguration);
        String effectiveEndpoint = this.getEndpoint(regionName, endpoint);
        if (effectiveEndpoint != null) {
            clientBuilder.endpointOverride(URI.create(effectiveEndpoint));
        }
        clientBuilder.httpClient((SdkHttpClient)AWSUtils.getApacheHttpClient(endpoint));
        return (CloudFormationClient)clientBuilder.build();
    }

    @Nullable
    private String getEndpoint(@Nullable String regionName, @Nullable String endpoint) {
        if (StringUtils.isNotEmpty((String)endpoint)) {
            return endpoint;
        }
        if (StringUtils.isNotEmpty((String)regionName)) {
            String domain = regionName.startsWith("cn-") ? "amazonaws.com.cn" : "amazonaws.com";
            return "https://cloudformation." + regionName + "." + domain;
        }
        return null;
    }

    public void delete(CloudFormationClient client, String stackId) {
        client.deleteStack((DeleteStackRequest)DeleteStackRequest.builder().stackName(stackId).build());
    }

    public void create(CloudFormationClient client, String fleetName, String keyName, String parametersString) {
        EC2FleetLabelParameters parameters = new EC2FleetLabelParameters(parametersString);
        try {
            String type = parameters.getOrDefault("type", "ec2-spot-fleet");
            String imageId = parameters.get("imageId");
            int maxSize = parameters.getIntOrDefault("maxSize", 10);
            int minSize = parameters.getIntOrDefault("minSize", 0);
            String instanceType = parameters.getOrDefault("instanceType", "m4.large");
            String spotPrice = parameters.getOrDefault("spotPrice", "");
            String template = "/com/amazon/jenkins/ec2fleet/" + (type.equals("asg") ? "auto-scaling-group.yml" : "ec2-spot-fleet.yml");
            client.createStack((CreateStackRequest)CreateStackRequest.builder().stackName(fleetName + "-" + System.currentTimeMillis()).tags(new Tag[]{(Tag)Tag.builder().key("ec2-fleet-plugin").value(parametersString).build()}).templateBody(IOUtils.toString((InputStream)CloudFormationApi.class.getResourceAsStream(template))).capabilities(new Capability[]{Capability.CAPABILITY_IAM}).parameters(new Parameter[]{(Parameter)Parameter.builder().parameterKey("ImageId").parameterValue(imageId).build(), (Parameter)Parameter.builder().parameterKey("InstanceType").parameterValue(instanceType).build(), (Parameter)Parameter.builder().parameterKey("MaxSize").parameterValue(Integer.toString(maxSize)).build(), (Parameter)Parameter.builder().parameterKey("MinSize").parameterValue(Integer.toString(minSize)).build(), (Parameter)Parameter.builder().parameterKey("SpotPrice").parameterValue(spotPrice).build(), (Parameter)Parameter.builder().parameterKey("KeyName").parameterValue(keyName).build()}).build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, StackInfo> describe(CloudFormationClient client, String fleetName) {
        DescribeStacksResponse describeStacksResult;
        HashMap<String, StackInfo> r = new HashMap<String, StackInfo>();
        String nextToken = null;
        do {
            describeStacksResult = client.describeStacks((DescribeStacksRequest)DescribeStacksRequest.builder().nextToken(nextToken).build());
            for (Stack stack : describeStacksResult.stacks()) {
                if (!stack.stackName().startsWith(fleetName)) continue;
                String fleetId = stack.outputs().isEmpty() ? null : ((Output)stack.outputs().get(0)).outputValue();
                r.put(((Tag)stack.tags().get(0)).value(), new StackInfo(stack.stackId(), fleetId, StackStatus.valueOf((String)String.valueOf(stack.stackStatus()))));
            }
        } while ((nextToken = describeStacksResult.nextToken()) != null);
        return r;
    }

    public static class StackInfo {
        public final String stackId;
        public final String fleetId;
        public final StackStatus stackStatus;

        public StackInfo(String stackId, String fleetId, StackStatus stackStatus) {
            this.stackId = stackId;
            this.fleetId = fleetId;
            this.stackStatus = stackStatus;
        }
    }
}

