/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jenkins.ec2fleet;

public enum EC2AgentTerminationReason {
    IDLE_FOR_TOO_LONG("Agent idle for too long"),
    MAX_TOTAL_USES_EXHAUSTED("MaxTotalUses exhausted for agent"),
    EXCESS_CAPACITY("Excess capacity for fleet"),
    AGENT_DELETED("Agent deleted");

    private final String description;

    private EC2AgentTerminationReason(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public static EC2AgentTerminationReason fromDescription(String desc) {
        for (EC2AgentTerminationReason reason : EC2AgentTerminationReason.values()) {
            if (!reason.description.equalsIgnoreCase(desc)) continue;
            return reason;
        }
        return null;
    }

    public String toString() {
        return this.description;
    }
}

