/*
 * Decompiled with CFR 0.152.
 */
package com.alauda.jenkins.plugins.util;

import com.alauda.jenkins.plugins.Devops;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ClientCommandBuilder
implements Serializable {
    public final String server;
    public final String project;
    public final boolean skipTLSVerify;
    public final String caPath;
    public final String verb;
    public final List advArgs;
    protected final List verbArgs;
    protected final List userArgs;
    protected final List options;
    protected final String token;
    public final int logLevel;

    public ClientCommandBuilder(String server, String project, boolean skipTLSVerify, String caPath, String verb, List advArgs, List verbArgs, List userArgs, List options, String token, int logLevel) {
        if (token != null && (token.contains("\r") || token.contains("\n"))) {
            throw new IllegalArgumentException("tokens cannot contain carriage returns or new lines");
        }
        this.server = server;
        this.project = project;
        this.skipTLSVerify = skipTLSVerify;
        this.caPath = caPath;
        this.verb = verb == null ? "help" : verb;
        this.advArgs = advArgs;
        this.verbArgs = verbArgs;
        this.userArgs = userArgs;
        this.options = options;
        this.token = token;
        this.logLevel = logLevel;
    }

    private static List<String> toStringArray(List l) {
        ArrayList<String> n = new ArrayList<String>();
        if (l == null) {
            return n;
        }
        for (Object o : l) {
            n.add(o.toString());
        }
        return n;
    }

    private boolean hasArg(List<String> args, String ... argsToFind) {
        for (String arg : args) {
            for (String atf : argsToFind) {
                if (!arg.equals(atf) && !arg.startsWith(atf + "=")) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> buildCommand(boolean redacted) {
        ArrayList<String> cmd = new ArrayList<String>();
        String toolName = new Devops.DescriptorImpl().getClientToolName();
        cmd.add(toolName);
        if (this.project != null && !this.hasArg(cmd, "-n", "--namespace")) {
            cmd.add("--namespace=" + this.project);
        }
        cmd.add(this.verb);
        cmd.addAll(ClientCommandBuilder.toStringArray(this.verbArgs));
        cmd.addAll(ClientCommandBuilder.toStringArray(this.userArgs));
        cmd.addAll(ClientCommandBuilder.toStringArray(this.options));
        return cmd;
    }

    public String asString(boolean redacted) {
        StringBuffer sb = new StringBuffer();
        for (String arg : this.buildCommand(redacted)) {
            sb.append(arg);
            sb.append(" ");
        }
        return sb.toString();
    }
}

