/*
 * Decompiled with CFR 0.152.
 */
package com.alauda.jenkins.plugins.freestyle;

import com.alauda.jenkins.plugins.freestyle.BaseStep;
import com.alauda.jenkins.plugins.freestyle.model.ResourceSelector;
import com.google.common.base.Strings;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class WatchStep
extends BaseStep {
    private String template;
    private String successPattern;
    private String failPattern;
    private ResourceSelector selector;

    @DataBoundConstructor
    public WatchStep() {
    }

    @DataBoundSetter
    public void setSelector(ResourceSelector selector) {
        this.selector = selector;
    }

    public ResourceSelector getSelector() {
        return this.selector;
    }

    @DataBoundSetter
    public void setTemplate(String template) {
        this.template = template;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getTemplate(Map<String, String> overrides) {
        return WatchStep.getOverride(this.getTemplate(), overrides);
    }

    public String getSuccessPattern() {
        return this.successPattern;
    }

    public String getSuccessPattern(Map<String, String> overrides) {
        return WatchStep.getOverride(this.getSuccessPattern(), overrides);
    }

    @DataBoundSetter
    public void setSuccessPattern(String successPattern) {
        this.successPattern = successPattern;
    }

    public String getFailPattern() {
        return this.failPattern;
    }

    public String getFailPattern(Map<String, String> overrides) {
        return WatchStep.getOverride(this.getFailPattern(), overrides);
    }

    @DataBoundSetter
    public void setFailPattern(String failPattern) {
        this.failPattern = failPattern;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, final BuildListener listener) throws IOException, InterruptedException {
        final Map<String, String> overrides = this.consolidateEnvVars((TaskListener)listener, build, launcher);
        final AtomicBoolean watchSatisfied = new AtomicBoolean(false);
        final AtomicBoolean watchResult = new AtomicBoolean(false);
        List<String> base = this.selector.asSelectionArgs(overrides);
        base.add("--watch");
        base.add("--template=" + this.getTemplate(overrides));
        base.add("-o=template");
        while (!watchSatisfied.get()) {
            final StringBuffer totalOutput = new StringBuffer();
            this.runOcCommand(build, (TaskListener)listener, "get", base, WatchStep.toList(new String[0]), WatchStep.toList(new String[0]), new BaseStep.OcProcessRunner(){

                @Override
                public boolean perform(ProcessBuilder pb) throws IOException, InterruptedException {
                    pb.redirectErrorStream(true);
                    final Process process = pb.start();
                    final InputStream output = process.getInputStream();
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            block6: {
                                byte[] buffer = new byte[1024];
                                try {
                                    int count;
                                    while ((count = output.read(buffer)) != -1) {
                                        totalOutput.append(new String(buffer, 0, count, StandardCharsets.UTF_8));
                                        if (WatchStep.this.isVerbose()) {
                                            listener.getLogger().write(buffer, 0, count);
                                        }
                                        if (totalOutput.length() > 200000) {
                                            totalOutput.delete(0, 100000);
                                        }
                                        if (totalOutput.indexOf(WatchStep.this.getSuccessPattern(overrides)) > -1) {
                                            watchSatisfied.set(true);
                                            watchResult.set(true);
                                            listener.getLogger().println("Found success pattern: '" + WatchStep.this.getSuccessPattern(overrides) + "' in: \n>>>\n" + totalOutput + "\n<<<");
                                            process.destroy();
                                        }
                                        if (Strings.isNullOrEmpty((String)WatchStep.this.getFailPattern(overrides)) || totalOutput.indexOf(WatchStep.this.getFailPattern(overrides)) <= -1) continue;
                                        watchSatisfied.set(true);
                                        watchResult.set(false);
                                        listener.getLogger().println("Found failure pattern: '" + WatchStep.this.getFailPattern(overrides) + "' in: \n>>>\n" + totalOutput + "\n<<<");
                                        process.destroy();
                                    }
                                }
                                catch (Exception e) {
                                    if (watchSatisfied.get()) break block6;
                                    listener.error("Error streaming process output");
                                    e.printStackTrace(listener.getLogger());
                                }
                            }
                        }
                    }).start();
                    int status = process.waitFor();
                    if (!watchSatisfied.get() && status != 0) {
                        listener.getLogger().println("Client tool watch terminated with error: " + status);
                        listener.getLogger().println(totalOutput);
                        watchSatisfied.set(true);
                        watchResult.set(false);
                    }
                    return true;
                }
            });
        }
        return watchResult.get();
    }

    @Extension
    public static final class DescriptorImpl
    extends BaseStep.BaseStepDescriptor {
        public String getDisplayName() {
            return "Devops - Watch Resource(s)";
        }

        public FormValidation doCheckTemplate(@QueryParameter String template) {
            return FormValidation.validateRequired((String)template);
        }

        public FormValidation doCheckSuccessPattern(@QueryParameter String successPattern) {
            return FormValidation.validateRequired((String)successPattern);
        }
    }
}

