/*
 * Decompiled with CFR 0.152.
 */
package com.alauda.jenkins.plugins.freestyle;

import com.alauda.jenkins.plugins.freestyle.BaseStep;
import com.alauda.jenkins.plugins.freestyle.model.ResourceSelector;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DeleteStep
extends BaseStep {
    private boolean ignoreNotFound;
    private ResourceSelector selector;

    @DataBoundConstructor
    public DeleteStep() {
    }

    @DataBoundSetter
    public void setSelector(ResourceSelector selector) {
        this.selector = selector;
    }

    public ResourceSelector getSelector() {
        return this.selector;
    }

    public boolean isIgnoreNotFound() {
        return this.ignoreNotFound;
    }

    @DataBoundSetter
    public void setIgnoreNotFound(boolean ignoreNotFound) {
        this.ignoreNotFound = ignoreNotFound;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        Map<String, String> overrides = this.consolidateEnvVars((TaskListener)listener, build, null);
        List<String> base = this.selector.asSelectionArgs(overrides);
        if (this.isIgnoreNotFound()) {
            base.add("--ignore-not-found");
        }
        return this.standardRunOcCommand(build, (TaskListener)listener, "delete", base, DeleteStep.toList(new String[0]), DeleteStep.toList(new String[0]));
    }

    @Extension
    public static final class DescriptorImpl
    extends BaseStep.BaseStepDescriptor {
        public String getDisplayName() {
            return "Devops - Delete Resource(s)";
        }
    }
}

