/*
 * Decompiled with CFR 0.152.
 */
package com.alauda.jenkins.plugins.freestyle;

import com.alauda.jenkins.plugins.ClusterConfig;
import com.alauda.jenkins.plugins.Devops;
import com.alauda.jenkins.plugins.DevopsTokenCredentials;
import com.alauda.jenkins.plugins.freestyle.model.AdvancedArgument;
import com.alauda.jenkins.plugins.util.ClientCommandBuilder;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.google.common.base.Strings;
import hudson.EnvVars;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public abstract class BaseStep
extends Builder {
    public static final String DEFAULT_LOGLEVEL = "0";
    public static final String SERVICE_ACCOUNT_NAMESPACE_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/namespace";
    public static final String SERVICE_ACCOUNT_TOKEN_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    public static final String SERVICE_ACCOUNT_CA_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt";
    private String clusterName;
    private String project;
    private String credentialsId;
    private String logLevel = "0";
    private List<AdvancedArgument> advancedArguments;

    @DataBoundSetter
    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getClusterName(Map<String, String> overrides) {
        return BaseStep.getOverride(this.getClusterName(), overrides);
    }

    @DataBoundSetter
    public void setProject(String project) {
        this.project = project;
    }

    public String getProject() {
        return this.project;
    }

    public String getProject(Map<String, String> overrides) {
        return BaseStep.getOverride(this.getProject(), overrides);
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getCredentialsId(Map<String, String> overrides) {
        return BaseStep.getOverride(this.getCredentialsId(), overrides);
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public String getLogLevel(Map<String, String> overrides) {
        return BaseStep.getOverride(this.getLogLevel(), overrides);
    }

    protected boolean isVerbose() {
        if (Strings.isNullOrEmpty((String)this.logLevel)) {
            return false;
        }
        try {
            return Integer.parseInt(this.logLevel) > 0;
        }
        catch (Throwable t) {
            return false;
        }
    }

    @DataBoundSetter
    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public List<AdvancedArgument> getAdvancedArguments() {
        return this.advancedArguments;
    }

    @DataBoundSetter
    public void setAdvancedArguments(List<AdvancedArgument> advancedArguments) {
        this.advancedArguments = advancedArguments;
    }

    protected ClusterConfig getCluster(Map<String, String> overrides) {
        return new Devops.DescriptorImpl().getClusterConfig(this.getClusterName(overrides));
    }

    protected boolean runOcCommand(AbstractBuild build, final TaskListener listener, final String verb, final List verbArgs, final List userArgs, final List options, final OcProcessRunner runner) throws IOException, InterruptedException {
        String token;
        String actualCredentialsId;
        String project;
        String caContent;
        String server;
        final Map<String, String> overrides = this.consolidateEnvVars(listener, build, null);
        ClusterConfig c = this.getCluster(overrides);
        String selectedCAPath = "";
        boolean shouldSkipTLSVerify = false;
        ArrayList<String> advArgs = new ArrayList<String>();
        if (this.advancedArguments != null) {
            for (AdvancedArgument advArg : this.advancedArguments) {
                advArgs.add(advArg.getValue(overrides));
            }
        }
        if (c == null) {
            server = ClusterConfig.getHostClusterApiServerUrl();
            selectedCAPath = SERVICE_ACCOUNT_CA_PATH;
            caContent = null;
        } else {
            server = c.getServerUrl();
            if (c.isSkipTlsVerify()) {
                shouldSkipTLSVerify = true;
                caContent = null;
            } else {
                caContent = c.getServerCertificateAuthority();
            }
        }
        if (Strings.isNullOrEmpty((String)this.getProject(overrides))) {
            if (c != null) {
                project = c.getDefaultProject();
                if (Strings.isNullOrEmpty((String)project)) {
                    throw new IOException("No project defined in step or in cluster: " + this.getClusterName(overrides));
                }
            } else {
                project = new String(Files.readAllBytes(Paths.get(SERVICE_ACCOUNT_NAMESPACE_PATH, new String[0])), StandardCharsets.UTF_8);
            }
        } else {
            project = this.getProject(overrides);
        }
        if (Strings.isNullOrEmpty((String)(actualCredentialsId = this.getCredentialsId(overrides))) && c != null && Strings.isNullOrEmpty((String)(actualCredentialsId = c.getCredentialsId()))) {
            throw new IOException("No credentials defined in step or in cluster: " + this.getClusterName(overrides));
        }
        if (!Strings.isNullOrEmpty((String)actualCredentialsId)) {
            DevopsTokenCredentials tokenSecret = (DevopsTokenCredentials)CredentialsProvider.findCredentialById((String)actualCredentialsId, DevopsTokenCredentials.class, (Run)build, new ArrayList());
            if (tokenSecret == null) {
                throw new IOException("Unable to find credential in Jenkins credential store: " + actualCredentialsId);
            }
            token = tokenSecret.getToken();
        } else {
            token = new String(Files.readAllBytes(Paths.get(SERVICE_ACCOUNT_TOKEN_PATH, new String[0])), StandardCharsets.UTF_8);
        }
        final String finalSelectedCAPath = selectedCAPath;
        final boolean finalShouldSkipTLSVerify = shouldSkipTLSVerify;
        final ArrayList<String> finalAdvArgs = advArgs;
        return BaseStep.withTempInput("serviceca", caContent, new WithTempInputRunnable(){

            @Override
            public boolean perform(String filename) throws IOException, InterruptedException {
                if (filename == null) {
                    filename = finalSelectedCAPath;
                }
                ClientCommandBuilder cmdBuilder = new ClientCommandBuilder(server, project, finalShouldSkipTLSVerify, filename, verb, finalAdvArgs, verbArgs, userArgs, options, token, Integer.parseInt(BaseStep.this.getLogLevel(overrides)));
                ProcessBuilder pb = new ProcessBuilder(new String[0]);
                pb.command(cmdBuilder.buildCommand(false));
                listener.getLogger().println("Executing: " + cmdBuilder.asString(true));
                return runner.perform(pb);
            }
        });
    }

    protected boolean standardRunOcCommand(AbstractBuild build, final TaskListener listener, String verb, List verbArgs, List userArgs, List options) throws IOException, InterruptedException {
        return this.runOcCommand(build, listener, verb, verbArgs, userArgs, options, new OcProcessRunner(){

            @Override
            public boolean perform(ProcessBuilder pb) throws IOException, InterruptedException {
                pb.redirectErrorStream(true);
                Process process = pb.start();
                final InputStream output = process.getInputStream();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        byte[] buffer = new byte[1024];
                        try {
                            int count;
                            while ((count = output.read(buffer)) != -1) {
                                listener.getLogger().write(buffer, 0, count);
                            }
                        }
                        catch (Exception e) {
                            listener.error("Error streaming process output");
                            e.printStackTrace(listener.getLogger());
                        }
                    }
                }).start();
                int status = process.waitFor();
                if (status != 0) {
                    listener.getLogger().println("Client tool terminated with status: " + status);
                    return false;
                }
                return true;
            }
        });
    }

    protected Map<String, String> consolidateEnvVars(TaskListener listener, AbstractBuild<?, ?> build, Launcher launcher) {
        TreeMap<String, String> overrides;
        block13: {
            block12: {
                overrides = new TreeMap<String, String>();
                if (build != null) {
                    try {
                        EnvVars buildEnv = build.getEnvironment(listener);
                        if (this.isVerbose()) {
                            listener.getLogger().println("build env vars:  " + buildEnv);
                        }
                        overrides.putAll((Map<String, String>)buildEnv);
                    }
                    catch (IOException | InterruptedException e) {
                        if (!this.isVerbose()) break block12;
                        e.printStackTrace(listener.getLogger());
                    }
                }
            }
            try {
                EnvVars computerEnv = null;
                Computer computer = Computer.currentComputer();
                if (computer != null) {
                    computerEnv = computer.getEnvironment();
                } else {
                    if (launcher != null) {
                        computer = launcher.getComputer();
                    }
                    if (computer != null) {
                        computerEnv = computer.getEnvironment();
                    }
                }
                if (this.isVerbose()) {
                    listener.getLogger().println("computer env vars:  " + computerEnv);
                }
                if (computerEnv != null) {
                    overrides.putAll((Map<String, String>)computerEnv);
                }
            }
            catch (IOException | InterruptedException e2) {
                if (!this.isVerbose()) break block13;
                e2.printStackTrace(listener.getLogger());
            }
        }
        return overrides;
    }

    public static String pruneKey(String key) {
        if (key == null) {
            key = "";
        }
        if (key.startsWith("$")) {
            return key.substring(1, key.length()).trim();
        }
        return key.trim();
    }

    public static String getOverride(String key, Map<String, String> overrides) {
        String val = BaseStep.pruneKey(key);
        if (overrides != null && overrides.containsKey(val)) {
            val = overrides.get(val);
        } else {
            String tmp = Util.replaceMacro((String)key, overrides);
            if (tmp != null && tmp.length() > 0) {
                val = tmp;
            }
        }
        return val;
    }

    protected static ArrayList<String> toList(String ... entries) {
        ArrayList<String> list = new ArrayList<String>(entries.length);
        for (String s : entries) {
            list.add(s);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean withTempInput(String prefix, String content, WithTempInputRunnable runnable) throws IOException, InterruptedException {
        boolean bl;
        block4: {
            Path tmp = null;
            try {
                if (content != null) {
                    tmp = Files.createTempFile(prefix, ".tmp", new FileAttribute[0]);
                    ArrayList<String> list = new ArrayList<String>(1);
                    list.add(content);
                    Files.write(tmp, list, StandardCharsets.UTF_8, StandardOpenOption.WRITE);
                }
                bl = runnable.perform(tmp == null ? null : tmp.toAbsolutePath().toString());
                if (tmp == null) break block4;
            }
            catch (Throwable throwable) {
                if (tmp != null) {
                    Files.delete(tmp);
                }
                throw throwable;
            }
            Files.delete(tmp);
        }
        return bl;
    }

    protected static interface OcProcessRunner {
        public boolean perform(ProcessBuilder var1) throws IOException, InterruptedException;
    }

    protected static interface WithTempInputRunnable {
        public boolean perform(String var1) throws IOException, InterruptedException;
    }

    public static abstract class BaseStepDescriptor
    extends BuildStepDescriptor<Builder> {
        BaseStepDescriptor() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public ListBoxModel doFillClusterNameItems() {
            ListBoxModel items = new ListBoxModel();
            List<ClusterConfig> clusters = new Devops.DescriptorImpl().getClusterConfigs();
            for (ClusterConfig c : clusters) {
                items.add(c.getName(), c.getName());
            }
            items.add("<Cluster Running Jenkins Node>", "");
            return items;
        }

        public ListBoxModel doFillCredentialsIdItems(@QueryParameter String credentialsId) {
            return ClusterConfig.doFillCredentialsIdItems(credentialsId);
        }

        public ListBoxModel doFillLogLevelItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("0 - Minimum Logging", BaseStep.DEFAULT_LOGLEVEL);
            for (int i = 1; i < 10; ++i) {
                items.add("" + i, "" + i);
            }
            items.add("10 - Maximum Logging", "10");
            return items;
        }
    }
}

