/*
 * Decompiled with CFR 0.152.
 */
package com.alauda.jenkins.plugins;

import com.alauda.jenkins.plugins.ClusterConfig;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

public class Devops
extends AbstractDescribableImpl<Devops> {
    public static final String DEFAULT_LOGLEVEL = "0";

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Devops> {
        public Long configVersion = 1L;
        public List<ClusterConfig> clusterConfigs;
        public String tool = "kubectl";

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Devops Configuration";
        }

        public String getClientToolName() {
            return this.tool;
        }

        public void removeClusterConfig(ClusterConfig clusterConfig) throws IllegalArgumentException {
            if (this.clusterConfigs == null || this.clusterConfigs.size() <= 0) {
                throw new IllegalArgumentException("ClusterConfigs is null or empty");
            }
            this.clusterConfigs.remove(clusterConfig);
        }

        public void addClusterConfig(ClusterConfig clusterConfig) {
            if (this.clusterConfigs == null) {
                this.clusterConfigs = new ArrayList<ClusterConfig>(1);
            }
            this.clusterConfigs.add(clusterConfig);
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.clusterConfigs = null;
            req.bindJSON((Object)this, json.getJSONObject("alaudaDevops"));
            this.save();
            return true;
        }

        public ListBoxModel doFillLogLevelItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("0 - Least Logging", Devops.DEFAULT_LOGLEVEL);
            for (int i = 1; i < 10; ++i) {
                items.add("" + i, "" + i);
            }
            items.add("10 - Most Logging", "10");
            return items;
        }

        public List<ClusterConfig> getClusterConfigs() {
            if (this.clusterConfigs == null) {
                return new ArrayList<ClusterConfig>(0);
            }
            return Collections.unmodifiableList(this.clusterConfigs);
        }

        public ClusterConfig getClusterConfig(String name) {
            if (this.clusterConfigs == null) {
                return null;
            }
            name = Util.fixEmptyAndTrim((String)name);
            for (ClusterConfig cc : this.clusterConfigs) {
                if (!cc.getName().equalsIgnoreCase(name)) continue;
                return cc;
            }
            return null;
        }
    }
}

