/*
 * Decompiled with CFR 0.152.
 */
package com.alauda.jenkins.plugins;

import com.alauda.jenkins.plugins.DevopsTokenCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ClusterConfig
extends AbstractDescribableImpl<ClusterConfig>
implements Serializable {
    private String name;
    private String serverUrl;
    private String serverCertificateAuthority;
    private boolean skipTlsVerify;
    private String defaultProject;
    private String credentialsId;

    @DataBoundConstructor
    public ClusterConfig(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    @DataBoundSetter
    public void setServerUrl(String serverUrl) {
        this.serverUrl = Util.fixEmptyAndTrim((String)serverUrl);
    }

    public String getServerCertificateAuthority() {
        return this.serverCertificateAuthority;
    }

    @DataBoundSetter
    public void setServerCertificateAuthority(String serverCertificateAuthority) {
        this.serverCertificateAuthority = Util.fixEmptyAndTrim((String)serverCertificateAuthority);
    }

    public boolean isSkipTlsVerify() {
        return this.skipTlsVerify;
    }

    @DataBoundSetter
    public void setSkipTlsVerify(boolean skipTLSVerify) {
        this.skipTlsVerify = skipTLSVerify;
    }

    public String getDefaultProject() {
        return this.defaultProject;
    }

    @DataBoundSetter
    public void setDefaultProject(String defaultProject) {
        this.defaultProject = Util.fixEmptyAndTrim((String)defaultProject);
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = Util.fixEmptyAndTrim((String)credentialsId);
    }

    public String toString() {
        return String.format("Devops cluster [name:%s] [serverUrl:%s]", this.name, this.serverUrl);
    }

    @Whitelisted
    public static String getHostClusterApiServerUrl() {
        String serviceHost = System.getenv("KUBERNETES_SERVICE_HOST");
        if (serviceHost == null) {
            throw new IllegalStateException("No clusterName information specified and unable to find `KUBERNETES_SERVICE_HOST` environment variable.");
        }
        String servicePort = System.getenv("KUBERNETES_SERVICE_PORT_HTTPS");
        if (servicePort == null) {
            throw new IllegalStateException("No clusterName information specified and unable to find `KUBERNETES_SERVICE_PORT_HTTPS` environment variable.");
        }
        return "https://" + serviceHost + ":" + servicePort;
    }

    public static ListBoxModel doFillCredentialsIdItems(String credentialsId) {
        if (credentialsId == null) {
            credentialsId = "";
        }
        if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
            return new StandardListBoxModel().includeCurrentValue(credentialsId);
        }
        return new StandardListBoxModel().includeEmptyValue().includeAs(ACL.SYSTEM, (ItemGroup)Jenkins.getInstance(), DevopsTokenCredentials.class).includeCurrentValue(credentialsId);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ClusterConfig> {
        public String getDisplayName() {
            return "Devops Cluster";
        }

        public FormValidation doCheckName(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckServerUrl(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }

        public ListBoxModel doFillCredentialsIdItems(@QueryParameter String credentialsId) {
            return ClusterConfig.doFillCredentialsIdItems(credentialsId);
        }
    }
}

