/*
 * Decompiled with CFR 0.152.
 */
package au.com.versent.jenkins.plugins.ignoreCommitterStrategy;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.plugins.git.GitChangeLogParser;
import hudson.plugins.git.GitChangeSet;
import hudson.scm.SCM;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import jenkins.branch.BranchBuildStrategy;
import jenkins.branch.BranchBuildStrategyDescriptor;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitSCMFileSystem;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import org.kohsuke.stapler.DataBoundConstructor;

public class IgnoreCommitterStrategy
extends BranchBuildStrategy {
    private final String ignoredAuthors;
    private final Boolean allowBuildIfNotExcludedAuthor;

    @DataBoundConstructor
    public IgnoreCommitterStrategy(String ignoredAuthors, Boolean allowBuildIfNotExcludedAuthor) {
        this.ignoredAuthors = ignoredAuthors;
        this.allowBuildIfNotExcludedAuthor = allowBuildIfNotExcludedAuthor;
    }

    public String getIgnoredAuthors() {
        return this.ignoredAuthors;
    }

    public Boolean getAllowBuildIfNotExcludedAuthor() {
        return this.allowBuildIfNotExcludedAuthor;
    }

    public boolean isAutomaticBuild(@NonNull SCMSource source, @NonNull SCMHead head, @NonNull SCMRevision currRevision, @CheckForNull SCMRevision lastBuiltRevision, @CheckForNull SCMRevision lastSeenRevision, @NonNull TaskListener listener) {
        GitSCMFileSystem.BuilderImpl builder = new GitSCMFileSystem.BuilderImpl();
        try {
            SCM scm = source.build(head, currRevision);
            SCMSourceOwner owner = source.getOwner();
            if (owner == null) {
                listener.error("Error retrieving SCMSourceOwner");
                return true;
            }
            SCMFileSystem fileSystem = !(currRevision instanceof AbstractGitSCMSource.SCMRevisionImpl) ? builder.build(source, head, (SCMRevision)new AbstractGitSCMSource.SCMRevisionImpl(head, currRevision.toString().substring(0, 40))) : builder.build((Item)owner, scm, currRevision);
            if (fileSystem == null) {
                listener.error("Error retrieving SCMFileSystem");
                return true;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (lastBuiltRevision != null && !(lastBuiltRevision instanceof AbstractGitSCMSource.SCMRevisionImpl)) {
                fileSystem.changesSince((SCMRevision)new AbstractGitSCMSource.SCMRevisionImpl(head, lastBuiltRevision.toString().substring(0, 40)), (OutputStream)out);
            } else {
                fileSystem.changesSince(lastBuiltRevision, (OutputStream)out);
            }
            GitChangeLogParser parser = new GitChangeLogParser(true);
            List logs = parser.parse((InputStream)new ByteArrayInputStream(out.toByteArray()));
            List ignoredAuthorsList = Arrays.stream(this.ignoredAuthors.split(",")).map(e -> e.trim().toLowerCase()).collect(Collectors.toList());
            listener.getLogger().printf("Ignored authors: %s%n", ignoredAuthorsList.toString());
            for (GitChangeSet log : logs) {
                String authorEmail = log.getAuthorEmail().trim().toLowerCase();
                Boolean isIgnoredAuthor = ignoredAuthorsList.contains(authorEmail);
                if (isIgnoredAuthor.booleanValue()) {
                    if (this.allowBuildIfNotExcludedAuthor.booleanValue()) continue;
                    listener.getLogger().printf("Changeset contains ignored author %s (%s), and allowBuildIfNotExcludedAuthor is %s, therefore build is not required%n", authorEmail, log.getCommitId(), this.allowBuildIfNotExcludedAuthor);
                    return false;
                }
                if (!this.allowBuildIfNotExcludedAuthor.booleanValue()) continue;
                listener.getLogger().printf("Changeset contains non ignored author %s (%s) and allowIfNotExcluded is %s, build is required%n", authorEmail, log.getCommitId(), this.allowBuildIfNotExcludedAuthor);
                return true;
            }
            listener.getLogger().printf("All commits in the changeset are made by %s authors, build is %s%n", this.allowBuildIfNotExcludedAuthor != false ? "excluded" : "non-excluded", this.allowBuildIfNotExcludedAuthor == false);
            return this.allowBuildIfNotExcludedAuthor == false;
        }
        catch (Exception e2) {
            listener.error("Exception: %s%n", new Object[]{e2});
            return true;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BranchBuildStrategyDescriptor {
        public String getDisplayName() {
            return "Ignore Committer Strategy";
        }
    }
}

