/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.jenkins.utils;

import hudson.model.Result;
import java.util.Map;

public class BuildSummary {
    private Map<String, Integer> statistics;

    public BuildSummary withStatistics(Map<String, Integer> statistics) {
        this.statistics = statistics;
        return this;
    }

    private Integer getStatistic(String key) {
        return this.statistics != null ? this.statistics.get(key) : 0;
    }

    public long getFailedCount() {
        return this.getStatistic("failed").intValue();
    }

    public long getPassedCount() {
        return this.getStatistic("passed").intValue();
    }

    public long getSkipCount() {
        return this.getStatistic("skipped").intValue();
    }

    public long getBrokenCount() {
        return this.getStatistic("broken").intValue();
    }

    public long getUnknownCount() {
        return this.getStatistic("unknown").intValue();
    }

    public Result getResult() {
        if (this.getFailedCount() > 0L || this.getBrokenCount() > 0L) {
            return Result.UNSTABLE;
        }
        return Result.SUCCESS;
    }
}

