/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.jenkins;

import hudson.model.Job;
import hudson.model.ProminentProjectAction;
import hudson.model.Run;
import org.kohsuke.stapler.StaplerProxy;
import ru.yandex.qatools.allure.jenkins.AllureReportBuildAction;
import ru.yandex.qatools.allure.jenkins.AllureReportPlugin;
import ru.yandex.qatools.allure.jenkins.Messages;

public class AllureReportProjectAction
implements ProminentProjectAction,
StaplerProxy {
    private final Job<?, ?> job;

    public AllureReportProjectAction(Job<?, ?> job) {
        this.job = job;
    }

    public String getDisplayName() {
        return Messages.AllureReportPlugin_Title();
    }

    public String getIconFileName() {
        return AllureReportPlugin.getIconFilename();
    }

    public String getUrlName() {
        return "allure";
    }

    public Object getTarget() {
        Run last = this.job.getLastCompletedBuild();
        return last == null ? null : last.getAction(AllureReportBuildAction.class);
    }

    public boolean isCanBuildGraph() {
        int dataPointsCount = 0;
        AllureReportBuildAction allureBuildAction = this.getLastAllureBuildAction();
        while (dataPointsCount < 2) {
            if (allureBuildAction == null) {
                return false;
            }
            if (allureBuildAction.hasSummaryLink()) {
                ++dataPointsCount;
            }
            allureBuildAction = allureBuildAction.getPreviousResult();
        }
        return true;
    }

    public AllureReportBuildAction getLastAllureBuildAction() {
        Run tb = this.job.getLastSuccessfulBuild();
        for (Run b = this.job.getLastBuild(); b != null; b = b.getPreviousBuild()) {
            AllureReportBuildAction a = (AllureReportBuildAction)b.getAction(AllureReportBuildAction.class);
            if (a != null && !b.isBuilding()) {
                return a;
            }
            if (!b.equals(tb)) continue;
            return null;
        }
        return null;
    }
}

