/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.jenkins;

import hudson.FilePath;
import hudson.Plugin;
import hudson.PluginWrapper;
import hudson.model.AbstractBuild;
import java.io.File;
import jenkins.model.Jenkins;
import ru.yandex.qatools.allure.jenkins.Messages;

public class AllureReportPlugin
extends Plugin {
    public static final String URL_PATH = "allure";
    public static final String REPORT_PATH = "allure-report";
    public static final String DEFAULT_RESULTS_PATTERN = "allure-results";
    public static final String DEFAULT_URL_PATTERN = "%s";
    public static final String DEFAULT_ISSUE_TRACKER_PATTERN = "%s";
    public static final String DEFAULT_TMS_PATTERN = "%s";

    public static FilePath getMasterReportFilePath(AbstractBuild<?, ?> build) {
        File file = AllureReportPlugin.getReportBuildDirectory(build);
        return file == null ? null : new FilePath(file);
    }

    public static File getReportBuildDirectory(AbstractBuild<?, ?> build) {
        return build == null ? null : new File(build.getRootDir(), REPORT_PATH);
    }

    public static String getTitle() {
        return Messages.AllureReportPlugin_Title();
    }

    public static String getIconFilename() {
        PluginWrapper wrapper = Jenkins.get().getPluginManager().getPlugin(AllureReportPlugin.class);
        return wrapper == null ? "" : String.format("/plugin/%s/img/icon.png", wrapper.getShortName());
    }
}

