/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jsp;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import org.kohsuke.stapler.Dispatcher;
import org.kohsuke.stapler.Facet;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.RequestImpl;
import org.kohsuke.stapler.ResponseImpl;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.jsp.RequestDispatcherWrapper;
import org.kohsuke.stapler.lang.Klass;

public class JSPFacet
extends Facet {
    public void buildViewDispatchers(MetaClass owner, List<Dispatcher> dispatchers) {
        dispatchers.add(new Dispatcher(){

            public boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException {
                String next = req.tokens.peek();
                if (next == null) {
                    return false;
                }
                if (req.tokens.countRemainingTokens() > 1) {
                    return false;
                }
                if (req.getRequestURI().endsWith("/")) {
                    return false;
                }
                Stapler stapler = req.getStapler();
                if (!JSPFacet.this.isBasename(next)) {
                    return false;
                }
                RequestDispatcher disp = JSPFacet.this.createRequestDispatcher(req, node.getClass(), node, next);
                if (disp == null && (disp = JSPFacet.this.createRequestDispatcher(req, node.getClass(), node, next + ".jsp")) == null) {
                    return false;
                }
                req.tokens.next();
                if (1.traceable()) {
                    1.trace((StaplerRequest2)req, (StaplerResponse2)rsp, (String)("Invoking " + next + ".jsp on " + String.valueOf(node) + " for " + String.valueOf(req.tokens)));
                }
                stapler.forward(disp, (StaplerRequest2)req, (HttpServletResponse)rsp);
                return true;
            }

            public String toString() {
                return "TOKEN.jsp for url=/TOKEN/...";
            }
        });
    }

    public RequestDispatcher createRequestDispatcher(RequestImpl request, Klass type, Object it, String viewName) throws IOException {
        ServletContext context = request.stapler.getServletContext();
        for (Class c = type.toJavaClass(); c != Object.class; c = c.getSuperclass()) {
            RequestDispatcher disp;
            String name = "/WEB-INF/side-files/" + c.getName().replace('.', '/').replace('$', '/') + "/" + viewName;
            if (context.getResource(name) == null || (disp = context.getRequestDispatcher(name)) == null) continue;
            return new RequestDispatcherWrapper(disp, it);
        }
        return null;
    }

    public boolean handleIndexRequest(RequestImpl req, ResponseImpl rsp, Object node, MetaClass nodeMetaClass) throws IOException, ServletException {
        Stapler stapler = req.stapler;
        RequestDispatcher indexJsp = this.createRequestDispatcher(req, node.getClass(), node, "index.jsp");
        if (indexJsp != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Invoking index.jsp on " + String.valueOf(node));
            }
            stapler.forward(indexJsp, (StaplerRequest2)req, (HttpServletResponse)rsp);
            return true;
        }
        return false;
    }
}

