/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im.tools;

public final class Pair<H, T> {
    private final H head;
    private final T tail;

    public Pair(H head, T tail) {
        this.head = head;
        this.tail = tail;
    }

    public static <H2, T2> Pair<H2, T2> create(H2 head, T2 tail) {
        return new Pair<H2, T2>(head, tail);
    }

    public H getHead() {
        return this.head;
    }

    public T getTail() {
        return this.tail;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other != null && other.getClass() == this.getClass()) {
            return this.compareContents((Pair)other);
        }
        return false;
    }

    private boolean compareContents(Pair<?, ?> other) {
        if (this.head == null ? other.head != null : !this.head.equals(other.head)) {
            return false;
        }
        return !(this.tail == null ? other.tail != null : !this.tail.equals(other.tail));
    }

    public int hashCode() {
        return (this.head == null ? 0 : this.head.hashCode()) + (this.tail == null ? 0 : this.tail.hashCode());
    }
}

