/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.favorite.user;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Item;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.plugins.favorite.Messages;
import hudson.plugins.favorite.user.FavoriteUserProperty;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class FavoriteUserPropertyDescriptor
extends UserPropertyDescriptor {
    public FavoriteUserPropertyDescriptor() {
        super(FavoriteUserProperty.class);
    }

    public UserProperty newInstance(User user) {
        return new FavoriteUserProperty();
    }

    public boolean isEnabled() {
        return false;
    }

    @NonNull
    public String getDisplayName() {
        return Messages.favoriteUserPropertyDescriptor();
    }

    @Deprecated(forRemoval=true)
    public String toItemUrl(String fullName) {
        if (fullName == null || fullName.isEmpty()) {
            return null;
        }
        Jenkins jenkins = Jenkins.get();
        Item item = jenkins.getItemByFullName(fullName);
        if (item == null) {
            return null;
        }
        return jenkins.getRootUrl() + item.getUrl();
    }

    @Restricted(value={NoExternalUse.class})
    public String toItemUrl(Item item) {
        Jenkins jenkins = Jenkins.get();
        return jenkins.getRootUrl() + item.getUrl();
    }
}

