/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.favorite.listener;

import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Item;
import hudson.model.User;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class FavoriteListener
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(FavoriteListener.class.getName());

    public static Iterable<FavoriteListener> all() {
        return ExtensionList.lookup(FavoriteListener.class);
    }

    public static void fireOnAddFavourite(Item item, User user) {
        for (FavoriteListener listener : FavoriteListener.all()) {
            try {
                listener.onAddFavourite(item, user);
            }
            catch (Throwable e) {
                LOGGER.log(Level.WARNING, "There was a problem firing listener " + listener.getClass().getName(), e);
            }
        }
    }

    public static void fireOnRemoveFavourite(Item item, User user) {
        for (FavoriteListener listener : FavoriteListener.all()) {
            try {
                listener.onRemoveFavourite(item, user);
            }
            catch (Throwable e) {
                LOGGER.log(Level.WARNING, "There was a problem firing listener " + listener.getClass().getName(), e);
            }
        }
    }

    public static void fireOnLocationChangedFavorite(Item item, User user, String oldName, String newName) {
        for (FavoriteListener listener : FavoriteListener.all()) {
            try {
                listener.onLocationChangedFavorite(item, user, oldName, newName);
            }
            catch (Throwable e) {
                LOGGER.log(Level.WARNING, "There was a problem firing listener " + listener.getClass().getName(), e);
            }
        }
    }

    public abstract void onAddFavourite(Item var1, User var2);

    public abstract void onRemoveFavourite(Item var1, User var2);

    public void onLocationChangedFavorite(Item item, User user, String oldName, String newName) {
    }
}

