/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.octoperf.result;

import java.io.IOException;
import org.jenkinsci.plugins.octoperf.client.RestApiFactory;
import org.jenkinsci.plugins.octoperf.result.BenchResult;
import org.jenkinsci.plugins.octoperf.result.BenchResultApi;
import org.jenkinsci.plugins.octoperf.result.BenchResultService;
import org.jenkinsci.plugins.octoperf.result.BenchResultState;
import org.jenkinsci.plugins.octoperf.result.ValueWrapper;

final class RestBenchResultService
implements BenchResultService {
    RestBenchResultService() {
    }

    @Override
    public BenchResultState getState(RestApiFactory apiFactory, String benchResultId) throws IOException {
        BenchResult result = this.find(apiFactory, benchResultId);
        return result.getState();
    }

    @Override
    public BenchResult find(RestApiFactory apiFactory, String benchResultId) throws IOException {
        BenchResultApi api = apiFactory.create(BenchResultApi.class);
        return (BenchResult)api.find(benchResultId).execute().body();
    }

    @Override
    public Double getProgress(RestApiFactory apiFactory, String benchResultId) throws IOException {
        BenchResultApi api = apiFactory.create(BenchResultApi.class);
        return (Double)((ValueWrapper)api.getProgress(benchResultId).execute().body()).getValue();
    }

    @Override
    public boolean isFinished(BenchResult benchResult) {
        BenchResultState state = benchResult.getState();
        return state.isTerminalState();
    }

    @Override
    public void stopTest(RestApiFactory apiFactory, String benchResultId) throws IOException {
        BenchResultApi api = apiFactory.create(BenchResultApi.class);
        api.stopTest(benchResultId).execute();
    }
}

