/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.octoperf.junit;

import com.google.common.io.Closer;
import hudson.FilePath;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import okhttp3.ResponseBody;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.octoperf.client.RestApiFactory;
import org.jenkinsci.plugins.octoperf.junit.JUnitReportApi;
import org.jenkinsci.plugins.octoperf.junit.JUnitReportService;
import retrofit2.Call;

final class RestJUnitReportService
implements JUnitReportService {
    private static final String JUNIT_REPORT_XML = "junit-report.xml";

    RestJUnitReportService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilePath saveJUnitReport(FilePath workspace, RestApiFactory apiFactory, String benchResultId) throws IOException, InterruptedException {
        FilePath path = new FilePath(workspace, JUNIT_REPORT_XML);
        JUnitReportApi api = apiFactory.create(JUnitReportApi.class);
        Call<ResponseBody> report = api.getReport(benchResultId);
        ResponseBody body = (ResponseBody)report.execute().body();
        try (Closer closer = Closer.create();){
            InputStream input = (InputStream)closer.register((Closeable)body.byteStream());
            OutputStream output = (OutputStream)closer.register((Closeable)path.write());
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
        return path;
    }
}

