/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.octoperf.conditions;

import hudson.Extension;
import hudson.model.Result;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Optional;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.octoperf.client.RestApiFactory;
import org.jenkinsci.plugins.octoperf.conditions.StopConditionDescriptor;
import org.jenkinsci.plugins.octoperf.conditions.TestStopCondition;
import org.jenkinsci.plugins.octoperf.result.BenchResultService;
import org.jenkinsci.plugins.octoperf.threshold.ThresholdAlarmService;
import org.jenkinsci.plugins.octoperf.threshold.ThresholdSeverity;
import org.kohsuke.stapler.DataBoundConstructor;

@Extension
public class StopOnAlert
extends TestStopCondition {
    private ThresholdSeverity severity = ThresholdSeverity.WARNING;
    private Result buildResult = Result.ABORTED;

    public StopOnAlert() {
    }

    @DataBoundConstructor
    public StopOnAlert(ThresholdSeverity severity, Result buildResult) {
        this.severity = Optional.ofNullable(severity).orElse(ThresholdSeverity.WARNING);
        this.buildResult = Optional.ofNullable(buildResult).orElse(Result.UNSTABLE);
    }

    @Override
    public Result execute(PrintStream logger, RestApiFactory factory, String benchResultId) throws IOException {
        if (ThresholdAlarmService.THRESHOLD_ALARMS.hasAlarms(factory, benchResultId, this.severity)) {
            logger.println("An '" + String.valueOf((Object)this.severity) + "' Alarm has been raised, Stopping the test!");
            BenchResultService.BENCH_RESULTS.stopTest(factory, benchResultId);
            return this.buildResult;
        }
        return Result.SUCCESS;
    }

    public ThresholdSeverity getSeverity() {
        return this.severity;
    }

    public Result getBuildResult() {
        return this.buildResult;
    }

    public void setSeverity(ThresholdSeverity severity) {
        this.severity = severity;
    }

    public void setBuildResult(Result buildResult) {
        this.buildResult = buildResult;
    }

    @Symbol(value={"stopOnAlert"})
    @Extension
    public static class DescriptorImpl
    extends StopConditionDescriptor {
        public String getDisplayName() {
            return "Stop On Alert";
        }

        public ListBoxModel doFillSeverityItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Warning", ThresholdSeverity.WARNING.toString());
            items.add("Critical", ThresholdSeverity.CRITICAL.toString());
            return items;
        }

        public ListBoxModel doFillBuildResultItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Unstable", Result.UNSTABLE.toString());
            items.add("Failure", Result.FAILURE.toString());
            items.add("Aborted", Result.ABORTED.toString());
            return items;
        }
    }
}

