/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.octoperf.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.google.common.base.Strings;
import hudson.ProxyConfiguration;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import jenkins.model.Jenkins;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jenkinsci.plugins.octoperf.account.AccountApi;
import org.jenkinsci.plugins.octoperf.account.LoginFailed;
import org.jenkinsci.plugins.octoperf.account.LoginSuccessful;
import org.jenkinsci.plugins.octoperf.client.BearerClientAuthentication;
import org.jenkinsci.plugins.octoperf.client.RestApiFactory;
import org.jenkinsci.plugins.octoperf.client.RestClientAuthenticator;
import org.jenkinsci.plugins.octoperf.client.RestClientService;
import org.jenkinsci.plugins.octoperf.client.RetrofitWrapper;
import org.jenkinsci.plugins.octoperf.client.TrustingX509TrustManager;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

final class RetrofitClientService
implements RestClientService {
    private final Optional<ProxyConfiguration> proxy;

    RetrofitClientService(Jenkins jenkins) {
        this.proxy = Optional.ofNullable(jenkins).map(j -> j.proxy);
    }

    @Override
    public Pair<RestApiFactory, RestClientAuthenticator> create(String apiUrl, PrintStream logger) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.findAndRegisterModules();
        mapper.registerSubtypes(new NamedType[]{new NamedType(LoginSuccessful.class, "LoginSuccessful")});
        mapper.registerSubtypes(new NamedType[]{new NamedType(LoginFailed.class, "LoginFailed")});
        Retrofit unauthenticatedClient = new Retrofit.Builder().addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper)).client(this.newClient().build()).baseUrl(apiUrl).build();
        BearerClientAuthentication authenticator = new BearerClientAuthentication((AccountApi)unauthenticatedClient.create(AccountApi.class), logger);
        OkHttpClient.Builder httpClient = this.newClient().authenticator((Authenticator)authenticator).addNetworkInterceptor((Interceptor)authenticator);
        Retrofit retrofit = new Retrofit.Builder().addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper)).client(httpClient.build()).baseUrl(apiUrl).build();
        RetrofitWrapper wrapper = new RetrofitWrapper(retrofit);
        return ImmutablePair.of((Object)wrapper, (Object)authenticator);
    }

    private OkHttpClient.Builder newClient() {
        try {
            TrustingX509TrustManager trustManager = new TrustingX509TrustManager();
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{trustManager}, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            OkHttpClient.Builder builder = new OkHttpClient.Builder().readTimeout(1L, TimeUnit.MINUTES).writeTimeout(1L, TimeUnit.MINUTES).sslSocketFactory(sslSocketFactory, (X509TrustManager)trustManager);
            this.proxy.ifPresent(cfg -> RetrofitClientService.setProxy(cfg, builder));
            return builder;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Could not initialize SSL Context", e);
        }
    }

    private static void setProxy(ProxyConfiguration cfg, OkHttpClient.Builder builder) {
        builder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(cfg.name, cfg.port)));
        String username = Strings.nullToEmpty((String)cfg.getUserName());
        String password = Strings.nullToEmpty((String)cfg.getSecretPassword().getPlainText());
        if (StringUtils.isNotEmpty((CharSequence)username) && StringUtils.isNotEmpty((CharSequence)password)) {
            String credentials = Credentials.basic((String)username, (String)password);
            Authenticator proxyAuthenticator = (route, response) -> response.request().newBuilder().header("Proxy-Authorization", credentials).build();
            builder.proxyAuthenticator(proxyAuthenticator);
        }
    }
}

