/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.octoperf;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.AbstractIdCredentialsListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.Permission;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.tuple.Pair;
import org.jenkinsci.plugins.octoperf.OctoperfBuilder;
import org.jenkinsci.plugins.octoperf.OctoperfCredential;
import org.jenkinsci.plugins.octoperf.client.RestApiFactory;
import org.jenkinsci.plugins.octoperf.client.RestClientAuthenticator;
import org.jenkinsci.plugins.octoperf.client.RestClientService;
import org.jenkinsci.plugins.octoperf.conditions.StopConditionDescriptor;
import org.jenkinsci.plugins.octoperf.credentials.CredentialsService;
import org.jenkinsci.plugins.octoperf.project.Project;
import org.jenkinsci.plugins.octoperf.project.ProjectService;
import org.jenkinsci.plugins.octoperf.scenario.Scenario;
import org.jenkinsci.plugins.octoperf.scenario.ScenarioService;
import org.jenkinsci.plugins.octoperf.workspace.Workspace;
import org.jenkinsci.plugins.octoperf.workspace.WorkspaceService;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;

@Extension
public class OctoperfBuilderDescriptor
extends BuildStepDescriptor<Builder> {
    private static final String ARROW = " => ";
    protected static final String NONE_ID = "noneId";
    protected static final String NONE_DISPLAY_TEXT = "None";
    private String octoperfURL = "https://api.octoperf.com";
    private String name = "OctoPerf Account";

    public OctoperfBuilderDescriptor() {
        super(OctoperfBuilder.class);
        this.load();
    }

    static OctoperfBuilderDescriptor getDescriptor() {
        return (OctoperfBuilderDescriptor)Jenkins.get().getDescriptor(OctoperfBuilder.class);
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }

    public String getDisplayName() {
        return "OctoPerf";
    }

    public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter(value="credentialsId") String credentialsId, Object scope) {
        AbstractIdCredentialsListBoxModel result = new StandardListBoxModel().includeCurrentValue(credentialsId);
        if (!OctoperfBuilderDescriptor.hasAnyPermission(context, Item.EXTENDED_READ, CredentialsProvider.USE_ITEM)) {
            return result;
        }
        LinkedHashSet<String> ids = new LinkedHashSet<String>();
        for (OctoperfCredential c : CredentialsService.CREDENTIALS_SERVICE.getCredentials(scope, OctoperfBuilderDescriptor.getItem())) {
            String id = c.getId();
            if (ids.contains(id)) continue;
            String name = (String)MoreObjects.firstNonNull((Object)Strings.emptyToNull((String)c.getUsername()), (Object)c.getId());
            ListBoxModel.Option option = new ListBoxModel.Option(name, id, Objects.equals(id, credentialsId));
            ids.add(id);
            result.add((Object)option);
        }
        return OctoperfBuilderDescriptor.getOptions((ListBoxModel)result);
    }

    @POST
    public ListBoxModel doFillWorkspaceIdItems(@AncestorInPath Item context, @QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="workspaceId") String workspaceId) {
        ListBoxModel items = new ListBoxModel();
        if (!OctoperfBuilderDescriptor.hasAnyPermission(context, Permission.CONFIGURE)) {
            return items;
        }
        Optional<OctoperfCredential> credentials = OctoperfBuilderDescriptor.getCredential(credentialsId);
        if (credentials.isPresent()) {
            RestApiFactory factory = this.getRestApiFactory(credentials.get());
            try {
                for (Workspace workspace : WorkspaceService.WORKSPACES.getWorkspaces(factory)) {
                    String id = workspace.getId();
                    ListBoxModel.Option option = new ListBoxModel.Option(workspace.getName(), id, Objects.equals(id, workspaceId));
                    items.add((Object)option);
                }
            }
            catch (IOException e) {
                items.add("Failed to connect to OctoPerf, please check your credentials. " + String.valueOf(e));
                e.printStackTrace();
            }
        }
        return OctoperfBuilderDescriptor.getOptions(items);
    }

    @POST
    public ListBoxModel doFillProjectIdItems(@AncestorInPath Item context, @QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="workspaceId") String workspaceId, @QueryParameter(value="projectId") String projectId) {
        ListBoxModel items = new ListBoxModel();
        if (!OctoperfBuilderDescriptor.hasAnyPermission(context, Permission.CONFIGURE)) {
            return items;
        }
        Optional<OctoperfCredential> credentials = OctoperfBuilderDescriptor.getCredential(credentialsId);
        if (credentials.isPresent() && OctoperfBuilderDescriptor.isDefined(workspaceId)) {
            RestApiFactory factory = this.getRestApiFactory(credentials.get());
            try {
                for (Project project : ProjectService.PROJECTS.getProjects(factory, workspaceId)) {
                    String id = project.getId();
                    ListBoxModel.Option option = new ListBoxModel.Option(project.getName(), id, Objects.equals(id, projectId));
                    items.add((Object)option);
                }
            }
            catch (IOException e) {
                items.add("Could not list projects. " + String.valueOf(e));
                e.printStackTrace();
            }
        }
        return OctoperfBuilderDescriptor.getOptions(items);
    }

    @POST
    public ListBoxModel doFillScenarioIdItems(@AncestorInPath Item context, @QueryParameter String credentialsId, @QueryParameter String projectId, @QueryParameter String scenarioId) {
        ListBoxModel items = new ListBoxModel();
        if (!OctoperfBuilderDescriptor.hasAnyPermission(context, Permission.CONFIGURE)) {
            return items;
        }
        Optional<OctoperfCredential> credentials = OctoperfBuilderDescriptor.getCredential(credentialsId);
        if (credentials.isPresent() && OctoperfBuilderDescriptor.isDefined(projectId)) {
            RestApiFactory apiFactory = this.getRestApiFactory(credentials.get());
            try {
                List<Scenario> scenariosByProject = ScenarioService.SCENARIOS.getScenariosByProject(apiFactory, projectId);
                for (Scenario s : scenariosByProject) {
                    String id = s.getId();
                    items.add((Object)new ListBoxModel.Option(s.getName(), id, Objects.equals(id, scenarioId)));
                }
            }
            catch (IOException e) {
                items.add("Could not list scenarios. " + String.valueOf(e));
                e.printStackTrace();
            }
        }
        return OctoperfBuilderDescriptor.getOptions(items);
    }

    private static boolean hasAnyPermission(Item context, Permission ... permissions) {
        if (context == null) {
            return Jenkins.get().hasPermission(Jenkins.ADMINISTER);
        }
        return context.hasAnyPermission(permissions);
    }

    private static boolean isDefined(String id) {
        return Optional.ofNullable(id).map(Strings::emptyToNull).filter(s -> !Objects.equals(s, NONE_ID)).isPresent();
    }

    private static ListBoxModel getOptions(ListBoxModel items) {
        if (items.isEmpty()) {
            items.add(NONE_DISPLAY_TEXT, NONE_ID);
        }
        return items;
    }

    private static Optional<OctoperfCredential> getCredential(String credentialsId) {
        Item item = OctoperfBuilderDescriptor.getItem();
        if (credentialsId.isEmpty()) {
            return CredentialsService.CREDENTIALS_SERVICE.findFirst(item);
        }
        return CredentialsService.CREDENTIALS_SERVICE.find(credentialsId, item);
    }

    private static Item getItem() {
        return (Item)Stapler.getCurrentRequest().findAncestorObject(Item.class);
    }

    private RestApiFactory getRestApiFactory(OctoperfCredential credentials) {
        Pair<RestApiFactory, RestClientAuthenticator> pair = RestClientService.CLIENTS.create(this.octoperfURL, System.out);
        RestApiFactory factory = (RestApiFactory)pair.getLeft();
        String username = credentials.getUsername();
        String password = credentials.getPassword().getPlainText();
        RestClientAuthenticator authenticator = (RestClientAuthenticator)pair.getRight();
        authenticator.onUsernameAndPassword(username, password);
        return factory;
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        String octoperfUrl = formData.optString("octoperfURL");
        this.octoperfURL = octoperfUrl.isEmpty() ? "https://api.octoperf.com" : octoperfUrl;
        this.save();
        return true;
    }

    public List<StopConditionDescriptor> getStopConditionDescriptors() {
        return StopConditionDescriptor.all();
    }

    public String getOctoperfURL() {
        return this.octoperfURL;
    }

    public String getName() {
        return this.name;
    }

    public void setOctoperfURL(String octoperfURL) {
        this.octoperfURL = octoperfURL;
    }

    public void setName(String name) {
        this.name = name;
    }
}

