/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.octoperf;

import hudson.Extension;
import java.util.Optional;
import javaposse.jobdsl.dsl.Context;
import javaposse.jobdsl.dsl.helpers.step.StepContext;
import javaposse.jobdsl.plugin.ContextExtensionPoint;
import javaposse.jobdsl.plugin.DslExtensionMethod;
import org.jenkinsci.plugins.octoperf.OctoPerfBuilderDSLContext;
import org.jenkinsci.plugins.octoperf.OctoperfBuilder;
import org.jenkinsci.plugins.octoperf.OctoperfBuilderDescriptor;
import org.jenkinsci.plugins.octoperf.OctoperfCredential;
import org.jenkinsci.plugins.octoperf.credentials.CredentialsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension(optional=true)
public class OctoPerfBuilderDSLExtension
extends ContextExtensionPoint {
    private static final Logger log = LoggerFactory.getLogger(OctoPerfBuilderDSLExtension.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DslExtensionMethod(context=StepContext.class)
    public Object octoPerfTest(Runnable closure) {
        log.info("Running 'octoPerfTest' method from JOB DSL plugin...");
        OctoPerfBuilderDSLContext context = new OctoPerfBuilderDSLContext();
        OctoPerfBuilderDSLExtension.executeInContext((Runnable)closure, (Context)context);
        OctoperfBuilderDescriptor desc = OctoperfBuilderDescriptor.getDescriptor();
        String serverUrl = desc.getOctoperfURL();
        OctoperfBuilder builder = null;
        try {
            Optional<OctoperfCredential> credentials = CredentialsService.CREDENTIALS_SERVICE.find(context.credentialsId, null);
            log.info(context.credentialsId + " is " + (credentials.isPresent() ? "" : "not") + " present in credentials");
            if (credentials.isPresent()) {
                builder = new OctoperfBuilder(context.credentialsId, "", "", context.scenarioId, context.testName, context.getStopConditions());
                builder.setServerUrl(serverUrl);
            }
        }
        catch (Exception e) {
            log.warn("Failed to create OctoPerfBuilder object from Job DSL description: credentialsId=" + context.credentialsId + ", scenarioId =" + context.scenarioId + ", serverUrl=" + serverUrl);
        }
        finally {
            return builder;
        }
    }
}

