/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.emailext_template.configurationslicing;

import configurationslicing.TopLevelItemSelector;
import configurationslicing.UnorderedStringSlicer;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.jenkinsci.plugins.emailext_template.ExtendedEmailPublisherTemplate;
import org.jenkinsci.plugins.emailext_template.ExtendedEmailTemplatePublisher;
import org.jenkinsci.plugins.emailext_template.Messages;
import org.jenkinsci.plugins.emailext_template.TemplateId;

@Extension(optional=true)
public class ExtEmailTemplateSlicer
extends UnorderedStringSlicer<AbstractProject<?, ?>> {
    public ExtEmailTemplateSlicer() {
        super((UnorderedStringSlicer.UnorderedStringSlicerSpec)new ExtEmailTemplateSlicerSpec());
    }

    public static class ExtEmailTemplateSlicerSpec
    extends UnorderedStringSlicer.UnorderedStringSlicerSpec<AbstractProject<?, ?>> {
        private static final Logger LOGGER = Logger.getLogger(ExtEmailTemplateSlicerSpec.class.getName());
        private static final List<String> SUPPORTED_DELIM = Arrays.asList("\n", ",", ";");

        public String getName() {
            return "Editable Email Notification Templates";
        }

        public String getUrl() {
            return "emailexttemplate";
        }

        protected final ExtendedEmailTemplatePublisher getExtendedEmailTemplatePublisher(AbstractProject<?, ?> project) {
            for (Publisher publisher : project.getPublishersList()) {
                if (!(publisher instanceof ExtendedEmailTemplatePublisher)) continue;
                return (ExtendedEmailTemplatePublisher)publisher;
            }
            return null;
        }

        public List<AbstractProject<?, ?>> getWorkDomain() {
            ArrayList result = new ArrayList();
            for (AbstractProject project : TopLevelItemSelector.getAllTopLevelItems(AbstractProject.class)) {
                result.add(project);
            }
            return result;
        }

        public List<String> getValues(AbstractProject<?, ?> project) {
            ArrayList<String> values = new ArrayList<String>();
            StringBuilder value = new StringBuilder();
            ExtendedEmailTemplatePublisher publisher = this.getExtendedEmailTemplatePublisher(project);
            if (publisher != null) {
                Collection<TemplateId> ids = publisher.getTemplateIds();
                if (ids.size() > 0) {
                    ExtendedEmailTemplatePublisher.DescriptorImpl descriptor = publisher.getDescriptor();
                    int count = 0;
                    for (TemplateId id : ids) {
                        ExtendedEmailPublisherTemplate template = descriptor.getTemplateById(id.getTemplateId());
                        if (template != null) {
                            if (count++ > 0) {
                                value.append(',');
                            }
                            value.append(template.getName());
                            continue;
                        }
                        LOGGER.warning(Messages.TemplateNameRemoved(id));
                    }
                } else {
                    value.append(this.getDefaultValueString());
                }
            } else {
                value.append(this.getDefaultValueString());
            }
            values.add(value.toString());
            return values;
        }

        public String getName(AbstractProject<?, ?> project) {
            return project.getFullName();
        }

        public boolean setValues(AbstractProject<?, ?> project, List<String> list) {
            boolean defaultValue;
            if (list.isEmpty()) {
                return false;
            }
            ArrayList<TemplateId> templateIds = new ArrayList<TemplateId>();
            ExtendedEmailTemplatePublisher publisher = this.getExtendedEmailTemplatePublisher(project);
            boolean bl = defaultValue = list.size() == 1 && (this.getDefaultValueString().equalsIgnoreCase(list.get(0)) || list.get(0).trim().isEmpty());
            if (defaultValue) {
                if (publisher != null) {
                    project.getPublishersList().remove((Object)publisher);
                    return true;
                }
                return false;
            }
            if (publisher == null) {
                publisher = new ExtendedEmailTemplatePublisher(templateIds);
                project.getPublishersList().add((Object)publisher);
            }
            ExtendedEmailTemplatePublisher.DescriptorImpl descriptor = publisher.getDescriptor();
            for (String value : list) {
                String delim = this.findDelimiter(value);
                if (delim != null) {
                    StringTokenizer st = new StringTokenizer(value, delim);
                    while (st.hasMoreElements()) {
                        String token = st.nextToken().trim();
                        if (token.length() <= 0) continue;
                        this.retrieveTemplate(templateIds, token, descriptor);
                    }
                    continue;
                }
                this.retrieveTemplate(templateIds, value, descriptor);
            }
            publisher.setTemplateIds(templateIds);
            try {
                project.save();
            }
            catch (IOException e) {
                LOGGER.throwing(((Object)((Object)this)).getClass().getName(), "setValues", e);
                return false;
            }
            return true;
        }

        private String findDelimiter(String value) {
            String delim = null;
            for (String supDelim : SUPPORTED_DELIM) {
                if (!value.contains(supDelim)) continue;
                delim = supDelim;
                break;
            }
            return delim;
        }

        private void retrieveTemplate(List<TemplateId> templateIds, String name, ExtendedEmailTemplatePublisher.DescriptorImpl descriptor) {
            ExtendedEmailPublisherTemplate template = descriptor.getTemplateByName(name);
            if (template != null) {
                templateIds.add(new TemplateId(template.getId()));
            } else {
                LOGGER.warning(Messages.TemplateNameRemoved(name));
            }
        }

        public String getDefaultValueString() {
            return "(Disabled)";
        }
    }
}

