/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.util.VersionNumber;
import io.jenkins.lib.support_log_formatter.SupportLogFormatter;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jenkinsci.maven.plugins.hpi.AbstractHpiMojo;
import org.jenkinsci.maven.plugins.hpi.Artifacts;
import org.jenkinsci.maven.plugins.hpi.MavenArtifact;
import org.jenkinsci.maven.plugins.hpi.PluginWorkspaceMap;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.COMPILE)
public class RunMojo
extends AbstractHpiMojo {
    private static final List<String> FILTERED_JVM_SYSTEM_PROPERTIES_STARTS_WITH = List.of("changelist.format", "mvnd.", "maven.", "skip.");
    private static final List<String> FILTERED_JVM_SYSTEM_PROPERTIES_EXACT = List.of("host", "jenkinsHome", "style.color", "port", "test", "wildcardLocalhostDNS", "wildcardDNS", "webAppFile");
    @Parameter(property="webAppFile")
    private File webAppFile;
    @Parameter(property="jenkinsHome", defaultValue="${JENKINS_HOME}")
    private File jenkinsHome;
    @Parameter(defaultValue="test")
    protected String dependencyResolution;
    @Parameter(property="maven.hpi.run.jvmArgs", defaultValue="-Xms512M -Xmx1G -XX:+HeapDumpOnOutOfMemoryError @{jenkins.addOpens}")
    protected String jvmArgs;
    @Parameter(property="maven.hpi.winstoneArgs", defaultValue="--enable-future-java")
    protected String winstoneArgs;
    @Inject
    private BuildPluginManager pluginManager;
    @Parameter(property="maven.hpi.debug")
    private String debugForkedProcess;
    @Parameter(property="maven.hpi.debug.port", defaultValue="5005")
    protected int debugPort;
    @Parameter(property="port", defaultValue="8080")
    protected int defaultPort;
    @Parameter(property="host", defaultValue="localhost")
    protected String defaultHost;
    @Parameter(property="wildcardDNS")
    protected String wildcardDNS;
    @Parameter(property="wildcardLocalhostDNS")
    protected String wildcardLocalhostDNS;
    @Parameter
    protected String jenkinsCoreId;
    @Parameter
    protected String jenkinsWarId;
    @Parameter
    protected String maskClasses;
    @Parameter
    private Map<String, String> loggers;
    @Inject
    protected PluginWorkspaceMap pluginWorkspaceMap;
    @Parameter
    private WebApp webApp;
    @Parameter
    private Map<String, String> systemProperties;

    @SuppressFBWarnings(value={"COMMAND_INJECTION"}, justification="ProcessBuilder arguments are constructed from internal plugin configuration and not user input.")
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getProject().setArtifacts(this.resolveDependencies(this.dependencyResolution));
        File basedir = this.getProject().getBasedir();
        if (this.jenkinsHome == null) {
            String h = System.getenv("JENKINS_HOME");
            if (h == null) {
                h = System.getenv("HUDSON_HOME");
            }
            this.jenkinsHome = h != null && !h.isEmpty() && !h.equals("null") ? new File(h) : new File(basedir, "work");
        }
        Artifacts jenkinsArtifacts = Artifacts.of(this.getProject()).groupIdIs("org.jenkins-ci.main", "org.jvnet.hudson.main").artifactIdIsNot("remoting");
        Artifact jenkinsWarArtifact = MavenArtifact.resolveArtifact(this.getJenkinsWarArtifact(), this.project, this.session, this.repositorySystem);
        this.setAddOpensProperty(jenkinsWarArtifact);
        if (this.webAppFile == null) {
            this.webAppFile = jenkinsWarArtifact.getFile();
            if (this.webAppFile == null || !this.webAppFile.isFile()) {
                throw new MojoExecutionException("Could not find " + String.valueOf(this.webAppFile) + " from " + String.valueOf(jenkinsWarArtifact));
            }
        }
        for (Artifact a : jenkinsArtifacts) {
            Artifact ba = (Artifact)jenkinsArtifacts.get(0);
            if (a.getVersion().equals(ba.getVersion())) continue;
            throw new MojoExecutionException("Version of " + a.getId() + " is inconsistent with " + ba.getId());
        }
        File pluginsDir = new File(this.jenkinsHome, "plugins");
        try {
            Files.createDirectories(pluginsDir.toPath(), new FileAttribute[0]);
        }
        catch (IOException e2) {
            throw new MojoExecutionException("Failed to create directories for '" + String.valueOf(pluginsDir) + "'", (Exception)e2);
        }
        this.generateHpl();
        try {
            for (MavenArtifact a : this.getProjectArtifacts()) {
                if (!a.isPlugin(this.getLog())) continue;
                Artifact hpi = this.artifactFactory.createArtifact(a.getGroupId(), a.getArtifactId(), a.getVersion(), null, "hpi");
                if (this.hasSameGavAsProject(hpi = MavenArtifact.resolveArtifact(hpi, this.project, this.session, this.repositorySystem))) continue;
                if (hpi.getFile().isDirectory()) {
                    throw new UnsupportedOperationException(String.valueOf(hpi.getFile()) + " is a directory and not packaged yet. this isn't supported");
                }
                File upstreamHpl = this.pluginWorkspaceMap.read(hpi.getId());
                String actualArtifactId = a.getActualArtifactId();
                if (actualArtifactId == null) {
                    throw new MojoExecutionException("Failed to load actual artifactId from " + String.valueOf(a) + " ~ " + String.valueOf(a.getFile()));
                }
                if (upstreamHpl != null) {
                    this.copyHpl(upstreamHpl, pluginsDir, actualArtifactId);
                    continue;
                }
                this.copyPlugin(hpi.getFile(), pluginsDir, actualArtifactId);
            }
        }
        catch (IOException e3) {
            throw new MojoExecutionException("Unable to copy dependency plugin", (Exception)e3);
        }
        if (System.getProperty("java.util.logging.config.file") == null) {
            System.setProperty("org.apache.juli.formatter", SupportLogFormatter.class.getName());
        }
        if (this.loggers != null && !this.loggers.isEmpty()) {
            this.writeInitGroovyLoggers(this.loggers, this.jenkinsHome);
        }
        String effectiveContextPath = null;
        if (this.webApp != null && this.webApp.getContextPath() != null && !this.webApp.getContextPath().trim().isEmpty()) {
            effectiveContextPath = this.webApp.getContextPath().trim();
        }
        String effectiveHost = this.defaultHost == null || this.defaultHost.trim().isEmpty() ? "localhost" : this.defaultHost.trim();
        String externalHost = this.getExternalHost(effectiveHost);
        String jenkinsUrl = RunMojo.buildJenkinsUrl(externalHost, this.defaultPort, effectiveContextPath);
        this.getLog().info((CharSequence)("===========> Browse to: " + jenkinsUrl));
        String argLine = this.expandAtPropertyToken(this.jvmArgs);
        ArrayList<String> cmd = new ArrayList<String>();
        String javaExe = System.getProperty("java.home") + "/bin/java";
        cmd.add(javaExe);
        if (RunMojo.isDebuggerPresent() || "true".equalsIgnoreCase(this.debugForkedProcess)) {
            cmd.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=" + this.debugPort);
        } else if (this.debugForkedProcess != null && !this.debugForkedProcess.isBlank()) {
            cmd.add(this.debugForkedProcess.trim());
        }
        for (Map.Entry<String, String> e4 : this.systemProperties.entrySet()) {
            String key = e4.getKey().trim();
            String val = e4.getValue() == null ? "" : e4.getValue();
            cmd.add("-D" + key + "=" + val);
        }
        for (Artifact a : this.project.getArtifacts()) {
            File coreBasedir;
            if (!a.getGroupId().equals("org.jenkins-ci.main") || !a.getArtifactId().equals("jenkins-core")) continue;
            try {
                coreBasedir = this.pluginWorkspaceMap.read(a.getId());
            }
            catch (IOException e5) {
                throw new RuntimeException(e5);
            }
            if (coreBasedir == null) continue;
            String extraCP = String.valueOf(new File(coreBasedir, "src/main/resources").toURI()) + File.pathSeparator + String.valueOf(new File(coreBasedir, "target/classes").toURI());
            cmd.add("-cp");
            cmd.add(extraCP);
        }
        cmd.add("-DJENKINS_HOME=" + this.jenkinsHome.getAbsolutePath());
        cmd.add("-Dstapler.jelly.noCache=true");
        List res = this.getProject().getBuild().getResources();
        if (!res.isEmpty()) {
            Resource r = (Resource)res.get(0);
            cmd.add("-Dstapler.resourcePath=" + r.getDirectory());
        }
        this.session.getUserProperties().entrySet().stream().filter(e -> {
            String key = String.valueOf(e.getKey());
            if (FILTERED_JVM_SYSTEM_PROPERTIES_EXACT.contains(key)) return false;
            if (!FILTERED_JVM_SYSTEM_PROPERTIES_STARTS_WITH.stream().noneMatch(key::startsWith)) return false;
            return true;
        }).forEach(entry -> cmd.add("-D" + String.valueOf(entry.getKey()) + "=" + String.valueOf(entry.getValue())));
        RunMojo.addArgs(cmd, argLine);
        cmd.add("-jar");
        cmd.add(this.webAppFile.getAbsolutePath());
        if (!effectiveHost.isEmpty()) {
            cmd.add("--httpListenAddress=" + effectiveHost);
        }
        if (this.defaultPort > 0) {
            cmd.add("--httpPort=" + this.defaultPort);
        }
        if (effectiveContextPath != null) {
            String prefix = effectiveContextPath.trim();
            cmd.add("--prefix=" + prefix);
        }
        if (this.winstoneArgs != null) {
            cmd.add(this.winstoneArgs);
        }
        this.getLog().info((CharSequence)("Launching Jenkins: " + String.join((CharSequence)" ", cmd)));
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.directory(this.jenkinsHome);
        pb.inheritIO();
        pb.environment().put("JENKINS_HOME", this.jenkinsHome.getAbsolutePath());
        try {
            Process proc = pb.start();
            int exitCode = proc.waitFor();
            if (exitCode != 0) {
                throw new MojoExecutionException("Jenkins exited with code " + exitCode);
            }
        }
        catch (IOException | InterruptedException e6) {
            throw new MojoExecutionException("Failed to launch Jenkins", e6);
        }
    }

    private String getExternalHost(String effectiveHost) {
        boolean wildcardEnabled = this.wildcardLocalhostDNS != null && !this.wildcardLocalhostDNS.trim().isEmpty() || this.wildcardDNS != null && !this.wildcardDNS.trim().isEmpty();
        Object externalHost = effectiveHost;
        if (wildcardEnabled) {
            String id = this.getProject().getArtifactId();
            externalHost = this.wildcardLocalhostDNS != null && !this.wildcardLocalhostDNS.trim().isEmpty() ? id + "." + this.wildcardLocalhostDNS.trim() : id + ".127.0.0.1." + this.wildcardDNS.trim();
        }
        return externalHost;
    }

    public static boolean isDebuggerPresent() {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        List<String> args = runtime.getInputArguments();
        return args.toString().contains("jdwp");
    }

    private boolean hasSameGavAsProject(Artifact a) {
        return this.getProject().getGroupId().equals(a.getGroupId()) && this.getProject().getArtifactId().equals(a.getArtifactId()) && this.getProject().getVersion().equals(a.getVersion());
    }

    private void copyPlugin(File src, File pluginsDir, String shortName) throws IOException {
        File dst = new File(pluginsDir, shortName + ".jpi");
        File hpi = new File(pluginsDir, shortName + ".hpi");
        if (Files.isRegularFile(hpi.toPath(), new LinkOption[0])) {
            this.getLog().warn((CharSequence)("Moving historical " + String.valueOf(hpi) + " to *.jpi"));
            Files.move(hpi.toPath(), dst.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        VersionNumber dstV = this.versionOfPlugin(dst);
        if (this.versionOfPlugin(src).compareTo(dstV) < 0) {
            this.getLog().info((CharSequence)("will not overwrite " + String.valueOf(dst) + " with " + String.valueOf(src) + " because " + String.valueOf(dstV) + " is newer"));
            return;
        }
        this.getLog().info((CharSequence)("Copying dependency Jenkins plugin " + String.valueOf(src)));
        FileUtils.copyFile((File)src, (File)dst);
        Files.writeString(pluginsDir.toPath().resolve(shortName + ".jpi.pinned"), (CharSequence)"pinned", StandardCharsets.US_ASCII, new OpenOption[0]);
        Files.deleteIfExists(new File(pluginsDir, shortName + ".jpl").toPath());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private VersionNumber versionOfPlugin(File p) throws IOException {
        if (!p.isFile()) {
            return new VersionNumber("0.0");
        }
        try (JarFile j = new JarFile(p);){
            String v = j.getManifest().getMainAttributes().getValue("Plugin-Version");
            if (v == null) {
                throw new IOException("no Plugin-Version in " + String.valueOf(p));
            }
            try {
                VersionNumber versionNumber = new VersionNumber(v);
                return versionNumber;
            }
            catch (IllegalArgumentException x) {
                throw new IOException("malformed Plugin-Version in " + String.valueOf(p) + ": " + String.valueOf(x), x);
            }
        }
        catch (IOException x) {
            throw new IOException("not a valid JarFile: " + String.valueOf(p), x);
        }
    }

    private void copyHpl(File src, File pluginsDir, String shortName) throws IOException {
        File dst = new File(pluginsDir, shortName + ".jpl");
        this.getLog().info((CharSequence)("Copying snapshot dependency Jenkins plugin " + String.valueOf(src)));
        FileUtils.copyFile((File)src, (File)dst);
        Files.writeString(pluginsDir.toPath().resolve(shortName + ".jpi.pinned"), (CharSequence)"pinned", StandardCharsets.US_ASCII, new OpenOption[0]);
    }

    private void generateHpl() throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.jenkins-ci.tools"), (String)MojoExecutor.artifactId((String)"maven-hpi-plugin")), (String)MojoExecutor.goal((String)"hpl"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"jenkinsHome"), (String)this.jenkinsHome.toString()), MojoExecutor.element((String)MojoExecutor.name((String)"pluginName"), (String)this.project.getName()), MojoExecutor.element((String)MojoExecutor.name((String)"warSourceDirectory"), (String)this.warSourceDirectory.toString()), MojoExecutor.element((String)MojoExecutor.name((String)"jenkinsCoreId"), (String)this.jenkinsCoreId), MojoExecutor.element((String)MojoExecutor.name((String)"pluginFirstClassLoader"), (String)Boolean.toString(this.pluginFirstClassLoader)), MojoExecutor.element((String)MojoExecutor.name((String)"maskClasses"), (String)this.maskClasses)}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
    }

    protected Artifact getJenkinsWarArtifact() throws MojoExecutionException {
        for (Artifact a : this.resolveDependencies("test")) {
            boolean match;
            if (this.jenkinsWarId != null) {
                match = (a.getGroupId() + ":" + a.getArtifactId()).equals(this.jenkinsWarId);
            } else {
                boolean bl = match = !(!a.getArtifactId().equals("jenkins-war") && !a.getArtifactId().equals("hudson-war") || !a.getType().equals("executable-war") && !a.getType().equals("war"));
            }
            if (!match) continue;
            return a;
        }
        String inferredVersion = this.findJenkinsVersion();
        String[] gav = Optional.ofNullable(this.jenkinsWarId).map(id -> id.split(":", 2)).orElse(null);
        String groupId = gav != null && gav.length == 2 ? gav[0] : "org.jenkins-ci.main";
        String artifactId = gav != null && gav.length == 2 ? gav[1] : "jenkins-war";
        this.getLog().info((CharSequence)("No Jenkins WAR dependency found; resolving " + groupId + ":" + artifactId + ":war:" + inferredVersion));
        Artifact war = this.artifactFactory.createArtifact(groupId, artifactId, inferredVersion, null, "war");
        return MavenArtifact.resolveArtifact(war, this.project, this.session, this.repositorySystem);
    }

    protected MavenProject getProject() {
        return this.project;
    }

    private String expandAtPropertyToken(String value) {
        if (value == null) {
            return "";
        }
        if (!value.contains("@{")) {
            return value;
        }
        Matcher m = Pattern.compile("@\\{([^}]+)}").matcher(value);
        StringBuilder out = new StringBuilder();
        while (m.find()) {
            String key = m.group(1);
            String resolved = this.project.getProperties().getProperty(key);
            if (resolved == null) {
                resolved = this.session.getSystemProperties().getProperty(key);
            }
            if (resolved == null) {
                resolved = System.getProperty(key);
            }
            if (resolved == null) {
                this.getLog().warn((CharSequence)("Unable to resolve placeholder @{" + key + "}; skipping"));
                resolved = "";
            }
            m.appendReplacement(out, Matcher.quoteReplacement(resolved.trim()));
        }
        m.appendTail(out);
        return out.toString().trim();
    }

    private static void addArgs(List<String> cmd, String args) {
        if (args == null) {
            return;
        }
        String trimmed = args.trim();
        if (trimmed.isEmpty()) {
            return;
        }
        String[] parts = trimmed.split("\\s+");
        for (int i = 0; i < parts.length; ++i) {
            String p = parts[i];
            if (p == null || p.isEmpty()) continue;
            if ("--add-opens".equals(p) || "--add-exports".equals(p) || "--patch-module".equals(p)) {
                String v;
                cmd.add(p);
                if (i + 1 >= parts.length || (v = parts[++i]) == null || v.isEmpty()) continue;
                cmd.add(v);
                continue;
            }
            cmd.add(p);
        }
    }

    @Nullable
    private static String buildJenkinsUrl(String host, int port, @Nullable String contextPath) {
        if (host == null || host.isBlank()) {
            return null;
        }
        Object path = null;
        if (contextPath != null && !contextPath.isBlank()) {
            String cp = contextPath.trim();
            Object object = path = cp.startsWith("/") ? cp : "/" + cp;
        }
        if (path == null) {
            path = "/";
        } else if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        try {
            URI uri = new URI("http", null, host.trim(), port, (String)path, null, null);
            return uri.toString();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private void writeInitGroovyLoggers(Map<String, String> configuredLoggers, File jenkinsHome) throws MojoExecutionException {
        File groovyDir = new File(jenkinsHome, "init.groovy.d");
        try {
            Files.createDirectories(groovyDir.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create Jenkins init.groovy.d directory: " + String.valueOf(groovyDir), (Exception)e);
        }
        StringBuilder groovy = new StringBuilder();
        groovy.append("import io.jenkins.lib.support_log_formatter.SupportLogFormatter\nimport java.util.logging.ConsoleHandler\nimport java.util.logging.Level\nimport java.util.logging.Logger\n\n// Generated by maven-hpi-plugin (hpi:run).\n// This file configures log levels requested via <loggers> in the Maven plugin configuration.\n\n");
        ArrayList<String> names = new ArrayList<String>(configuredLoggers.keySet());
        Collections.sort(names);
        for (String loggerName : names) {
            String level = configuredLoggers.get(loggerName);
            try {
                Level.parse(level);
            }
            catch (IllegalArgumentException ex) {
                throw new MojoExecutionException("Invalid logger level '" + level + "' for logger '" + loggerName + "'. Use a valid java.util.logging.Level name (e.g. INFO, FINE, FINER, FINEST).", (Exception)ex);
            }
            groovy.append("({ ->\n");
            groovy.append("  def logger = Logger.getLogger('").append(loggerName.replace("\\", "\\\\").replace("'", "\\'")).append("');\n");
            groovy.append("  logger.setLevel(Level.").append(level).append(");\n");
            groovy.append("  def handler = new ConsoleHandler();\n");
            groovy.append("  handler.setLevel(Level.").append(level).append(");\n");
            groovy.append("  handler.setFormatter(new SupportLogFormatter());\n");
            groovy.append("  logger.addHandler(handler);\n");
            groovy.append("  logger.setUseParentHandlers(false);\n");
            groovy.append("})()\n");
        }
        File out = new File(groovyDir, "maven-hpi-loggers.groovy");
        try {
            Files.writeString(out.toPath(), (CharSequence)groovy.toString(), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write " + String.valueOf(out), (Exception)e);
        }
        this.getLog().info((CharSequence)("Wrote Jenkins init script for loggers: " + String.valueOf(out)));
    }

    public static final class WebApp {
        @Parameter
        private String contextPath;

        public String getContextPath() {
            return this.contextPath;
        }
    }
}

