/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xunit.pipeline;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.tasks.junit.TestDataPublisher;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jenkinsci.lib.dtkit.descriptor.TestTypeDescriptor;
import org.jenkinsci.lib.dtkit.type.TestType;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.xunit.Messages;
import org.jenkinsci.plugins.xunit.XUnitUtil;
import org.jenkinsci.plugins.xunit.pipeline.XUnitResultsStepExecution;
import org.jenkinsci.plugins.xunit.threshold.XUnitThreshold;
import org.jenkinsci.plugins.xunit.threshold.XUnitThresholdDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class XUnitResultsStep
extends Step {
    private List<TestType> tools;
    private List<XUnitThreshold> thresholds;
    private int thresholdMode = 1;
    private long testTimeMargin = 3000L;
    private long sleepTime = 10L;
    private boolean reduceLog = true;
    private boolean followSymlink = true;
    private Collection<TestDataPublisher> testDataPublishers;
    private boolean skipPublishingChecks = true;
    private String checksName = null;

    @DataBoundConstructor
    public XUnitResultsStep(@CheckForNull List<TestType> tools) {
        this.tools = tools != null ? tools : Collections.emptyList();
    }

    @NonNull
    public List<TestType> getTools() {
        return this.tools;
    }

    @NonNull
    public List<XUnitThreshold> getThresholds() {
        return this.thresholds != null ? this.thresholds : Collections.emptyList();
    }

    @DataBoundSetter
    public void setThresholds(@NonNull List<XUnitThreshold> thresholds) {
        this.thresholds = thresholds;
    }

    @DataBoundSetter
    public void setThresholdMode(int thresholdMode) {
        this.thresholdMode = thresholdMode;
    }

    public int getThresholdMode() {
        return this.thresholdMode;
    }

    @DataBoundSetter
    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    @DataBoundSetter
    public void setTestTimeMargin(String testTimeMargin) {
        this.testTimeMargin = XUnitUtil.parsePositiveLong(testTimeMargin, 3000L);
    }

    public String getTestTimeMargin() {
        return String.valueOf(this.testTimeMargin);
    }

    public long getTestTimeMarginAsLong() {
        return this.testTimeMargin;
    }

    @NonNull
    public Collection<TestDataPublisher> getTestDataPublishers() {
        return this.testDataPublishers != null ? this.testDataPublishers : Collections.emptyList();
    }

    @DataBoundSetter
    public void setTestDataPublishers(@NonNull Collection<TestDataPublisher> testDataPublishers) {
        this.testDataPublishers = testDataPublishers;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new XUnitResultsStepExecution(this, context);
    }

    public boolean isReduceLog() {
        return this.reduceLog;
    }

    @DataBoundSetter
    public void setReduceLog(boolean reduceLog) {
        this.reduceLog = reduceLog;
    }

    public boolean isFollowSymlink() {
        return this.followSymlink;
    }

    @DataBoundSetter
    public void setFollowSymlink(boolean followSymlink) {
        this.followSymlink = followSymlink;
    }

    public boolean isSkipPublishingChecks() {
        return this.skipPublishingChecks;
    }

    @DataBoundSetter
    public void setSkipPublishingChecks(boolean skipPublishingChecks) {
        this.skipPublishingChecks = skipPublishingChecks;
    }

    @Nullable
    public String getChecksName() {
        return this.checksName;
    }

    @DataBoundSetter
    public void setChecksName(String checksName) {
        this.checksName = checksName;
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "xunit";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.xUnit_PublisherName();
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(FilePath.class, FlowNode.class, TaskListener.class);
        }

        public DescriptorExtensionList<TestType, TestTypeDescriptor<?>> getListXUnitTypeDescriptors() {
            return TestTypeDescriptor.all();
        }

        public DescriptorExtensionList<XUnitThreshold, XUnitThresholdDescriptor<?>> getListXUnitThresholdDescriptors() {
            return XUnitThresholdDescriptor.all();
        }

        public DescriptorExtensionList<TestDataPublisher, Descriptor<TestDataPublisher>> getListTestDataPublisherDescriptors() {
            return TestDataPublisher.all();
        }
    }
}

