/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.plugins.xrayjenkins.task.filefilters;

import com.xpandit.plugins.xrayjenkins.Utils.FileUtils;
import hudson.FilePath;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.Set;

public class OnlyFeatureFilesInPathFilter
implements FileFilter,
Serializable {
    private final Set<String> validFilePaths;
    private final String lastModified;

    public OnlyFeatureFilesInPathFilter(Set<String> validFilePaths, String lastModified) {
        this.validFilePaths = validFilePaths;
        this.lastModified = lastModified;
    }

    @Override
    public boolean accept(File pathname) {
        return this.validFilePaths.contains(pathname.getAbsolutePath()) && this.isApplicableAsModifiedFile(pathname);
    }

    private boolean isApplicableAsModifiedFile(File pathname) {
        return pathname != null && FileUtils.isApplicableAsModifiedFile(new FilePath(pathname), this.lastModified);
    }
}

