/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.plugins.xrayjenkins.services.enviromentvariables.util;

import com.google.common.collect.Sets;
import com.xpandit.plugins.xrayjenkins.model.HostingType;
import com.xpandit.xray.model.UploadResult;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class XrayEnvironmentVariableSetterUtil {
    public static final char SEPARATOR = ';';
    public static final String TRUE_STRING = Boolean.toString(true);
    public static final String FALSE_STRING = Boolean.toString(false);

    private XrayEnvironmentVariableSetterUtil() {
    }

    public static String getRawResponses(@Nonnull Collection<UploadResult> results) {
        ArrayList<String> resultsString = new ArrayList<String>(results.size());
        for (UploadResult result : results) {
            resultsString.add(result.getMessage());
        }
        return StringUtils.join(resultsString, (char)';');
    }

    public static String getModifiedTestExecutionsKeys(Collection<UploadResult> results, HostingType hostingType, @Nullable PrintStream logger) {
        HashSet<String> testExecutionKeys = new HashSet<String>(results.size());
        for (UploadResult result : results) {
            String testExecutionKey = XrayEnvironmentVariableSetterUtil.getTestExecutionKey(result, hostingType, logger);
            if (!StringUtils.isNotBlank((CharSequence)testExecutionKey)) continue;
            testExecutionKeys.add(testExecutionKey);
        }
        return StringUtils.join(testExecutionKeys, (char)';');
    }

    private static String getTestExecutionKey(UploadResult result, HostingType hostingType, @Nullable PrintStream logger) {
        JSONObject root;
        try {
            root = new JSONObject(result.getMessage());
        }
        catch (Exception e) {
            return "";
        }
        switch (hostingType) {
            case CLOUD: {
                if (root.has("key")) {
                    return root.getString("key");
                }
                return "";
            }
            case SERVER: {
                JSONObject testExecIssue;
                if (root.has("testExecIssue") && (testExecIssue = root.getJSONObject("testExecIssue")).has("key")) {
                    return testExecIssue.getString("key");
                }
                return "";
            }
        }
        if (logger != null) {
            logger.println("[getTestExecutionKey] Hosting Type not implemented!");
        }
        return "";
    }

    public static String getModifiedTestKeys(Collection<UploadResult> results, HostingType hostingType, @Nullable PrintStream logger) {
        HashSet<String> testKeys = new HashSet<String>(results.size());
        for (UploadResult result : results) {
            String testKey = XrayEnvironmentVariableSetterUtil.getTestKey(result, hostingType, logger);
            if (!StringUtils.isNotBlank((CharSequence)testKey)) continue;
            testKeys.add(testKey);
        }
        return StringUtils.join(testKeys, (char)';');
    }

    private static String getTestKey(UploadResult result, HostingType hostingType, @Nullable PrintStream logger) {
        JSONObject root;
        try {
            root = new JSONObject(result.getMessage());
        }
        catch (Exception e) {
            return "";
        }
        switch (hostingType) {
            case CLOUD: {
                return "";
            }
            case SERVER: {
                Set<String> testKeys = XrayEnvironmentVariableSetterUtil.extractTestKeysFromJson(root);
                return StringUtils.join(testKeys, (char)';');
            }
        }
        if (logger != null) {
            logger.println("[getTestKey] Hosting Type not implemented!");
        }
        return "";
    }

    private static Set<String> extractTestKeysFromJson(JSONObject root) {
        JSONObject testIssuesResult;
        HashSet<String> testKeys = new HashSet<String>();
        if (root.has("testIssues") && (testIssuesResult = root.getJSONObject("testIssues")).has("success")) {
            JSONArray createdTestIssues = testIssuesResult.getJSONArray("success");
            for (int i = 0; i < createdTestIssues.length(); ++i) {
                JSONObject testIssue = createdTestIssues.getJSONObject(i);
                if (!testIssue.has("key")) continue;
                testKeys.add(testIssue.getString("key"));
            }
        }
        return testKeys;
    }

    public static String isUploadSuccessful(Collection<UploadResult> results) {
        for (UploadResult result : results) {
            int statusCode = result.getStatusCode();
            if (statusCode >= 200 && statusCode <= 299) continue;
            return FALSE_STRING;
        }
        return TRUE_STRING;
    }

    public static String getImportedFeatureIssueKeys(Collection<UploadResult> results, HostingType hostingType, @Nullable PrintStream logger) {
        HashSet<String> allTestKeys = new HashSet<String>(results.size());
        for (UploadResult result : results) {
            String testKeys = XrayEnvironmentVariableSetterUtil.getSingleResultImportedIssueKeys(result, hostingType, logger);
            if (!StringUtils.isNotBlank((CharSequence)testKeys)) continue;
            allTestKeys.add(testKeys);
        }
        return StringUtils.join(allTestKeys, (char)';');
    }

    private static String getSingleResultImportedIssueKeys(UploadResult result, HostingType hostingType, PrintStream logger) {
        switch (hostingType) {
            case CLOUD: {
                JSONObject cloudRoot;
                try {
                    cloudRoot = new JSONObject(result.getMessage());
                }
                catch (Exception e) {
                    return "";
                }
                return StringUtils.join(XrayEnvironmentVariableSetterUtil.getCloudSingleResultImportedIssueKeys(cloudRoot), (char)';');
            }
            case SERVER: {
                JSONArray serverRoot;
                try {
                    serverRoot = new JSONArray(result.getMessage());
                }
                catch (Exception e) {
                    return "";
                }
                return StringUtils.join(XrayEnvironmentVariableSetterUtil.getServerSingleResultImportedIssueKeys(serverRoot), (char)';');
            }
        }
        if (logger != null) {
            logger.println("[getSingleResultImportedTestKeys] Hosting Type not implemented!");
        }
        return "";
    }

    private static Set<String> getServerSingleResultImportedIssueKeys(JSONArray root) {
        HashSet updatedOrCreatedIssueKeys = Sets.newHashSet();
        for (int i = 0; i < root.length(); ++i) {
            JSONObject test = root.getJSONObject(i);
            if (!test.has("key")) continue;
            updatedOrCreatedIssueKeys.add(test.getString("key"));
        }
        return updatedOrCreatedIssueKeys;
    }

    private static Set<String> getCloudSingleResultImportedIssueKeys(JSONObject root) {
        JSONObject test;
        int i;
        JSONArray tests;
        HashSet updatedOrCreatedIssueKeys = Sets.newHashSet();
        if (root.has("updatedOrCreatedTests")) {
            tests = root.getJSONArray("updatedOrCreatedTests");
            for (i = 0; i < tests.length(); ++i) {
                test = tests.getJSONObject(i);
                if (!test.has("key")) continue;
                updatedOrCreatedIssueKeys.add(test.getString("key"));
            }
        }
        if (root.has("updatedOrCreatedPreconditions")) {
            tests = root.getJSONArray("updatedOrCreatedPreconditions");
            for (i = 0; i < tests.length(); ++i) {
                test = tests.getJSONObject(i);
                if (!test.has("key")) continue;
                updatedOrCreatedIssueKeys.add(test.getString("key"));
            }
        }
        return updatedOrCreatedIssueKeys;
    }
}

