/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.plugins.xrayjenkins.model;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.xpandit.plugins.xrayjenkins.Utils.CredentialUtil;
import com.xpandit.plugins.xrayjenkins.Utils.ProxyUtil;
import com.xpandit.plugins.xrayjenkins.factory.ClientFactory;
import com.xpandit.plugins.xrayjenkins.model.HostingType;
import com.xpandit.plugins.xrayjenkins.model.XrayInstance;
import com.xpandit.xray.service.XrayClient;
import com.xpandit.xray.service.XrayCloudCredentials;
import com.xpandit.xray.service.XrayServerCredentials;
import com.xpandit.xray.service.impl.bean.ConnectionResult;
import com.xpandit.xray.service.impl.delegates.HttpRequestProvider;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class ServerConfiguration
extends GlobalConfiguration {
    private static final int MAX_ERROR_TEXT_LENGTH = 200;
    private static final Logger logger = LoggerFactory.getLogger(ServerConfiguration.class);
    private List<XrayInstance> serverInstances = new ArrayList<XrayInstance>();

    public ServerConfiguration() {
        this.load();
        this.checkForCompatibility();
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        this.checkInvalidCloudCredentials(formData);
        req.bindJSON((Object)this, formData.getJSONObject("xrayinstance"));
        this.save();
        return true;
    }

    private void checkInvalidCloudCredentials(JSONObject formData) throws Descriptor.FormException {
        Type listType;
        if (!formData.has("xrayinstance")) {
            return;
        }
        JSONObject xrayInstances = formData.getJSONObject("xrayinstance");
        if (!xrayInstances.has("serverInstances") || !(xrayInstances.get("serverInstances") instanceof JSONArray)) {
            return;
        }
        String xrayInstancesJson = xrayInstances.getJSONArray("serverInstances").toString();
        List instances = (List)new Gson().fromJson(xrayInstancesJson, listType = new TypeToken<List<XrayInstance>>(){}.getType());
        Set<String> cloudCredentialIds = instances.stream().filter(instance -> instance.getHosting() == HostingType.CLOUD).map(XrayInstance::getCredentialId).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(cloudCredentialIds) && CredentialUtil.hasNonUsernamePasswordCredentials(CredentialUtil.getAllSystemCredentials(null), cloudCredentialIds)) {
            throw new Descriptor.FormException("[Xray connector] Jira cloud instances can either be empty or have credentials of type Username/Password.", "xrayinstance");
        }
    }

    public void setServerInstances(List<XrayInstance> serverInstances) {
        this.serverInstances = serverInstances;
    }

    public List<XrayInstance> getServerInstances() {
        return this.serverInstances;
    }

    public String getCloudHostingTypeName() {
        return HostingType.getCloudHostingName();
    }

    public String getServerHostingTypeName() {
        return HostingType.getServerHostingName();
    }

    public static ServerConfiguration get() {
        return (ServerConfiguration)((Object)GlobalConfiguration.all().get(ServerConfiguration.class));
    }

    public ListBoxModel doFillCredentialIdItems(@AncestorInPath Item item, @QueryParameter String credentialId) {
        return CredentialUtil.getAllCredentialsListBoxModel(item, credentialId);
    }

    public FormValidation doCheckCredentialId(@AncestorInPath Item item, @QueryParameter String value) {
        if (item == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || item != null && !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
            return FormValidation.ok();
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            return FormValidation.warning((String)"Leave the credentials field empty if you want to pick user scoped credentials for each Build Task.");
        }
        if (!this.credentialExists(item, value)) {
            return FormValidation.error((String)"Cannot find currently selected credentials");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckServerAddress(@AncestorInPath Item item, @QueryParameter(value="hosting") String hosting, @QueryParameter(value="serverAddress") String serverAddress) {
        HttpRequestProvider.ProxyBean proxyBean;
        Optional<ConnectionResult> jiraInstanceConnection;
        boolean isJiraInstance;
        if (item == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || item != null && !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
            return FormValidation.ok();
        }
        if (Objects.equals(hosting, HostingType.SERVER.toString()) && StringUtils.isNotBlank((CharSequence)serverAddress) && !(isJiraInstance = (jiraInstanceConnection = ClientFactory.getServerClientWithoutCredentials(serverAddress, proxyBean = ProxyUtil.createProxyBean()).map(XrayClient::isJiraInstance)).map(ConnectionResult::isSuccessful).orElse(Boolean.FALSE).booleanValue())) {
            String statusCode = jiraInstanceConnection.flatMap(ConnectionResult::getStatusCode).map(String::valueOf).orElse("N/A");
            logger.error("URL provided is not from a Jira instance -> [status code: {}] {}/rest/api/2/serverInfo didn't return a valid result.", (Object)statusCode, (Object)serverAddress);
            return FormValidation.error((String)"URL provided is not from a Jira instance (check if your /serverInfo endpoint is not blocked)");
        }
        return FormValidation.ok();
    }

    @RequirePOST
    public FormValidation doTestConnection(@AncestorInPath Item item, @QueryParameter(value="hosting") String hosting, @QueryParameter(value="serverAddress") String serverAddress, @QueryParameter(value="credentialId") String credentialId) {
        ConnectionResult connectionResult;
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (StringUtils.isBlank((CharSequence)credentialId)) {
            return FormValidation.error((String)"Authentication is optional, however it is required in order to test the connection.");
        }
        if (StringUtils.isBlank((CharSequence)hosting)) {
            return FormValidation.error((String)"Hosting type can't be blank.");
        }
        StandardCredentials credential = (StandardCredentials)CredentialsMatchers.firstOrNull(CredentialUtil.getAllSystemCredentials(item), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialId));
        if (credential == null) {
            return FormValidation.error((String)"Cannot find currently selected credentials");
        }
        HttpRequestProvider.ProxyBean proxyBean = ProxyUtil.createProxyBean();
        if (hosting.equals(HostingType.CLOUD.toString())) {
            Optional<XrayCloudCredentials> cloudClient = ClientFactory.getCloudClient(credential, proxyBean);
            if (!cloudClient.isPresent()) {
                return FormValidation.error((String)"Unable to create Xray Cloud client! Cloud instances only support credentials of type Username/Password");
            }
            connectionResult = cloudClient.get().testConnection();
        } else if (hosting.equals(HostingType.SERVER.toString())) {
            if (StringUtils.isBlank((CharSequence)serverAddress)) {
                return FormValidation.error((String)"Server address can't be empty");
            }
            Optional<XrayServerCredentials> xrayClient = ClientFactory.getServerClient(serverAddress, credential, proxyBean);
            if (!xrayClient.isPresent()) {
                return FormValidation.error((String)"Unable to create Xray Server/DC client! (Please check the type of the selected credentials)");
            }
            connectionResult = this.jiraServerTestConnection(serverAddress, xrayClient.get());
        } else {
            return FormValidation.error((String)"Hosting type not recognized.");
        }
        if (connectionResult.isSuccessful()) {
            return FormValidation.ok((String)"Connection: Success!");
        }
        String errorText = "Could not establish connection.\n" + this.limitStringSize(connectionResult.getErrorText()) + "\n\nFor more information please check the logs.";
        logger.error("Error while connecting to instance:\n{}", (Object)connectionResult.getErrorText());
        return FormValidation.error((String)errorText);
    }

    private ConnectionResult jiraServerTestConnection(String serverAddress, XrayServerCredentials xrayClient) {
        ConnectionResult jiraInstanceConnection = xrayClient.isJiraInstance();
        boolean isJiraInstance = jiraInstanceConnection.isSuccessful();
        if (!isJiraInstance) {
            String statusCode = jiraInstanceConnection.getStatusCode().map(String::valueOf).orElse("N/A");
            logger.error("URL provided is not from a Jira instance -> [status code: {}] {}/rest/api/2/serverInfo didn't return a valid result.", (Object)statusCode, (Object)serverAddress);
            return ConnectionResult.connectionFailed((String)"URL provided is not from a Jira instance (check if your /serverInfo endpoint is not blocked)");
        }
        return xrayClient.testConnection();
    }

    private String limitStringSize(String errorText) {
        return StringUtils.trim((String)StringUtils.substring((String)errorText, (int)0, (int)200));
    }

    private void checkForCompatibility() {
        for (XrayInstance instance : this.serverInstances) {
            if (instance.getHosting() != null) continue;
            instance.setHosting(HostingType.getDefaultType());
        }
    }

    @Nullable
    private StandardCredentials findCredential(@Nullable Item item, @Nullable String credentialId) {
        if (StringUtils.isBlank((CharSequence)credentialId)) {
            return null;
        }
        return (StandardCredentials)CredentialsMatchers.firstOrNull(CredentialUtil.getAllSystemCredentials(item), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialId));
    }

    private boolean credentialExists(@Nullable Item item, @Nullable String credentialId) {
        return this.findCredential(item, credentialId) != null;
    }
}

