/*
 * Decompiled with CFR 0.152.
 */
package com.microsoftopentechnologies.windowsazurestorage.service;

import com.azure.core.http.rest.PagedIterable;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.models.BlobItem;
import com.microsoftopentechnologies.windowsazurestorage.Messages;
import com.microsoftopentechnologies.windowsazurestorage.exceptions.WAStorageException;
import com.microsoftopentechnologies.windowsazurestorage.helper.AzureUtils;
import com.microsoftopentechnologies.windowsazurestorage.service.DownloadService;
import com.microsoftopentechnologies.windowsazurestorage.service.model.DownloadServiceData;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DownloadFromContainerService
extends DownloadService {
    private static final Logger LOGGER = Logger.getLogger(DownloadFromContainerService.class.getName());

    public DownloadFromContainerService(DownloadServiceData data) {
        super(data);
    }

    @Override
    public int execute() {
        DownloadServiceData serviceData = (DownloadServiceData)this.getServiceData();
        try {
            if (serviceData.isVerbose()) {
                this.println(Messages.AzureStorageBuilder_downloading());
            }
            BlobContainerClient container = AzureUtils.getBlobContainerReference(serviceData.getStorageAccountInfo(), serviceData.getContainerName(), false, true, null);
            int filesNeedDownload = this.scanBlobs(container, (PagedIterable<BlobItem>)container.listBlobs());
            this.println(Messages.AzureStorageBuilder_files_need_download_count(filesNeedDownload));
            this.waitForDownloadEnd();
        }
        catch (WAStorageException | IOException | URISyntaxException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            e.printStackTrace(this.error(Messages.AzureStorageBuilder_download_err(serviceData.getStorageAccountInfo().getStorageAccName())));
            this.setRunUnstable();
        }
        return this.getFilesDownloaded();
    }

    protected int scanBlobs(BlobContainerClient container, PagedIterable<BlobItem> blobItems) throws URISyntaxException, WAStorageException {
        DownloadServiceData serviceData = (DownloadServiceData)this.getServiceData();
        int filesNeedDownload = 0;
        for (BlobItem blobItem : blobItems) {
            if (!this.shouldDownload(serviceData.getIncludeFilesPattern(), serviceData.getExcludeFilesPattern(), blobItem.getName(), true)) continue;
            this.getExecutorService().submit(new DownloadService.DownloadThread(this, container.getBlobClient(blobItem.getName())));
            ++filesNeedDownload;
        }
        return filesNeedDownload;
    }
}

